/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.configurations.model;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import org.json.JSONObject;

@Entity
@Table(name="configurations")
public class Configurations
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ConfigurationEnum configuracao;
    @NotNull
    private String valor;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean isTrue() {
        return this.getValor().equals("true");
    }

    public ConfigurationEnum getConfiguracao() {
        return this.configuracao;
    }

    public void setConfiguracao(ConfigurationEnum configuracao) {
        this.configuracao = configuracao;
    }

    public LocalDate getDateValue() {
        return DateTimeUtil.toDate((String)this.valor, (FormatDate)FormatDate.US_DATE);
    }

    public BigDecimal getBigDecimal() {
        return StringUtil.toBigDecimal((String)this.valor);
    }

    public Integer getIntValue() {
        return StringUtil.toInt((String)this.getValor());
    }

    public Long getLongValue() {
        return StringUtil.toLong((String)this.getValor());
    }

    public Double getDoubleValue() {
        return StringUtil.toDouble((String)this.getValor());
    }

    public String getValor() {
        return this.valor;
    }

    public JSONObject getJsonValue() {
        return new JSONObject(this.valor);
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.configuracao);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configurations other = (Configurations)obj;
        return this.configuracao == other.configuracao;
    }
}

