/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dashboard;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.dashboard.DashBoardBoxForm;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.features.producaopainel.service.ProducaoPainelBoxService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="painel-box-producao", layout=MainLayout.class)
@PageTitle(value="Cadastro BOX Painel de Produ\u00e7\u00e3o")
@RolesAllowed(value={"PAINEL_PRODUCAO_BOX_VIEW"})
public class DashBoardBoxCadView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoPainelBoxService ppbs;
    private final DashBoardBoxForm form;
    private GridCrud<ProducaoPainelBox> crud;

    @Autowired
    public DashBoardBoxCadView(ProducaoPainelBoxService ppbs, DashBoardBoxForm form) {
        this.form = form;
        this.ppbs = ppbs;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        this.form.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
        this.crud = new GridCrud(ProducaoPainelBox.class);
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar BOX");
        btnAdd.setVisible(this.hasPermission("PAINEL_PRODUCAO_BOX_SAVE"));
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> this.form.create(this.getEstrutura(), null));
        Button btnEdit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar BOX");
        btnEdit.setVisible(this.hasPermission("PAINEL_PRODUCAO_BOX_SAVE"));
        btnEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um box para editar");
                return;
            }
            this.form.create(this.getEstrutura(), (ProducaoPainelBox)this.crud.getGrid().getSelectedItems().iterator().next());
        });
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{btnAdd, btnEdit}));
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPosicao().toString())).setHeader("Posi\u00e7\u00e3o");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getTipo().name())).setHeader("Tipo");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("PAINEL_PRODUCAO_BOX_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }
}

