/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.datastone.service;

import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.oportunidade.model.OportunidadeFile;
import br.com.system.app.features.oportunidade.model.OportunidadeFileItem;
import br.com.system.app.features.oportunidade.service.OportunidadeService;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoneOportunidade {
    @Autowired
    private OportunidadeService oportunidadeService;
    @Autowired
    private DataStoneService dataStoneService;

    public void goOf(OportunidadeFile of) {
        try {
            of.setUrlArquivo("");
            of.setStatusProcesso(StatusProcessoEnum.PROCESSANDO);
            this.oportunidadeService.save(of);
            Set itens = this.oportunidadeService.getItens(of);
            HashSet<String> cnpjs = new HashSet<String>();
            for (OportunidadeFileItem i : itens) {
                cnpjs.add(i.getCpfCnpj());
            }
            String url = this.dataStoneService.processarLote(of.getEstruturaUsuario(), cnpjs, of.getNomeArquivo(), Boolean.valueOf(false));
            of.setUrlArquivo(url);
            of.setStatusProcesso(StatusProcessoEnum.FINALIZADO);
            this.oportunidadeService.save(of);
        }
        catch (Exception ex) {
            of.setStatusProcesso(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            of.setObservacao(ex.getMessage());
            this.oportunidadeService.save(of);
        }
    }
}

