/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.datastone.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.datastone.model.DataStone;
import br.com.system.app.features.datastone.model.DataStoneContato;
import br.com.system.app.features.datastone.model.DataStoneContatoTipoEnum;
import br.com.system.app.features.datastone.model.DataStoneSocios;
import br.com.system.app.features.datastone.repository.DataStoneRepository;
import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoneProcessaService {
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private DataStoneRepository repository;
    @Autowired
    private DataStoneService dataStoneService;
    private JSONObject jsonDs;

    public void processar(Integer dataStoneArquivoId) throws Exception {
        if (dataStoneArquivoId == null) {
            throw new BusinessException("Arquivo n\u00e3o encontrado");
        }
        this.jsonDs = this.configurationsService.get(ConfigurationEnum.JSON_DATA_STONE).getJsonValue();
        boolean achei = false;
        while (!achei) {
            JSONObject j = this.getStatus(dataStoneArquivoId.toString());
            if (j.has("file")) {
                achei = true;
                InputStream input = new URL(j.getString("file")).openStream();
                String fileString = InputStreamUtil.toString((InputStream)input);
                String[] arr = fileString.split("\n");
                String[] cabecalho = arr[0].replace("\"", "").split(";");
                TipoProcessoEnum tipoPessoa = this.getTipoPessoa(cabecalho);
                for (int i = 1; i < arr.length; ++i) {
                    Object linha = arr[i];
                    while (arr[i].split(";").length < 20) {
                        linha = (String)linha + arr[++i];
                    }
                    this.getDs((String)linha, tipoPessoa, cabecalho);
                }
                continue;
            }
            SleepUtil.inSeconds((Integer)10);
        }
        if (!achei) {
            throw new BusinessException("Arquivo n\u00e3o encontrado no MarketingList");
        }
    }

    private DataStone getDs(String linha, TipoProcessoEnum tp, String[] cabecalho) throws Exception {
        String[] campos = linha.split(";");
        String cpfCnpj = tp.equals((Object)TipoProcessoEnum.CNPJ) ? StringUtil.normalizeCnpj((String)this.getCampo("cpfCnpj", tp, campos)) : StringUtil.normalizeCpf((String)this.getCampo("cpfCnpj", tp, campos));
        DataStone ds = this.dataStoneService.getByCpfCnpj(cpfCnpj);
        if (ds == null) {
            ds = new DataStone();
        }
        ds.setBairro(this.getCampo("bairro", tp, campos));
        ds.setCep(this.getCampo("cep", tp, campos));
        ds.setCidade(this.getCampo("cidade", tp, campos));
        ds.setComplemento(this.getCampo("complemento", tp, campos));
        ds.setCpfCnpj(cpfCnpj);
        ds.setDataHoraConsulta(LocalDateTime.now());
        ds.setDataNascimento(this.getNascimento(tp, campos));
        ds.setEstado(this.getCampo("estado", tp, campos));
        ds.setFuncionarios(this.getCampo("funcionarios", tp, campos));
        ds.setLogradouro(this.getCampo("logradouro", tp, campos));
        ds.setNome(this.getCampo("nome", tp, campos));
        ds.setNomeMae(this.getCampo("nomeMae", tp, campos));
        ds.setNumero(this.getCampo("numero", tp, campos));
        ds.setContatos(this.getContatos(ds, tp, campos, cabecalho));
        ds.setSocios(this.getSocios(ds, tp, campos));
        return (DataStone)this.repository.save((Object)ds);
    }

    private Set<DataStoneContato> getContatos(DataStone ds, TipoProcessoEnum tp, String[] campos, String[] cabecalho) {
        HashSet<DataStoneContato> lista = new HashSet<DataStoneContato>();
        int pos = tp.equals((Object)TipoProcessoEnum.CNPJ) ? this.jsonDs.getJSONObject("inicioContatos").getInt("pj") : this.jsonDs.getJSONObject("inicioContatos").getInt("pf");
        for (int i = pos; i < cabecalho.length; ++i) {
            DataStoneContato dsc;
            Object valor = campos[i].replace("\"", "");
            if (cabecalho[i].contains("DDD_CEL")) {
                if (TelefoneUtil.isValid((String)(valor = (String)valor + campos[i + 1].replace("\"", "")))) {
                    dsc = new DataStoneContato(ds, DataStoneContatoTipoEnum.CELULAR, (String)valor);
                    lista.add(dsc);
                }
                ++i;
                continue;
            }
            if (cabecalho[i].contains("DDD_FIX")) {
                if (TelefoneUtil.isValid((String)(valor = (String)valor + campos[i + 1].replace("\"", "")))) {
                    dsc = new DataStoneContato(ds, DataStoneContatoTipoEnum.FIXO, (String)valor);
                    lista.add(dsc);
                }
                ++i;
                continue;
            }
            if (!cabecalho[i].contains("EMAIL") || !ValidationUtil.isValidEmail((String)valor)) continue;
            dsc = new DataStoneContato(ds, DataStoneContatoTipoEnum.EMAIL, (String)valor);
            lista.add(dsc);
        }
        return lista;
    }

    private Set<DataStoneSocios> getSocios(DataStone ds, TipoProcessoEnum tp, String[] campos) {
        HashSet<DataStoneSocios> lista = new HashSet<DataStoneSocios>();
        if (!tp.equals((Object)TipoProcessoEnum.CNPJ)) {
            return lista;
        }
        int pos = 34;
        for (int i = 0; i < 2; ++i) {
            try {
                String cpf = StringUtil.numbersOnly((String)campos[pos].replace("\"", ""));
                if (!ValidationUtil.isValidCPF((String)cpf)) {
                    cpf = null;
                }
                DataStoneSocios dss = new DataStoneSocios();
                dss.setDataStone(ds);
                dss.setCpf(cpf);
                dss.setNomeSocio(campos[pos + 1].replace("\"", ""));
                dss.setTelefone1(StringUtil.numbersOnly((String)campos[pos + 2].replace("\"", "")));
                dss.setWhats1(Boolean.valueOf(campos[pos + 3].replace("\"", "").equals("Y")));
                dss.setTelefone2(StringUtil.numbersOnly((String)campos[pos + 4].replace("\"", "")));
                dss.setWhats2(Boolean.valueOf(campos[pos + 5].replace("\"", "").equals("Y")));
                dss.setEmail1(campos[pos + 6].replace("\"", ""));
                dss.setEmail2(campos[pos + 7].replace("\"", ""));
                lista.add(dss);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pos += 8;
        }
        return lista;
    }

    public JSONObject getStatus(String idArquivo) {
        try {
            ExternalConnection conexao = new ExternalConnection();
            conexao.addHeader("AUTHORIZATION", "Token 4c1c90d2-19c3-4a2a-aeed-b762b54e37df");
            return conexao.executeGet("https://api.datastone.com.br/v1/enrichment/" + idArquivo + "/result/").toJsonObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    private LocalDate getNascimento(TipoProcessoEnum tipo, String[] campos) throws Exception {
        if (tipo.equals((Object)TipoProcessoEnum.CNPJ)) {
            return null;
        }
        return DateTimeUtil.toDate((String)this.getCampo("dataNascimento", tipo, campos), (FormatDate)FormatDate.US_DATE);
    }

    private String getCampo(String campo, TipoProcessoEnum tipo, String[] campos) throws Exception {
        if (!this.jsonDs.has(campo)) {
            throw new Exception("Campo n\u00e3o existe");
        }
        JSONObject c = this.jsonDs.getJSONObject(campo);
        if (tipo.equals((Object)TipoProcessoEnum.CPF)) {
            if (c.isNull("pf")) {
                return "";
            }
            return campos[c.getInt("pf")].replace("\"", "").trim();
        }
        if (c.isNull("pj")) {
            return "";
        }
        if (c.getInt("pj") >= campos.length) {
            return "";
        }
        return campos[c.getInt("pj")].replace("\"", "").trim();
    }

    private TipoProcessoEnum getTipoPessoa(String[] arr) {
        for (String string : arr) {
            if (!string.equals("RAZAO")) continue;
            return TipoProcessoEnum.CNPJ;
        }
        return TipoProcessoEnum.CPF;
    }
}

