/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.kanbanpedidos.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidosDTO;
import br.com.system.app.features.kanbanpedidos.repository.KanbanPedidosRepository;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class KanbanPedidosService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private KanbanPedidosRepository kanbanPedidosRepository;

    public List<KanbanPedidos> getAllKanban(Long euId) {
        return this.kanbanPedidosRepository.findByEstruturaUsuarioId(euId);
    }

    public List<KanbanPedidos> getAllKanban(EstruturaUsuario eu) {
        return this.kanbanPedidosRepository.findByEstruturaUsuario(eu);
    }

    public KanbanPedidos getKanban(EstruturaUsuario eu, PedidoEtapa pe) {
        return this.kanbanPedidosRepository.findByEstruturaUsuarioAndPedidoEtapa(eu, pe);
    }

    public List<KanbanPedidos> getKanban(Long euId, PedidoTipoEnum pte) {
        return this.kanbanPedidosRepository.findByEstruturaUsuarioIdAndPedidoEtapaPedidoTipoOrderByPosition(euId, pte);
    }

    public List<KanbanPedidosDTO> getKanban(Estrutura estrutura) {
        return this.kanbanPedidosRepository.findForExportation(estrutura);
    }

    public List<KanbanPedidos> getKanban(Estrutura estrutura, String filterUsuario, String filterEtapa, PedidoTipoEnum pte, Boolean ativo, Pageable pageable) {
        filterUsuario = filterUsuario == null ? "" : filterUsuario;
        String string = filterEtapa = filterEtapa == null ? "" : filterEtapa;
        if (!filterUsuario.isEmpty() && filterEtapa.isEmpty()) {
            return this.kanbanPedidosRepository.findByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndEstruturaUsuarioUsuarioNomeContainsAndPedidoEtapaPedidoTipo(estrutura, ativo, filterUsuario, pte, pageable);
        }
        if (!filterEtapa.isEmpty() && filterUsuario.isEmpty()) {
            return this.kanbanPedidosRepository.findByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndPedidoEtapaNomeContainsAndPedidoEtapaPedidoTipo(estrutura, ativo, filterEtapa, pte, pageable);
        }
        if (!filterUsuario.isEmpty() && !filterEtapa.isEmpty()) {
            return this.kanbanPedidosRepository.findByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndEstruturaUsuarioUsuarioNomeContainsAndPedidoEtapaNomeContainsAndPedidoEtapaPedidoTipo(estrutura, ativo, filterUsuario, filterEtapa, pte, pageable);
        }
        return this.kanbanPedidosRepository.findByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndPedidoEtapaPedidoTipo(estrutura, ativo, pte, pageable);
    }

    public long countKanban(Estrutura estrutura, String filterUsuario, String filterEtapa, PedidoTipoEnum pte, boolean ativo) {
        filterUsuario = filterUsuario == null ? "" : filterUsuario;
        String string = filterEtapa = filterEtapa == null ? "" : filterEtapa;
        if (!filterUsuario.isEmpty() && filterEtapa.isEmpty()) {
            return this.kanbanPedidosRepository.countByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndEstruturaUsuarioUsuarioNomeContainsAndPedidoEtapaPedidoTipo(estrutura, Boolean.valueOf(ativo), filterUsuario, pte);
        }
        if (!filterEtapa.isEmpty() && filterUsuario.isEmpty()) {
            return this.kanbanPedidosRepository.countByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndPedidoEtapaNomeContainsAndPedidoEtapaPedidoTipo(estrutura, Boolean.valueOf(ativo), filterEtapa, pte);
        }
        if (!filterUsuario.isEmpty() && !filterEtapa.isEmpty()) {
            return this.kanbanPedidosRepository.countByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndEstruturaUsuarioUsuarioNomeContainsAndPedidoEtapaNomeContainsAndPedidoEtapaPedidoTipo(estrutura, Boolean.valueOf(ativo), filterUsuario, filterEtapa, pte);
        }
        return this.kanbanPedidosRepository.countByEstruturaUsuarioEstruturaAndEstruturaUsuarioAtivoAndPedidoEtapaPedidoTipo(estrutura, Boolean.valueOf(ativo), pte);
    }

    public KanbanPedidos save(KanbanPedidos kp) {
        if (kp.getEstruturaUsuario() == null) {
            throw new BusinessException("Informe estrutura usuario");
        }
        return (KanbanPedidos)this.kanbanPedidosRepository.save((Object)kp);
    }

    public void zerar(Estrutura e) {
        List lista = this.kanbanPedidosRepository.findByEstruturaUsuarioEstrutura(e);
        for (KanbanPedidos kp : lista) {
            this.kanbanPedidosRepository.delete((Object)kp);
        }
    }

    public void delete(Set<KanbanPedidos> lista) {
        for (KanbanPedidos kp : lista) {
            this.kanbanPedidosRepository.delete((Object)kp);
        }
    }

    public void delete(KanbanPedidos kp) {
        this.kanbanPedidosRepository.delete((Object)kp);
    }

    public void deleteByEstruturaUsuario(EstruturaUsuario eu) {
        this.kanbanPedidosRepository.deleteByEstruturaUsuario(eu);
    }

    public String export(Estrutura e) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoKanban-v2.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            int linha = 1;
            List lista = this.getKanban(e);
            for (KanbanPedidosDTO k : lista) {
                Row row = aba.createRow(linha);
                row.createCell(0).setCellValue(k.getUsuarioNome());
                row.createCell(1).setCellValue(k.getUsuarioLogin());
                row.createCell(2).setCellValue(k.getUsuarioPerfil());
                row.createCell(3).setCellValue(k.getUsuarioEquipe());
                row.createCell(4).setCellValue(k.getSituacao());
                row.createCell(5).setCellValue(k.getEtapaNome());
                row.createCell(6).setCellValue(k.getEtapaTipo());
                row.createCell(7).setCellValue(k.getPosition());
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception ex) {
            throw new BusinessException(ex.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

