/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.marketing.model.Marketing;
import br.com.system.app.features.marketing.model.MarketingStatus;
import br.com.system.app.features.marketing.model.MarketingTipo;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.storage.model.UrlSign;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplate;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplateCampos;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppTemplateService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vdurmont.emoji.EmojiParser;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class MarketingForm
extends Dialog
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MarketingService marketingService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppTemplateService whatsAppTemplateService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    private String nomeImg = null;
    private TempFileMultiBuffer mBufferImg;
    private Upload uploadImg;
    private String nomeFile = "";
    private TempFileMultiBuffer mBufferFile;
    private Upload uploadFile;
    private Marketing m;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void show(EstruturaUsuario eu, Marketing marketing, boolean oficial) {
        this.removeAll();
        this.setMaxWidth("600px");
        this.m = marketing == null ? new Marketing() : marketing;
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Criar nova campanha")});
        TextField txtNome = new TextField("Nome Campanha");
        txtNome.setWidthFull();
        if (this.m.getNomeCampanha() != null) {
            txtNome.setValue(this.m.getNomeCampanha());
        }
        this.add(new com.vaadin.flow.component.Component[]{txtNome});
        ComboBox cbTipo = new ComboBox("Tipo Campanha", (Object[])MarketingTipo.values());
        cbTipo.setItemLabelGenerator(Enum::name);
        cbTipo.setValue((Object)MarketingTipo.WHATSAPP);
        cbTipo.setVisible(false);
        this.add(new com.vaadin.flow.component.Component[]{cbTipo});
        cbTipo.setWidthFull();
        Span spanCampos = new Span();
        spanCampos.setVisible(oficial);
        ComboBox cbTemplate = new ComboBox("Selecione o Template", (Collection)this.whatsAppTemplateService.getByEstrutura(this.getEstrutura()));
        cbTemplate.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            Object dados = ((WhatsAppTemplate)e.getValue()).getTemplateText() == null ? "" : ((WhatsAppTemplate)e.getValue()).getTemplateText() + "\n";
            for (WhatsAppTemplateCampos wc : ((WhatsAppTemplate)e.getValue()).getCampos()) {
                dados = (String)dados + "Campo: " + wc.getCampo() + " Posi\u00e7\u00e3o: " + wc.getPosicao() + "\n";
            }
            if (((WhatsAppTemplate)e.getValue()).getObrigaImagem() != null && ((WhatsAppTemplate)e.getValue()).getObrigaImagem().booleanValue()) {
                dados = (String)dados + "\nEste template obriga o envio de uma imagem";
            }
            spanCampos.setText((String)dados);
        });
        cbTemplate.setItemLabelGenerator(WhatsAppTemplate::getTemplateName);
        cbTemplate.setVisible(oficial);
        if (this.m.getWhatsappTemplate() != null) {
            cbTemplate.setValue((Object)this.m.getWhatsappTemplate());
        }
        ComboBox cbConta = new ComboBox("Conta");
        cbConta.setItemLabelGenerator(WhatsAppConta::getNumero);
        cbConta.setItems((Collection)this.whatsappContaService.getContaByEstruturaMarketing(this.getEstrutura()));
        if (this.m.getWhatsappConta() != null) {
            cbConta.setValue((Object)this.m.getWhatsappConta());
        }
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Imagem(Opcional)")});
        this.add(new com.vaadin.flow.component.Component[]{this.createUploadImg()});
        if (this.m.getFilenameImg() != null) {
            this.uploadImg.setVisible(false);
            Span l = UIUtils.createSmallSpan((String)this.m.getFilenameImg());
            Button btnTrashImg = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH, (String)"Excluir imagem");
            btnTrashImg.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Excluir Imagem", "Confirma exclus\u00e3o da imagem?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)ec -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)ec -> {
                    try {
                        StorageUtil.deleteObject((String)this.m.getHashImagem());
                    }
                    catch (Exception e1) {
                        UIUtils.showError((String)("Erro ao excluir imagem " + e1.getMessage()));
                    }
                    this.m.setFilenameImg(null);
                    this.m.setHashImagem(null);
                    this.m = this.marketingService.save(this.m);
                    this.uploadImg.setVisible(true);
                    btnTrashImg.setVisible(false);
                    l.setVisible(false);
                    cd.close();
                });
            });
            UrlSign urlSign = StorageUtil.getUrlSign((String)this.m.getFilenameImg(), (String)"files-neosales");
            Anchor anchor = new Anchor(urlSign.getUrl(), new com.vaadin.flow.component.Component[]{l});
            anchor.setTarget("_blank");
            this.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{anchor, btnTrashImg}).setTransparent()});
        }
        TextArea ta = new TextArea("Mensagem");
        if (this.m.getMensagem() != null) {
            ta.setValue(EmojiParser.parseToUnicode((String)this.m.getMensagem()));
        }
        ta.setVisible(!oficial);
        NumberField intervalo = new NumberField("Intervalo entre envios(Segundos)");
        intervalo.setStep(10.0);
        intervalo.setVisible(false);
        if (this.m.getIntervalo() != null) {
            intervalo.setValue((Number)this.m.getIntervalo());
        } else {
            intervalo.setValue((Number)60.0);
        }
        ComboBox atendente = new ComboBox("Atendente (respostas)", (Collection)this.whatsAppAtendenteService.getByEstrutura(this.getEstrutura()));
        atendente.setItemLabelGenerator(WhatsAppAtendente::getNome);
        atendente.setWidthFull();
        if (marketing != null && marketing.getAtendente() != null) {
            atendente.setValue((Object)marketing.getAtendente());
        }
        TextField txtSubtitle = new TextField("Sub titulo");
        if (this.m.getSubtitle() != null) {
            txtSubtitle.setValue(this.m.getSubtitle());
        }
        TextField txtBotao1 = new TextField("Bot\u00e3o 1");
        if (this.m.getBotao1() != null) {
            txtBotao1.setValue(this.m.getBotao1());
        }
        TextField txtBotao2 = new TextField("Bot\u00e3o 2");
        if (this.m.getBotao2() != null) {
            txtBotao2.setValue(this.m.getBotao2());
        }
        TextField txtBotao3 = new TextField("Bot\u00e3o 3");
        if (this.m.getBotao3() != null) {
            txtBotao3.setValue(this.m.getBotao3());
        }
        this.add(new com.vaadin.flow.component.Component[]{new VerticalLayout(new com.vaadin.flow.component.Component[]{cbConta, cbTemplate, spanCampos})});
        this.add(new com.vaadin.flow.component.Component[]{atendente});
        this.add(new com.vaadin.flow.component.Component[]{ta});
        ta.setWidthFull();
        ta.setMinHeight("300px");
        if (!oficial) {
            HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
            h.add(new com.vaadin.flow.component.Component[]{txtSubtitle, txtBotao1, txtBotao2, txtBotao3});
            this.add(new com.vaadin.flow.component.Component[]{h});
        }
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"")});
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Lista de n\u00fameros")});
        String mensagem = "<ul>\n  <li>Defina a primeira linha com o nome das colunas</li>\n  <li>\u00c9 obrigat\u00f3rio uma coluna com o nome de #numero</li>\n  <li>As outras colunas voc\u00ea pode utilizar para substituir informa\u00e7\u00f5es na sua mensagem, ex: #nome</li>\n</ul>";
        Div div = new Div();
        div.getElement().setProperty("innerHTML", "<span>" + mensagem + "</span>");
        this.add(new com.vaadin.flow.component.Component[]{div});
        this.add(new com.vaadin.flow.component.Component[]{this.createUploadFile()});
        if (this.m.getId() != null && this.m.getFilename() != null) {
            this.uploadFile.setVisible(false);
            this.nomeFile = this.m.getFilename();
            List lista = this.marketingService.getByMarketing(this.m);
            Span l = UIUtils.createSmallSpan((String)("Total N\u00fameros " + lista.size()));
            Button btnTrash = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH, (String)"Excluir imagem");
            btnTrash.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Excluir Itens", "Confirma exclus\u00e3o de todos os itens?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)ec -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)ec -> {
                    this.nomeFile = null;
                    this.marketingService.deleteItens(this.m);
                    cd.close();
                    this.uploadFile.setVisible(true);
                    btnTrash.setVisible(false);
                    l.setVisible(false);
                });
            });
            this.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{l, btnTrash}).setTransparent()});
        }
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.COGS, (String)"Salvar campanha (N\u00e3o inicia automaticamente)");
        btnSalvar.setEnabled(this.m.getStatus() == null || this.m.getStatus().equals((Object)MarketingStatus.EM_CRIACAO) || this.m.getStatus().equals((Object)MarketingStatus.PAUSADA));
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                if (txtNome.getValue() == null || txtNome.getValue().isEmpty()) {
                    UIUtils.showNotification((String)"Nome da campanha \u00e9 obrigatorio\n");
                    return;
                }
                if (!oficial && this.nomeImg == null && (ta.getValue() == null || ta.getValue().isEmpty())) {
                    UIUtils.showNotification((String)"Imagem ou Mensagem s\u00e3o obrigatorios\n");
                    return;
                }
                if (this.nomeFile == null || this.nomeFile.isEmpty()) {
                    UIUtils.showNotification((String)"Arquivo com n\u00fameros \u00e9 obrigatorio\n");
                    return;
                }
                if (txtBotao1.getValue() != null && txtBotao1.getValue().length() > 20) {
                    UIUtils.showNotification((String)"Bot\u00e3o1 excedeu o tamanho de 20 caracteres\n");
                    return;
                }
                if (txtBotao2.getValue() != null && txtBotao2.getValue().length() > 20) {
                    UIUtils.showNotification((String)"Bot\u00e3o2 excedeu o tamanho de 20 caracteres\n");
                    return;
                }
                if (txtBotao3.getValue() != null && txtBotao3.getValue().length() > 20) {
                    UIUtils.showNotification((String)"Bot\u00e3o3 excedeu o tamanho de 20 caracteres\n");
                    return;
                }
                if (ta.getValue().length() > 1024) {
                    UIUtils.showNotification((String)"Mensagem excedeu 1024 caracteres\n");
                    return;
                }
                if (cbTemplate.getValue() != null && ((WhatsAppTemplate)cbTemplate.getValue()).getObrigaImagem() != null && ((WhatsAppTemplate)cbTemplate.getValue()).getObrigaImagem().booleanValue() && (this.nomeImg == null || this.nomeImg.isEmpty())) {
                    UIUtils.showNotification((String)"Este template obriga o envio de uma imagem\n");
                    return;
                }
                if (cbConta.getValue() == null) {
                    UIUtils.showNotification((String)"Selecione uma conta");
                    return;
                }
                this.m.setDataHoraCriacao(LocalDateTime.now());
                this.m.setEstruturaUsuario(eu);
                if (this.m.getFilenameImg() == null) {
                    this.m.setFilenameImg(this.nomeImg);
                }
                this.m.setFilename(this.nomeFile);
                this.m.setMensagem(EmojiParser.parseToHtmlDecimal((String)ta.getValue()));
                this.m.setNomeCampanha(txtNome.getValue());
                this.m.setStatus(MarketingStatus.EM_CRIACAO);
                this.m.setTipo(MarketingTipo.WHATSAPP);
                this.m.setIntervalo(Integer.valueOf(((Double)intervalo.getValue()).intValue()));
                this.m.setAtendente((WhatsAppAtendente)atendente.getValue());
                this.m.setSubtitle(txtSubtitle.getValue());
                this.m.setBotao1(txtBotao1.getValue());
                this.m.setBotao2(txtBotao2.getValue());
                this.m.setBotao3(txtBotao3.getValue());
                if (cbConta.getValue() != null) {
                    this.m.setWhatsappConta((WhatsAppConta)cbConta.getValue());
                }
                if (cbTemplate.getValue() != null) {
                    this.m.setWhatsappTemplate((WhatsAppTemplate)cbTemplate.getValue());
                } else {
                    this.m.setWhatsappTemplate(null);
                }
                this.marketingService.salvarCampanha(eu, this.m, this.mBufferImg.getInputStream(), this.mBufferFile.getInputStream());
                UIUtils.showNotification((String)("Campanha " + (marketing == null ? "criada" : "alterada") + " com sucesso. Para iniciar clique no bot\u00e3o Iniciar Campanha"));
                this.close();
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)("Erro ao criar campanha " + (ex.getMessage() == null ? "" : ex.getMessage())));
                return;
            }
            this.uploadImg.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
            this.nomeImg = null;
            this.mBufferFile.clear();
            this.mBufferImg.clear();
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnFechar, btnSalvar})});
        this.open();
    }

    private Upload createUploadFile() {
        this.mBufferFile = new TempFileMultiBuffer();
        this.uploadFile = new Upload((Receiver)this.mBufferFile);
        this.uploadFile.setMaxFiles(1);
        this.uploadFile.setAcceptedFileTypes(new String[]{".xlsx"});
        this.uploadFile.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeFile = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado com sucesso");
        });
        this.uploadFile.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        return this.uploadFile;
    }

    private Upload createUploadImg() {
        this.mBufferImg = new TempFileMultiBuffer();
        this.uploadImg = new Upload((Receiver)this.mBufferImg);
        this.uploadImg.setMaxFiles(1);
        this.uploadImg.setAcceptedFileTypes(new String[]{".png", ".jpg", ".jpeg"});
        this.uploadImg.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeImg = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado");
        });
        this.uploadImg.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, aceita apenas imagem"));
        return this.uploadImg;
    }
}

