/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing.service;

import br.com.system.app.features.marketing.model.Marketing;
import br.com.system.app.features.marketing.model.MarketingItem;
import br.com.system.app.features.marketing.model.MarketingItemCampos;
import br.com.system.app.features.marketing.model.MarketingItemStatus;
import br.com.system.app.features.marketing.model.MarketingStatus;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.storage.model.UrlSign;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplateCampos;
import br.com.system.app.features.whatsapp.service.WhatsAppBloqueioService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppMoorseApi;
import com.vdurmont.emoji.EmojiParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MarketingSendService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppMoorseApi moorseApi;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private MarketingService marketingService;
    @Autowired
    private WhatsAppBloqueioService whatsAppBloqueioService;
    @Autowired
    private TelefoneService telefoneService;

    public boolean checkIntegration(WhatsAppConta wc) {
        return this.whatsappContaService.checkIntegration(wc);
    }

    @Async(value="asyncDefault")
    public void iniciarCampanha(Marketing m, WhatsAppConta wc) {
        try {
            m.setStatus(MarketingStatus.PROCESSANDO);
            this.marketingService.save(m);
            List itens = this.marketingService.getByMarketing(m);
            for (MarketingItem item : itens) {
                try {
                    if (!this.marketingService.getById(m.getId()).getStatus().equals((Object)MarketingStatus.PROCESSANDO) || !item.getStatus().equals((Object)MarketingItemStatus.AGUARDANDO)) continue;
                    this.enviar(item, wc);
                }
                catch (Exception exception) {}
            }
            m.setStatus(MarketingStatus.FINALIZADA);
            this.marketingService.save(m);
        }
        catch (Exception e) {
            m.setStatus(MarketingStatus.ERRO);
            m.setObservacao(e.getMessage());
            this.marketingService.save(m);
        }
    }

    public MarketingItem enviar(MarketingItem item, WhatsAppConta wc) {
        try {
            if (wc == null) {
                wc = (WhatsAppConta)this.whatsappContaService.getContaByEstruturaMarketing(item.getMarketing().getEstruturaUsuario().getEstrutura()).get(0);
            }
            if (this.telefoneService.isNaoPerturbe(item.getNumero())) {
                throw new BusinessException("Este n\u00famero esta na lista de nao perurbe");
            }
            String moorseId = wc.getMooseId();
            WhatsAppHave have = this.whatsAppHaveService.getHave(item.getNumero());
            if (have == null || !have.getHave().booleanValue()) {
                throw new BusinessException("Este n\u00famero n\u00e3o tem whatsapp");
            }
            if (this.whatsAppBloqueioService.isBloqueado(item.getMarketing().getEstruturaUsuario().getEstrutura(), moorseId)) {
                throw new BusinessException("Numero bloqueado");
            }
            item.setNumeroWhats(have.getNumeroWhats());
            JSONObject jsonReturn = wc.getApiOficial() == false ? this.enviarWeb(item, moorseId) : this.enviarOficial(item, moorseId);
            if (jsonReturn == null || !jsonReturn.has("data") || !jsonReturn.getJSONObject("data").has("control")) {
                item.setMessageId(null);
                item.setStatus(MarketingItemStatus.ERRO);
            } else {
                item.setMessageId(jsonReturn.getJSONObject("data").getString("control"));
                item.setStatus(MarketingItemStatus.PROCESSANDO);
            }
        }
        catch (Exception ex) {
            item.setErro(ex.getMessage());
            item.setStatus(MarketingItemStatus.ERRO);
        }
        return this.marketingService.saveItem(item);
    }

    private JSONObject enviarWeb(MarketingItem item, String moorseId) throws Exception {
        List campos = this.marketingService.getCampos(item);
        String nome = "Jo\u00e3o";
        if (!campos.isEmpty()) {
            for (MarketingItemCampos mic : campos) {
                if (!mic.getCampo().contains("#nome")) continue;
                nome = mic.getValor();
            }
        }
        String mensagem = this.marketingService.getMensagem(item);
        JSONObject jsonReturn = null;
        this.moorseApi.cadastrarContato(item.getNumeroWhats(), nome, moorseId);
        if (item.getMarketing().getHashImagem() != null && !item.getMarketing().getHashImagem().isEmpty()) {
            jsonReturn = this.moorseApi.sendFile(item.getNumeroWhats(), item.getMarketing().getHashImagem(), item.getMarketing().getFilenameImg(), moorseId, Boolean.FALSE);
        }
        if (mensagem != null && !mensagem.isEmpty()) {
            if (mensagem.length() > 1024) {
                throw new BusinessException("Mensagem " + mensagem + " ultrapassou os 1024 caracteres");
            }
            jsonReturn = item.getMarketing().getBotao1() != null && !item.getMarketing().getBotao1().isEmpty() ? this.moorseApi.sendButton(item.getNumeroWhats(), EmojiParser.parseToUnicode((String)mensagem), item.getMarketing().getSubtitle(), this.getButtons(item.getMarketing()), moorseId) : this.moorseApi.sendText(item.getNumeroWhats(), EmojiParser.parseToUnicode((String)mensagem), moorseId);
        }
        return jsonReturn;
    }

    private List<String> getButtons(Marketing m) {
        ArrayList<String> buttons = new ArrayList<String>();
        if (m.getBotao1() != null) {
            buttons.add(m.getBotao1());
        }
        if (m.getBotao2() != null) {
            buttons.add(m.getBotao2());
        }
        if (m.getBotao3() != null) {
            buttons.add(m.getBotao3());
        }
        return buttons;
    }

    public static void main(String[] args) {
        try {
            MarketingSendService s = new MarketingSendService();
            Marketing m = new Marketing();
            m.setHashImagem("9a4b8236-626e-4c0e-aceb-206e42f957bd.jpg");
            MarketingItem item = new MarketingItem();
            item.setMarketing(m);
            s.enviarOficial(item, "b33f458d-1228-40e9-8494-01a1a3e98801");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONObject enviarOficial(MarketingItem item, String moorseId) throws Exception {
        List campos;
        JSONArray arrComp = new JSONArray();
        if (item.getMarketing().getHashImagem() != null && !item.getMarketing().getHashImagem().isEmpty()) {
            JSONObject paramImagem = new JSONObject();
            paramImagem.put("type", (Object)"image");
            JSONObject image = new JSONObject();
            UrlSign urlSign = StorageUtil.getUrlSign((String)item.getMarketing().getHashImagem(), (String)"files-neosales");
            image.put("link", (Object)urlSign.getUrl());
            paramImagem.put("image", (Object)image);
            JSONObject header = new JSONObject();
            header.put("type", (Object)"header");
            header.append("parameters", (Object)paramImagem);
            arrComp.put((Object)header);
        }
        if (!(campos = this.marketingService.getCampos(item)).isEmpty()) {
            Set camposTemplate = item.getMarketing().getWhatsappTemplate().getCampos();
            JSONArray arrParam = new JSONArray();
            for (MarketingItemCampos campo : campos) {
                boolean tem = false;
                for (WhatsAppTemplateCampos wtc : camposTemplate) {
                    if (!wtc.getCampo().equals(campo.getCampo())) continue;
                    tem = true;
                    break;
                }
                if (!tem) continue;
                JSONObject param = new JSONObject();
                param.put("type", (Object)"text");
                param.put("text", (Object)campo.getValor());
                arrParam.put((Object)param);
            }
            JSONObject comp = new JSONObject();
            comp.put("type", (Object)"body");
            comp.put("parameters", (Object)arrParam);
            arrComp.put((Object)comp);
        }
        return this.moorseApi.sendTemplate(item.getNumeroWhats(), arrComp, moorseId, item.getMarketing().getWhatsappTemplate().getTemplateName());
    }
}

