/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.migracaoestrutura.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteAnexo;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteProduto;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.service.ClienteAnexoService;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.migracaoestrutura.model.MigracaoEstrutura;
import br.com.system.app.features.migracaoestrutura.repository.MigracaoEstruturaRepository;
import br.com.system.app.features.migracaoestrutura.service.MigracaoEstruturaUtil;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoAnexo;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.model.PedidoMovimentacao;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemSolicitacaoService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pessoa.model.Pessoa;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MigracaoEstruturaThread
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MigracaoEstruturaRepository migracaoEstruturaRepository;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private MigracaoEstruturaUtil util;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoItemEtapaService pedidoItemEtapaService;
    @Autowired
    private PedidoItemSolicitacaoService pedidoItemSolicitacaoService;
    @Autowired
    private ClienteProdutoService clienteProdutoService;
    @Autowired
    private PedidoAnexoService pedidoAnexoService;
    @Autowired
    private PedidoMovimentacaoService pedidoMovimentacaoService;
    @Autowired
    private ClienteAnexoService clienteAnexoService;

    @Async(value="asyncDefault")
    public void doMigration(Cliente o, Estrutura destino, EstruturaUsuario master, boolean forcar) {
        Thread.currentThread().setName("asyncDefault-migracao-do-migration");
        try {
            MigracaoEstrutura me = this.migracaoEstruturaRepository.findByOrigem(o);
            if (me != null && !forcar) {
                System.out.println("Ja foi migrado");
                return;
            }
            if (me == null) {
                me = new MigracaoEstrutura();
            }
            Cliente d = this.doCliente(o, destino, master);
            this.doProduto(o, d, master);
            this.doAnexo(o, d, master);
            this.doPedido(o, d, master);
            me.setDestino(d);
            me.setOrigem(o);
            this.migracaoEstruturaRepository.save((Object)me);
        }
        catch (Exception e) {
            System.out.println("ERRO: " + e.getMessage());
        }
    }

    private Cliente doCliente(Cliente o, Estrutura destino, EstruturaUsuario master) {
        Cliente d = this.clienteService.getAndCreateCliente(master, o.getCpfCnpj(), o.getNome(), this.getContato(o.getClienteContato()));
        if (d == null) {
            d = new Cliente();
        }
        d.setBairro(o.getBairro());
        d.setCep(o.getCep());
        d.setCidade(o.getCidade());
        d.setClienteClassificacao(o.getClienteClassificacao());
        d.setClienteResponsavel(this.getResp(o.getClienteResponsavel(), d, master));
        d.setComplemento(o.getComplemento());
        d.setCpfCnpj(o.getCpfCnpj());
        d.setCpfContaOnline(o.getCpfContaOnline());
        d.setDataHoraAtualizacao(o.getDataHoraAtualizacao());
        d.setEstado(o.getEstado());
        d.setEstrutura(destino);
        d.setInscricaoEstadual(o.getInscricaoEstadual());
        d.setLoginContaOnline(o.getLoginContaOnline());
        d.setLoginGestor(o.getLoginGestor());
        d.setLogradouro(o.getLogradouro());
        d.setNome(o.getNome());
        d.setNumero(o.getNumero());
        d.setObservacao(o.getObservacao());
        d.setPessoas(this.getPessoa(o.getPessoas(), d));
        d.setSenhaContaOnline(o.getSenhaContaOnline());
        d.setSenhaGestor(o.getSenhaGestor());
        d.setTags(o.getTags());
        d.setTempoMedio(o.getTempoMedio());
        return this.clienteService.salvar(d, master);
    }

    private void doPedido(Cliente o, Cliente d, EstruturaUsuario master) {
        List pedidos = this.pedidoService.getByCliente(o);
        for (Pedido po : pedidos) {
            try {
                Pedido pd = this.pedidoService.getByNumeroAndEstrutura(po.getNumero(), d.getEstrutura());
                if (pd != null) continue;
                pd = new Pedido();
                pd.setAtividades(po.getAtividades());
                pd.setCliente(d);
                pd.setClusterOrigem(po.getClusterOrigem());
                pd.setComplementos(this.getComplementos(po));
                pd.setCompromissoMensal(po.getCompromissoMensal());
                pd.setDataCadastro(po.getDataCadastro());
                pd.setDataHoraAtualizacao(po.getDataHoraAtualizacao());
                pd.setDataHoraOperadora(po.getDataHoraOperadora());
                pd.setDataRetornoFuturo(po.getDataRetornoFuturo());
                pd.setEstruturaUsuario(this.util.getEu(po.getEstruturaUsuario(), d.getEstrutura(), master));
                pd.setEstruturaUsuarioAdm(po.getEstruturaUsuarioAdm() == null ? null : this.util.getEu(po.getEstruturaUsuarioAdm(), d.getEstrutura(), master));
                pd.setHashProposta(po.getHashProposta());
                if (o.getEstrutura().getEstruturaTipo().equals((Object)d.getEstrutura().getEstruturaTipo())) {
                    pd.setItens(this.getPedidoItem(po, pd));
                } else {
                    pd.setItens(new HashSet());
                }
                pd.setNomeConsultorOperadora(po.getNomeConsultorOperadora());
                pd.setNotasFiscais(po.getNotasFiscais());
                pd.setNumero(po.getNumero());
                pd.setNumeroPedidoOrigem(po.getNumeroPedidoOrigem());
                pd.setNumeroPedidoVinculado(po.getNumeroPedidoVinculado());
                PedidoOrigem origem = this.pedidoOrigemService.getOrigemAtividade(d.getEstrutura());
                pd.setPedidoEtapa(this.pedidoEtapaService.getAndCreate(d.getEstrutura(), po.getPedidoEtapa().getNome(), origem, po.getPedidoTipo()));
                pd.setPedidoOrigem(origem);
                pd.setPedidoTipo(po.getPedidoTipo());
                pd.setPercentualDesconto(po.getPercentualDesconto());
                pd.setPercentualTroca(po.getPercentualTroca());
                pd.setRevisao(po.getRevisao());
                if (po.getTags() != null && po.getTags().isBlank()) {
                    pd.setTags(po.getTags() + ",#MIGRADO");
                } else {
                    pd.setTags("#MIGRADO");
                }
                pd.setTipoNegociacao(po.getTipoNegociacao());
                pd.setTotal(po.getTotal());
                pd.setValorFaturaOrigem(po.getValorFaturaOrigem());
                pd = this.pedidoService.salvar(pd);
                this.doPedidoAnexo(po, pd, master);
                this.doPedidoMovimentacao(po, pd, master);
            }
            catch (Exception e) {
                System.out.println("Migracao " + po.getNumero() + " ERRO " + e.getMessage());
            }
        }
    }

    private Set<PedidoItem> getPedidoItem(Pedido po, Pedido pd) {
        HashSet<PedidoItem> retorno = new HashSet<PedidoItem>();
        Set itens = this.pedidoService.getItens(po);
        for (PedidoItem pio : itens) {
            PedidoItem pid = new PedidoItem();
            pid.setComplementos(pio.getComplementos());
            pid.setConsiderarProducao(pio.getConsiderarProducao());
            pid.setDataHoraAtualizacao(pio.getDataHoraAtualizacao());
            pid.setDataPortabilidade(pio.getDataPortabilidade());
            pid.setDataReferencia(pio.getDataReferencia());
            pid.setDdd(pio.getDdd());
            pid.setDescontoPorItem(pio.getDescontoPorItem());
            pid.setGrupo(pio.getGrupo());
            pid.setItem(pio.getItem());
            pid.setNumero(pio.getNumero());
            pid.setPedido(pd);
            pid.setPedidoItemEtapa(this.pedidoItemEtapaService.getAndCreate(pd.getEstruturaUsuario().getEstrutura(), pio.getPedidoItemEtapa().getNome(), po.getPedidoOrigem()));
            PedidoItemSolicitacao pis = this.pedidoItemSolicitacaoService.getByNome(pd.getEstruturaUsuario().getEstrutura().getEstruturaTipo(), pio.getPedidoItemSolicitacao().getNome());
            pid.setPedidoItemSolicitacao(pis);
            pid.setProduto(pio.getProduto());
            pid.setQuantidade(pio.getQuantidade());
            pid.setValorUnitario(pio.getValorUnitario());
            retorno.add(pid);
        }
        return retorno;
    }

    private void doProduto(Cliente o, Cliente d, EstruturaUsuario master) {
        List produtos = this.clienteProdutoService.getByCliente(o);
        for (ClienteProduto po : produtos) {
            try {
                ClienteProduto pd = new ClienteProduto();
                pd.setCliente(d);
                pd.setDataAtivacao(po.getDataAtivacao());
                pd.setDataFidelidade(po.getDataFidelidade());
                pd.setClienteFornecedor(po.getClienteFornecedor());
                pd.setQuantidade(po.getQuantidade());
                pd.setClienteProdutoCadastro(po.getClienteProdutoCadastro());
                pd.setValor(po.getValor());
                this.clienteProdutoService.salvar(pd, master);
            }
            catch (Exception exception) {}
        }
    }

    private Set<ClienteContato> getContato(Set<ClienteContato> ccOrigem) {
        HashSet<ClienteContato> retorno = new HashSet<ClienteContato>();
        for (ClienteContato co : ccOrigem) {
            try {
                ClienteContato cd = new ClienteContato();
                cd.setTipo(co.getTipo());
                cd.setValor(co.getValor());
                retorno.add(cd);
            }
            catch (Exception exception) {}
        }
        return retorno;
    }

    private Set<ClienteResponsavel> getResp(Set<ClienteResponsavel> crOrigem, Cliente destino, EstruturaUsuario master) {
        HashSet<ClienteResponsavel> retorno = new HashSet<ClienteResponsavel>();
        if (destino.getClienteResponsavel().size() > 0) {
            retorno.addAll(destino.getClienteResponsavel());
        }
        for (ClienteResponsavel cro : crOrigem) {
            try {
                ClienteResponsavel crd = new ClienteResponsavel();
                crd.setCliente(destino);
                crd.setFuncao(cro.getFuncao());
                crd.setEstruturaUsuario(this.util.getEu(cro.getEstruturaUsuario(), destino.getEstrutura(), master));
                retorno.add(crd);
            }
            catch (Exception exception) {}
        }
        return retorno;
    }

    private Set<Pessoa> getPessoa(Set<Pessoa> pessoaOrigem, Cliente destino) {
        HashSet<Pessoa> retorno = new HashSet<Pessoa>();
        if (destino.getPessoas().size() > 0) {
            retorno.addAll(destino.getPessoas());
        }
        for (Pessoa po : pessoaOrigem) {
            try {
                Pessoa pd = new Pessoa();
                pd.setCelular(po.getCelular());
                pd.setCliente(destino);
                pd.setCpf(po.getCpf());
                pd.setEmail(po.getEmail());
                pd.setNascimento(po.getNascimento());
                pd.setNome(po.getNome());
                pd.setPapel(po.getPapel());
                pd.setRg(po.getRg());
                retorno.add(pd);
            }
            catch (Exception exception) {}
        }
        return retorno;
    }

    private String getComplementos(Pedido po) {
        try {
            String c = po.getComplementos() + "\nPedido Origem: " + po.getPedidoOrigem().getNome() + "\nItens da Atividade\n";
            Set itens = this.pedidoService.getItens(po);
            int i = 1;
            for (PedidoItem item : itens) {
                c = c + "Item " + i + "\n";
                c = c + "Produto " + item.getProduto().getNome() + " Sol " + item.getPedidoItemSolicitacao().getNome() + " QT " + item.getQuantidade() + " VL " + String.valueOf(item.getValorUnitario());
                c = c + " Data Ref " + String.valueOf(item.getDataReferencia()) + " Data Port " + String.valueOf(item.getDataPortabilidade()) + " Numero " + item.getNumero() + " Etapa " + item.getPedidoItemEtapa().getNome();
                c = c + " Compl " + item.getComplementos() + "\n";
            }
            return c;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void doPedidoAnexo(Pedido pOrigem, Pedido pDestino, EstruturaUsuario master) {
        List anexos = this.pedidoAnexoService.getAnexo(pOrigem);
        for (PedidoAnexo ao : anexos) {
            try {
                PedidoAnexo ad = new PedidoAnexo();
                ad.setDataHora(ao.getDataHora());
                ad.setEstruturaUsuario(this.util.getEu(ao.getEstruturaUsuario(), pDestino.getEstruturaUsuario().getEstrutura(), master));
                ad.setHashArquivo(ao.getHashArquivo());
                ad.setNomeArquivo(ao.getNomeArquivo());
                ad.setPedido(pDestino);
                this.pedidoAnexoService.save(ad);
            }
            catch (Exception exception) {}
        }
    }

    private void doPedidoMovimentacao(Pedido po, Pedido pd, EstruturaUsuario master) {
        for (PedidoMovimentacao pm : this.pedidoMovimentacaoService.getByPedido(po)) {
            PedidoMovimentacao pmd = new PedidoMovimentacao();
            pmd.setDataHora(pm.getDataHora());
            pmd.setDescricao(pm.getDescricao());
            pmd.setEstruturaUsuario(this.util.getEu(pm.getEstruturaUsuario(), pd.getEstruturaUsuario().getEstrutura(), master));
            pmd.setPedido(pd);
            this.pedidoMovimentacaoService.save(pmd);
        }
    }

    private void doAnexo(Cliente o, Cliente d, EstruturaUsuario master) {
        List anexos = this.clienteAnexoService.getAnexo(o);
        for (ClienteAnexo ao : anexos) {
            try {
                ClienteAnexo ad = new ClienteAnexo();
                ad.setCliente(d);
                ad.setDataHora(ao.getDataHora());
                ad.setHashArquivo(ao.getHashArquivo());
                ad.setNomeArquivo(ao.getNomeArquivo());
                ad.setEstruturaUsuario(this.util.getEu(ao.getEstruturaUsuario(), d.getEstrutura(), master));
                this.clienteAnexoService.save(ad);
            }
            catch (Exception exception) {}
        }
    }
}

