/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.migracaoestrutura.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.service.UsuarioService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigracaoEstruturaUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaUsuarioService eus;

    public EstruturaUsuario getEu(EstruturaUsuario euOrigem, Estrutura estruturaDestino, EstruturaUsuario master) {
        try {
            String login = euOrigem.getUsuario().getLogin().split("@")[0];
            Usuario usuario = this.usuarioService.getByLogin(login + "@" + estruturaDestino.getNome());
            if (usuario != null) {
                EstruturaUsuario eu = (EstruturaUsuario)this.eus.getByUsuarioAndEstrutura(usuario, estruturaDestino).get();
                return eu;
            }
            UsuarioDTO dto = new UsuarioDTO();
            dto.setAtivo(Boolean.FALSE);
            dto.setDataCadastro(LocalDate.now());
            dto.setEmail(login + "@" + estruturaDestino.getNome() + ".com.br");
            dto.setLogin(login + "@" + estruturaDestino.getNome());
            dto.setNome(login + "@" + estruturaDestino.getNome());
            dto.setMaster(Boolean.valueOf(false));
            dto.setPerfil(UsuarioPerfilEnum.COMERCIAL);
            dto.setSaldo(BigDecimal.ZERO);
            UsuarioDTO kct = this.usuarioService.saveAndCreate(dto, estruturaDestino);
            EstruturaUsuario eu = this.eus.getById(kct.getEstruturaUsuarioId());
            this.usuarioService.saveCreditos(eu, euOrigem.getUsuario().getSaldoCreditos());
            return eu;
        }
        catch (Exception e) {
            return master;
        }
    }
}

