/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes;

import br.com.system.app.MainLayout;
import br.com.system.app.features.notificacoes.components.NotificacoesFilter;
import br.com.system.app.features.notificacoes.components.NotificacoesPaginator;
import br.com.system.app.features.notificacoes.components.NotificacoesResultList;
import br.com.system.app.features.notificacoes.model.Notificacoes;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.PermitAll;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@PageTitle(value="Minhas notifica\u00e7\u00f5es")
@Route(value="notificacoes", layout=MainLayout.class)
@PermitAll
public class NotificacoesView
extends Div
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private List<Notificacoes> notificacoes;
    private final NotificacoesService notificacoesService;
    private final NotificacoesPaginator notificacoesPaginator;
    private final NotificacoesFilter notificacoesFilter;
    private final NotificacoesResultList notificacoesResultList;

    @Autowired
    public NotificacoesView(NotificacoesService notificacoesService) {
        this.notificacoesService = notificacoesService;
        this.getStyle().set("display", "flex");
        this.getStyle().set("flex-direction", "column");
        this.setHeightFull();
        this.setWidthFull();
        Page page = notificacoesService.getNotificacoes(this.getEu(), NotificacoesService.StatusEnum.TODOS, "", (Pageable)PageRequest.of((int)0, (int)30));
        this.setNotificacoes(page.getContent());
        this.notificacoesFilter = new NotificacoesFilter();
        this.notificacoesFilter.addFilterEventListener((arg_0, arg_1) -> this.handleFilter(arg_0, arg_1));
        this.notificacoesResultList = new NotificacoesResultList();
        this.notificacoesResultList.addChangeStatusListener((arg_0, arg_1, arg_2) -> this.handleChangeStatus(arg_0, arg_1, arg_2));
        this.notificacoesResultList.setItems(this.notificacoes);
        this.notificacoesPaginator = new NotificacoesPaginator();
        this.notificacoesPaginator.updateState(page);
        this.notificacoesPaginator.addChangePageListener(arg_0 -> this.handlePageChange(arg_0));
        this.add(new Component[]{this.notificacoesFilter, this.notificacoesResultList, this.notificacoesPaginator});
    }

    public final void setNotificacoes(List<Notificacoes> notificacoes) {
        this.notificacoes = notificacoes;
    }

    private void handleFilter(String filterText, NotificacoesService.StatusEnum filterStatus) {
        this.refreshData(filterText, filterStatus, 0);
    }

    private void handlePageChange(int currentPage) {
        int totalPages = this.notificacoesPaginator.getTotalPages();
        if (currentPage < totalPages && currentPage >= 0) {
            this.refreshData(this.notificacoesFilter.getFilter(), this.notificacoesFilter.getStatus(), currentPage);
        }
    }

    private void handleChangeStatus(Notificacoes item, NotificacoesResultList.ToggleStatusButton button, NotificacoesResultList.Summary summary) {
        Notificacoes toggle = this.notificacoesService.toggle(item.getId(), this.getEu());
        button.setLido(toggle.isLido());
        summary.setLido(toggle.isLido());
    }

    private void refreshData(String filterText, NotificacoesService.StatusEnum filterStatus, int currentPage) {
        Page page = this.notificacoesService.getNotificacoes(this.getEu(), filterStatus, filterText, (Pageable)PageRequest.of((int)currentPage, (int)30));
        this.setNotificacoes(page.getContent());
        this.notificacoesPaginator.updateState(page);
        this.notificacoesResultList.setItems(this.notificacoes);
    }
}

