/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.oportunidade.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OportunidadeLimiteService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ConfigurationsService configurationService;
    @Autowired
    private EstruturaComplementoService complementoService;

    public Integer getLimiteDiarioOportunidade(Estrutura estrutura) {
        Integer limiteDiario = this.complementoService.getComplementos(estrutura).getLimiteDiarioOportunidade();
        if (limiteDiario == null) {
            limiteDiario = StringUtil.toInt((String)this.configurationService.get(ConfigurationEnum.LIMITE_DIARIO_OPORTUNIDADE).getValor());
        }
        return limiteDiario;
    }

    public Integer getLimiteDiarioCobertura(Estrutura estrutura) {
        return StringUtil.toInt((String)this.configurationService.get(ConfigurationEnum.LIMITE_DIARIO_COBERTURA).getValor());
    }
}

