/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.PedidoEmailDTO;
import br.com.system.app.features.pedido.model.PedidoEmail;
import br.com.system.app.features.pedido.repository.PedidoEmailRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoEmailService {
    @Autowired
    private PedidoEmailRepository repository;

    public void savePedidoEmail(PedidoEmail pe) {
        if (pe.getEstruturaUsuario() == null) {
            throw new BusinessException("Usuario \u00e9 obrigatorio");
        }
        if (pe.getDestinatarios().isEmpty()) {
            throw new BusinessException("Destinatarios \u00e9 obrigatorio");
        }
        if (pe.getPedido() == null) {
            throw new BusinessException("Pedido \u00e9 obrigatorio");
        }
        if (pe.getAssunto().isEmpty()) {
            throw new BusinessException("Assunto \u00e9 obrigatorio");
        }
        if (pe.getMensagem().isEmpty()) {
            throw new BusinessException("Mensagem \u00e9 obrigatorio");
        }
        if (pe.getDataHoraEnvio() == null) {
            pe.setDataHoraEnvio(LocalDateTime.now());
        }
        this.repository.save((Object)pe);
    }

    public String exportar(EstruturaUsuario eu, Set<ClienteDTO> listaCli) {
        List emails = this.repository.findByCliente(listaCli);
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoEmail-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            int linha = 1;
            int col = 0;
            for (PedidoEmailDTO p : emails) {
                col = 0;
                Row row = aba.createRow(linha);
                row.createCell(col).setCellValue(p.getCpfCnpj());
                row.createCell(++col).setCellValue(StringUtil.getString((Object)p.getNome()));
                row.createCell(++col).setCellValue(StringUtil.getString((Object)p.getNumeroAtividade()));
                row.createCell(++col).setCellValue(p.getDataHoraEnvio() == null ? "" : p.getDataHoraEnvio().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(StringUtil.getString((Object)p.getAssunto()));
                row.createCell(++col).setCellValue(StringUtil.getString((Object)p.getDestinatarios()));
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

