/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view.atividade;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoStatus;
import br.com.system.app.features.pedido.service.PedidoStatusService;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class AtividadeStatusView
extends Dialog {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoStatusService pedidoStatusService;
    private Grid<PedidoStatus> grid;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(Pedido pedido) {
        this.removeAll();
        this.setWidth("1124px");
        this.setHeight("600px");
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Movimenta\u00e7\u00e3o de status")});
        this.add(new com.vaadin.flow.component.Component[]{this.getGrid(pedido)});
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnFechar})});
        this.open();
    }

    private VerticalContainer getGrid(Pedido pedido) {
        this.grid = new Grid(PedidoStatus.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidthFull();
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoStatus pa = e;
            return UIUtils.createBreakWrapSpan((String)pa.getPedidoEtapa().getNome());
        })).setHeader("Etapa").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> DateTimeUtil.intervaloEmHoras((LocalDateTime)p.getDataHoraEntrou(), (LocalDateTime)p.getDataHoraSaiu()))).setFlexGrow(0).setWidth("100px").setHeader("Tempo");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraEntrou() == null ? "" : p.getDataHoraEntrou().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("200px").setHeader("Entrou");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoStatus pa = e;
            return UIUtils.createBreakWrapSpan((String)(pa.getEstruturaUsuarioEntrou() == null ? "" : pa.getEstruturaUsuarioEntrou().getUsuario().getNome()));
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraSaiu() == null ? "" : p.getDataHoraSaiu().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("200px").setHeader("Saiu");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoStatus pa = e;
            return UIUtils.createBreakWrapSpan((String)(pa.getEstruturaUsuarioSaiu() == null ? "" : pa.getEstruturaUsuarioSaiu().getUsuario().getNome()));
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("160px");
        this.povoa(pedido);
        this.pedidoStatusService.getByPedido(pedido);
        VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        v.setHeight("500px");
        v.add(new com.vaadin.flow.component.Component[]{this.grid});
        return v;
    }

    private void povoa(Pedido pedido) {
        this.grid.setItems((Collection)this.pedidoStatusService.getByPedido(pedido));
    }
}

