/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view.atividade;

import br.com.system.app.components.AudioPlayerView;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.analisefatura.AnaliseFaturaFormView;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.service.ClienteAnexoService;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.view.ClienteAnexoView;
import br.com.system.app.features.cliente.view.ClienteContatoComp;
import br.com.system.app.features.cliente.view.ClienteContatoView;
import br.com.system.app.features.cliente.view.ClienteProdutoView;
import br.com.system.app.features.cliente.view.ClienteTimeLineView;
import br.com.system.app.features.cliente.view.form.ClienteFormView;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.Overflow;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.modeloproposta.model.ModeloProposta;
import br.com.system.app.features.modeloproposta.repository.ModeloPropostaRepository;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoAudio;
import br.com.system.app.features.pedido.model.PedidoCategoria;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemDados;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.model.PedidoNotificacao;
import br.com.system.app.features.pedido.model.PedidoNotificacaoEnum;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.model.PedidoSubCategoria;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.repository.PedidoItemSolicitacaoRepository;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.pedido.service.PedidoAudioService;
import br.com.system.app.features.pedido.service.PedidoCategoriaService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoNotificacaoService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.service.PedidoSubCategoriaService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.pedido.service.PedidoVinculoService;
import br.com.system.app.features.pedido.view.DialogAlterarUsuario;
import br.com.system.app.features.pedido.view.DialogVincularClaro;
import br.com.system.app.features.pedido.view.DialogVincularConsultoria;
import br.com.system.app.features.pedido.view.DialogVincularOi;
import br.com.system.app.features.pedido.view.DialogVincularProvedor;
import br.com.system.app.features.pedido.view.DialogVincularTim;
import br.com.system.app.features.pedido.view.DialogVincularVivo;
import br.com.system.app.features.pedido.view.PedidoAnexoView;
import br.com.system.app.features.pedido.view.PedidoMovimentacaoView;
import br.com.system.app.features.pedido.view.atividade.AtividadeItemView;
import br.com.system.app.features.pedido.view.atividade.AtividadeNotificationView;
import br.com.system.app.features.pedido.view.atividade.AtividadeStatusView;
import br.com.system.app.features.pessoa.PessoaView;
import br.com.system.app.features.pessoa.service.PessoaService;
import br.com.system.app.features.portabilidade.service.PortabilidadeConsultaService;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.service.ProdutoCategoriaService;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.features.trescx.TrescxGravacaoView;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.whatsapp.WhatsAppAtendimentoCreate;
import br.com.system.app.features.whatsapp.WhatsAppViewDialog;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
@JavaScript.Container(value={@JavaScript(value="./src/audio.js"), @JavaScript(value="https://cdn.jsdelivr.net/npm/opus-media-recorder@latest/OpusMediaRecorder.umd.js"), @JavaScript(value="https://cdn.jsdelivr.net/npm/opus-media-recorder@latest/encoderWorker.umd.js")})
public class AtividadeView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoTagsService pedidoTagsService;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;
    @Autowired
    private ClienteFormView clienteFormView;
    @Autowired
    private AnaliseFaturaFormView analiseFaturaFormView;
    @Autowired
    private ModeloPropostaRepository modeloPropostaRepository;
    @Autowired
    private PessoaService pessoaService;
    @Autowired
    private ClienteAnexoService clienteAnexoService;
    @Autowired
    private PedidoNotificacaoService pedidoNotificacaoService;
    @Autowired
    private PedidoMovimentacaoService pms;
    @Autowired
    private PedidoAnexoService pedidoAnexoService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ClienteProdutoService clienteProdutoService;
    @Autowired
    private AtividadeStatusView atividadeStatusView;
    @Autowired
    private ClienteContatoView clienteContatoView;
    @Autowired
    private KanbanPedidosService kanbanPedidosService;
    @Autowired
    private PedidoItemSolicitacaoRepository pedidoItemSolicitacaoRepository;
    @Autowired
    private ProdutoCategoriaService pcs;
    @Autowired
    private UsuarioHierarquiaService hierarquiaUsuario;
    @Autowired
    private PedidoLogService pedidoLogService;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private AtividadeItemView atividadeItemView;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoItemService pedidoItemService;
    @Autowired
    private PedidoVinculoService pedidoVinculoService;
    @Autowired
    private EstruturaSenhasService estruturaSenhasService;
    @Autowired
    private TrescxChamadaService trescxChamadaService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppViewDialog whatsAppViewDialog;
    @Autowired
    private WhatsAppAtendimentoCreate whatsAppAtendimentoCreate;
    @Autowired
    private PedidoAudioService pedidoAudioService;
    @Autowired
    private AudioPlayerView audioPlayerView;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private TelefoneService telefoneService;
    @Autowired
    private PortabilidadeConsultaService portabilidadeConsultaService;
    @Autowired
    private PedidoCategoriaService pedidoCategoriaService;
    @Autowired
    private PedidoSubCategoriaService pedidoSubCategoriaService;
    private EstruturaUsuario eu;
    private Pedido pedido;
    private HorizontalContainer itensContainer;
    private Cliente cliente;
    private MultiSelectComboBox<PedidoTags> cbTags;
    private ComboBox<PedidoCategoria> cbPedidoCategoria;
    private ComboBox<PedidoSubCategoria> cbPedidoSubCategoria;
    private TextArea informacoes;
    private TextArea movimentacao;
    private TextArea observacoes;
    private Button btnSalvar;
    private Button btnDesmembrar;
    private Button btnFechar;
    private Checkbox cbFuturo;
    private DatePicker retornoFuturo;
    private TextField compromissoMensal;
    private TextField total;
    private TextField txtVlAgregado;
    private TextField txtVlBaseAtual;
    private Boolean precisaRefresh = false;
    private Checkbox cbVendaPerdida;
    private Checkbox cbArquivar;
    private Button btnInteracao;
    private Button btnFatura;
    private Button btnProposta;
    private Set<PedidoItem> itens;
    private HashMap<PedidoItem, PedidoItemDados> itensDesmembramento;
    private String tagsOriginais;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;
    private PedidoTipoEnum tipoDefault;
    private TextField cpfCnpj;
    private Span lblCliente;
    private TextField txtUsuario;
    private Button btnInserir;
    private TextField tfEtapa;
    private Button bUser;
    private Button bMove;
    private Button bStatus;
    private Button bAnchor;
    private Button bChangeCnpj;
    private List<PedidoItemSolicitacao> solicitacoes;
    private List<ProdutoCategoria> listaCategoria;
    private List<Produto> produtos;
    private ProdutoOrigem po = ProdutoOrigem.NEOCRM;
    private String tagsAnteriores;
    private VerticalContainer firstContainer;
    private Boolean acaoSalvar = false;
    private Boolean obrigaTagRetornoFuturo = false;
    private boolean gravando;
    private Icon redMic;
    private Icon normalMic;
    private Grid<PedidoAudio> gridAudio;
    private Button btnAudioCancel;
    private Button btnAudio;
    private ClienteContatoComp clienteContatoComp;
    private EstruturaComplemento complEstrutura;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public Boolean getAcaoSalvar() {
        return this.acaoSalvar;
    }

    public void setCnpj(String cnpj) {
        this.cpfCnpj.setValue(cnpj);
    }

    public void create(Pedido ped, EstruturaUsuario eu, PedidoTipoEnum td) {
        this.create(ped, eu, td, null);
    }

    public AtividadeView create(Pedido ped, EstruturaUsuario eu, PedidoTipoEnum td, List<Produto> listaProduto) {
        this.complEstrutura = this.estruturaComplementoService.getComplementos(eu.getEstrutura());
        this.produtos = listaProduto;
        this.gravando = false;
        this.acaoSalvar = false;
        this.firstContainer = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.tipoDefault = td;
        this.eu = eu;
        this.pedido = ped;
        this.redMic = VaadinIcon.MICROPHONE.create();
        this.redMic.setColor(Color.RED.getValue());
        this.normalMic = VaadinIcon.MICROPHONE.create();
        this.bChangeCnpj = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.EXCHANGE, (String)"Alterar Cpf/cnpj da atividade");
        this.bChangeCnpj.setEnabled(false);
        this.bChangeCnpj.setVisible(false);
        this.bChangeCnpj.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.hasPermission("ALTERAR_CNPJ_ATIVIDADE")) {
                this.changeCnpj();
            } else {
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem permiss\u00e3o para alterar CPFCNPJ da atividade");
            }
        });
        this.setObrigacaoRetornoFuturo();
        this.setCloseOnOutsideClick(false);
        this.removeChildrens();
        this.getElement().getStyle().set("margin", "0px");
        this.whatsAppViewDialog.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened() && this.pedido.getId() != null) {
                this.pedido = this.pedidoService.getById(this.pedido.getId());
            }
        });
        this.clienteContatoComp = new ClienteContatoComp(this.telefoneService, this.portabilidadeConsultaService);
        this.solicitacoes = this.pedidoItemSolicitacaoRepository.findByEstruturaTipoAndAtivo(this.getEstrutura().getEstruturaTipo(), Boolean.valueOf(true));
        this.listaCategoria = this.pcs.getByEstrutura(this.getEstrutura());
        this.precisaRefresh = false;
        this.setMaxWidth("850px");
        this.setHeight("98%");
        this.rbTipo = new RadioButtonGroup();
        this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        UIUtils.setFontSize((FontSize)FontSize.XXS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.rbTipo});
        if (this.pedido == null) {
            this.cliente = null;
            this.pedido = new Pedido();
            this.pedido.setPedidoOrigem(this.pedidoOrigemService.getOrigemAtividade(this.getEstrutura()));
            this.pedido.setEstruturaUsuario(eu);
            this.pedido.setTotal(BigDecimal.ZERO);
            this.pedido.setDataCadastro(LocalDate.now());
            this.pedido.setDataHoraAtualizacao(LocalDateTime.now());
            this.rbTipo.setValue((Object)(this.tipoDefault == null ? PedidoTipoEnum.COMERCIAL : this.tipoDefault));
            this.itens = new HashSet();
            this.tagsOriginais = "";
        } else {
            this.po = ProdutoOrigem.getByName((String)this.pedido.getPedidoOrigem().getNome());
            this.itens = this.pedidoService.getItens(this.pedido);
            this.rbTipo.setVisible(false);
            this.rbTipo.setValue((Object)this.pedido.getPedidoTipo());
            this.tagsOriginais = this.pedido.getTags();
        }
        if (this.produtos == null || this.produtos.isEmpty()) {
            this.produtos = this.produtoService.getProdutosByOrigem(this.getEstrutura(), this.po);
        }
        this.itensDesmembramento = new HashMap();
        this.createFirstContainer();
        this.itensContainer = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
        this.itensContainer.setWidthFull();
        this.createItensContainer();
        this.btnInserir = UIUtils.createSmallButton((String)"Produto", (VaadinIcon)VaadinIcon.PLUS);
        this.btnInserir.setEnabled(this.pedido.getId() != null && this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        this.btnDesmembrar = UIUtils.createSmallButton((String)"Desmembrar", (VaadinIcon)VaadinIcon.ROAD_BRANCH);
        this.btnDesmembrar.addClickListener((ComponentEventListener & Serializable)e -> this.habilitaDesmembramento(e));
        this.btnDesmembrar.setVisible(this.hasPermission("ATIVIDADE_DESMEMBRAMENTO") && this.pedido.getId() != null && this.pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.COMERCIAL));
        this.btnSalvar = UIUtils.createSmallButton((String)(this.pedido.getId() == null ? "Criar" : "Salvar"), (VaadinIcon)VaadinIcon.INBOX);
        this.btnSalvar.setDisableOnClick(true);
        if (this.pedido.getPedidoEtapa() != null) {
            this.btnSalvar.setEnabled(this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
            this.btnInserir.setEnabled(this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        }
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        this.btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            String erros = this.getErros();
            if (!erros.isBlank()) {
                UIUtils.showNotification((String)erros);
                this.btnSalvar.setEnabled(true);
                return;
            }
            this.acaoSalvar = true;
            if (this.btnSalvar.getText().equals("Criar")) {
                this.create(this.salvar(), eu, td);
                this.precisaRefresh = true;
                UIUtils.showNotification((String)"Atividade criada com sucesso");
                this.btnSalvar.setEnabled(true);
            } else {
                this.salvar();
                this.close();
            }
        });
        FooterContainer footer = new FooterContainer(new com.vaadin.flow.component.Component[0]);
        footer.add(new com.vaadin.flow.component.Component[]{this.btnInserir, this.btnDesmembrar, this.btnFechar, this.btnSalvar});
        this.btnInserir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.pedido == null || this.pedido.getId() == null) {
                UIUtils.showNotification((String)"Primeiro precisa criar o pedido para inserir itens");
                return;
            }
            this.atividadeItemView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                if (!close.isOpened()) {
                    this.itens = this.pedidoService.getItens(this.pedido);
                    this.createItensContainer();
                    this.setTotal();
                }
            });
            this.atividadeItemView.create(this.pedido, new PedidoItem(), this.listaCategoria, this.solicitacoes, this.produtos);
        });
        Scroller scroller = new Scroller();
        scroller.setWidth("100%");
        scroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        scroller.getStyle().set("padding", "0px").set("margin", "0px");
        VerticalContainer lay = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        lay.setWidthFull();
        lay.setMaxWidth("850px");
        lay.setHeight("100%");
        lay.setAlignItems(FlexComponent.Alignment.CENTER);
        VerticalContainer scrollContainer = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        scrollContainer.addClassName("items-center");
        if (this.pedido.getId() == null) {
            this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Atividade")});
            scrollContainer.add(new com.vaadin.flow.component.Component[]{this.firstContainer, this.itensContainer});
        } else {
            this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)("Atividade " + this.pedido.getPedidoTipo().name() + " #" + this.pedido.getNumero()))});
            scrollContainer.add(new com.vaadin.flow.component.Component[]{this.rbTipo, this.firstContainer, UIUtils.createHeader((String)"Itens da Atividade"), this.itensContainer});
        }
        scroller.setContent((com.vaadin.flow.component.Component)scrollContainer);
        lay.add(new com.vaadin.flow.component.Component[]{scroller});
        lay.add(new com.vaadin.flow.component.Component[]{footer});
        this.add(new com.vaadin.flow.component.Component[]{lay});
        this.open();
        this.changeButtons();
        return this;
    }

    private void createFirstContainer() {
        this.firstContainer.removeAll();
        this.firstContainer.setId("firstContainer");
        this.firstContainer.setMaxWidth("850px");
        this.firstContainer.setWidthFull();
        VerticalContainer box1 = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        box1.setId("createFirstContainer-box1");
        box1.setWidth("100%");
        Scroller s = new Scroller((com.vaadin.flow.component.Component)box1);
        this.cpfCnpj = UIUtils.createTextField((String)"CPF-CNPJ");
        this.cpfCnpj.setMinLength(11);
        this.cpfCnpj.setMaxLength(20);
        this.cpfCnpj.setWidth("125px");
        this.lblCliente = UIUtils.createBreakWrapSpan((String)"");
        this.txtUsuario = new TextField("Usu\u00e1rio Atividade");
        this.txtUsuario.setReadOnly(true);
        this.txtUsuario.setWidthFull();
        Button btnCliente = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USERS, (String)"Abrir cadastro de Clientes");
        btnCliente.setVisible(false);
        btnCliente.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.cliente == null) {
                UIUtils.showNotification((String)"Informe o CNPJ para abrir o cadastro de clientes.");
                return;
            }
            this.clienteFormView.create(this.cliente, this.pedido.getId());
            this.clienteFormView.addOpenedChangeListener((ComponentEventListener & Serializable)open -> {
                if (!open.isOpened()) {
                    this.cliente = this.clienteService.getById(this.cliente.getId());
                }
            });
        });
        Button bClip = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Anexos do Clientes");
        bClip.setEnabled(this.hasPermission("CLIENTE_ANEXO_VIEW"));
        bClip.setVisible(false);
        bClip.addClickListener((ComponentEventListener & Serializable)e -> new ClienteAnexoView(this.cliente, this.getEu(), this.clienteAnexoService));
        Button bPessoaCliente = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.GROUP, (String)"Pessoas do Cliente");
        bPessoaCliente.setVisible(false);
        bPessoaCliente.addClickListener((ComponentEventListener & Serializable)e -> {
            PessoaView pessoaView = new PessoaView(this.pessoaService, this.cliente, this.clienteService);
            pessoaView.addOpenedChangeListener((ComponentEventListener & Serializable)ex -> {
                if (!ex.isOpened()) {
                    this.cliente = this.clienteService.getById(this.cliente.getId());
                }
            });
        });
        Button btnTimeline = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TIMER, (String)"Timeline do Cliente");
        btnTimeline.setEnabled(this.hasPermission("CLIENTE_TIME_LINE"));
        btnTimeline.setVisible(false);
        btnTimeline.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.hasPermission("CLIENTE_TIME_LINE") || !this.clienteService.permiteAbrirDadosExtras(this.eu, this.cliente)) {
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem permiss\u00e3o para acessar essa funcionalidade");
                return;
            }
            ClienteTimeLineView tl = new ClienteTimeLineView(this.cliente, this.pedidoService, this.eus, this);
            tl.createContent();
            tl.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> tl.close());
        });
        Button btnContatos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PHONE_LANDLINE, (String)"Contatos V\u00e1lidos do cliente");
        ((Icon)btnContatos.getIcon()).setColor(Color.GREEN.getValue());
        btnContatos.setEnabled(this.pedido.getId() != null);
        btnContatos.setVisible(false);
        btnContatos.addClickListener((ComponentEventListener & Serializable)e -> this.clienteContatoView.show(this.cliente, this.pedido.getId()));
        Button btnProdutos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CART, (String)"Produtos do Cliente");
        btnProdutos.setVisible(false);
        btnProdutos.setEnabled(this.hasPermission("CLIENTE_PRODUTO_VIEW"));
        btnProdutos.addClickListener((ComponentEventListener & Serializable)e -> new ClienteProdutoView(this.cliente, this.getEu(), this.clienteProdutoService));
        if (this.pedido.getId() != null) {
            this.cliente = this.pedido.getCliente();
            this.cpfCnpj.setValue(this.pedido.getCliente().getCpfCnpj());
            this.cpfCnpj.setReadOnly(true);
            this.bChangeCnpj.setEnabled(this.hasPermission("ALTERAR_CNPJ_ATIVIDADE"));
        }
        this.cpfCnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!StringUtil.numbersOnly((String)((String)e.getValue())).equals(e.getValue())) {
                this.cpfCnpj.setValue(StringUtil.numbersOnly((String)((String)e.getValue())));
                return;
            }
            this.lblCliente.setText("");
            this.txtUsuario.setValue("");
            btnCliente.setVisible(false);
            this.bChangeCnpj.setVisible(false);
            bPessoaCliente.setVisible(false);
            btnTimeline.setVisible(false);
            btnProdutos.setVisible(false);
            bClip.setVisible(false);
            if (!ValidationUtil.isValidCnpjAndCpf((String)((String)e.getValue()))) {
                UIUtils.showNotification((String)"CPF-CNPJ Inv\u00e1lidos");
                return;
            }
            this.cliente = this.clienteService.getAndCreateCliente(this.getEu(), (String)e.getValue(), new ClienteContato[0]);
            if (!this.clienteService.souResponsavel(this.cliente, this.eu, this.rbTipo.getValue() == null ? this.tipoDefault : (PedidoTipoEnum)this.rbTipo.getValue(), Boolean.valueOf(this.hasPermission("ATIVIDADE_CRIAR_MESMO_ENCARTEIRADO")))) {
                this.cliente = null;
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o est\u00e1 na lista de respons\u00e1veis deste cliente.");
                return;
            }
            this.setNomeCliente();
            btnCliente.setVisible(true);
            this.bChangeCnpj.setVisible(true);
            bPessoaCliente.setVisible(true);
            btnTimeline.setVisible(true);
            btnProdutos.setVisible(true);
            bClip.setVisible(true);
            this.txtUsuario.setValue(this.pedido == null ? this.getEu().getUsuario().getNome() : this.pedido.getEstruturaUsuario().getUsuario().getNome());
        });
        this.txtUsuario.setValue(this.pedido == null ? this.getEu().getUsuario().getNome() : this.pedido.getEstruturaUsuario().getUsuario().getNome());
        Span lblTags = UIUtils.createBreakWrapSpan((String)"");
        lblTags.setWidthFull();
        this.cbTags = new MultiSelectComboBox("Tags", (Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
        this.cbTags.setWidth("100%");
        this.tagsAnteriores = this.pedido.getTags();
        if (this.pedido.getTags() != null && !this.pedido.getTags().isBlank()) {
            if (!this.hasPermission("ATIVIDADE_TAG_CHANGE")) {
                lblTags.setText(this.pedido.getTags());
                this.tagsAnteriores = "";
            } else {
                this.cbTags.setValue(this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue(), this.pedido.getTags()));
            }
        }
        this.cbTags.setItemLabelGenerator(PedidoTags::getTagAndCategoria);
        this.cbPedidoCategoria = new ComboBox(this.complEstrutura.getNomeCampoCategoria());
        this.cbPedidoCategoria.setWidth("100%");
        this.cbPedidoCategoria.setItems((Collection)this.pedidoCategoriaService.getByEstruturaAndAtivo(this.getEstrutura(), Boolean.valueOf(true)));
        this.cbPedidoCategoria.setItemLabelGenerator(PedidoCategoria::getNome);
        if (this.pedido.getPedidoCategoria() != null) {
            this.cbPedidoCategoria.setValue((Object)this.pedido.getPedidoCategoria());
        }
        this.cbPedidoSubCategoria = new ComboBox(this.complEstrutura.getNomeCampoSubCategoria());
        this.cbPedidoSubCategoria.setWidth("100%");
        this.cbPedidoSubCategoria.setItems((Collection)this.pedidoSubCategoriaService.getByEstruturaAndAtivo(this.getEstrutura(), Boolean.valueOf(true)));
        this.cbPedidoSubCategoria.setItemLabelGenerator(PedidoSubCategoria::getNome);
        if (this.pedido.getPedidoSubCategoria() != null) {
            this.cbPedidoSubCategoria.setValue((Object)this.pedido.getPedidoSubCategoria());
        }
        this.tfEtapa = UIUtils.createTextField((String)"Etapa");
        this.tfEtapa.setWidth("98%");
        if (this.pedido.getPedidoEtapa() != null) {
            this.tfEtapa.setValue(this.pedido.getPedidoEtapa().getNome());
        }
        this.tfEtapa.setReadOnly(true);
        this.retornoFuturo = new DatePicker();
        this.retornoFuturo.setLabel("Retorno Futuro");
        this.retornoFuturo.setValue(this.pedido.getDataRetornoFuturo() != null ? this.pedido.getDataRetornoFuturo() : null);
        this.retornoFuturo.setLocale(UIUtils.getLocale());
        this.retornoFuturo.setReadOnly(true);
        this.cbFuturo = new Checkbox();
        if (this.pedido.getDataRetornoFuturo() != null) {
            this.cbFuturo.setValue((Object)true);
        }
        this.cbFuturo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                this.retornoFuturo.setReadOnly(false);
                this.retornoFuturo.setValue(LocalDate.now().plusDays(1L));
            } else {
                this.retornoFuturo.setReadOnly(true);
                this.retornoFuturo.setValue(null);
            }
        });
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.cbTags.setItems((Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)e.getValue()));
            if (this.pedido.getId() == null) {
                this.cbVendaPerdida.setVisible(false);
                this.cbArquivar.setVisible(false);
                this.btnInteracao.setVisible(false);
                return;
            }
            this.changeButtons();
        });
        this.compromissoMensal = new TextField("Comp Mensal");
        this.compromissoMensal.setWidth("40%");
        this.compromissoMensal.setReadOnly(true);
        this.txtVlBaseAtual = new TextField("Vl Base Atual");
        this.txtVlBaseAtual.setWidth("40%");
        this.txtVlBaseAtual.setReadOnly(true);
        this.txtVlAgregado = new TextField("Vl Agregado");
        this.txtVlAgregado.setWidth("40%");
        this.txtVlAgregado.setReadOnly(true);
        this.total = new TextField("Total Atividade");
        this.total.setWidth("50%");
        this.total.setReadOnly(true);
        this.setTotal();
        Button bClock = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CALENDAR_CLOCK, (String)"Notifica\u00e7\u00f5es da atividade(Agenda)");
        bClock.setEnabled(this.pedido.getId() != null);
        bClock.addClickListener((ComponentEventListener & Serializable)e -> {
            AtividadeNotificationView anv = new AtividadeNotificationView(this.pedidoNotificacaoService, this.pedido, this.getEu());
            anv.openNotification();
        });
        Button bClipPedido = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"ANEXOS DA ATIVIDADE");
        bClipPedido.setEnabled(this.hasPermission("PEDIDO_ANEXOS_VIEW"));
        bClipPedido.setVisible(this.pedido.getId() != null);
        bClipPedido.addClickListener((ComponentEventListener & Serializable)e -> new PedidoAnexoView(this.pedido, this.eu, this.pedidoAnexoService));
        Button bGravacao = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.MICROPHONE, (String)"(3CX)GRAVA\u00c7\u00d5ES DA ATIVIDADE");
        bGravacao.setEnabled(this.hasPermission("TRESCX_GRAVACOES_VIEW"));
        bGravacao.setVisible(this.pedido.getId() != null);
        bGravacao.addClickListener((ComponentEventListener & Serializable)e -> new TrescxGravacaoView(this.pedido, this.trescxChamadaService, this.audioPlayerView));
        Button bMovPedido = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.RECORDS, (String)"MOVIMENTA\u00c7\u00c3O DA ATIVIDADE");
        bMovPedido.setVisible(this.pedido.getId() != null);
        bMovPedido.addClickListener((ComponentEventListener & Serializable)e -> new PedidoMovimentacaoView(this.pedido, this.pms, this.pedidoLogService, this.pedidoService));
        this.bUser = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USER, (String)"Encaminhar atividade para usu\u00e1rio");
        this.bUser.setVisible(this.pedido.getId() != null);
        this.bUser.addClickListener((ComponentEventListener & Serializable)e -> this.encarteirar());
        this.bMove = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_FORWARD, (String)"Mover a atividade");
        this.bMove.setVisible(this.pedido.getId() != null);
        this.bMove.addClickListener((ComponentEventListener & Serializable)e -> this.moveEtapa(this.pedido));
        this.bStatus = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOCK, (String)"Movimenta\u00e7\u00f5es de Status");
        this.bStatus.setVisible(this.pedido.getId() != null);
        this.bStatus.addClickListener((ComponentEventListener & Serializable)e -> this.atividadeStatusView.create(this.pedido));
        this.bAnchor = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ANCHOR, (String)"Vincular atividade com operadora");
        this.bAnchor.setVisible(this.pedido.getId() != null && this.isTelefonia());
        this.bAnchor.setEnabled(this.pedido.getId() != null && this.pedido.getPedidoEtapa().isEditavel());
        this.bAnchor.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.VIVO)) {
                DialogVincularVivo dv = new DialogVincularVivo(this.pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dv.create();
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CLARO)) {
                DialogVincularClaro dv = new DialogVincularClaro(this.pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dv.create();
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.TIM)) {
                DialogVincularTim dt = new DialogVincularTim(this.pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dt.create();
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.OI)) {
                DialogVincularOi doi = new DialogVincularOi(this.pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                doi.create();
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CONSULTORIA)) {
                DialogVincularConsultoria doi = new DialogVincularConsultoria(this.pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                doi.create();
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.PROVEDOR)) {
                DialogVincularProvedor dvp = new DialogVincularProvedor(this.pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dvp.create();
            }
        });
        this.controlaBotoes();
        HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cpfCnpj, this.bChangeCnpj, btnCliente, bPessoaCliente, bClip, btnTimeline, btnProdutos, btnContatos});
        h.setSpacing(false);
        box1.add(new com.vaadin.flow.component.Component[]{h, this.lblCliente});
        if (this.pedido.getId() != null) {
            box1.add(new com.vaadin.flow.component.Component[]{this.txtUsuario});
        }
        this.cbVendaPerdida = new Checkbox("Venda perdida");
        this.cbVendaPerdida.setVisible(this.pedido.getId() != null);
        this.cbVendaPerdida.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!((Boolean)e.getValue()).booleanValue()) {
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Venda perdida", "Confirma Venda perdida?\nInforme um motivo e selecione uma #tag e clique em salvar");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> cd.close());
        });
        this.cbArquivar = new Checkbox("Arquivar");
        this.cbArquivar.setVisible(this.pedido.getId() != null);
        this.cbArquivar.setEnabled(this.pedido.getId() != null && this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        this.cbArquivar.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!((Boolean)e.getValue()).booleanValue()) {
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Arquivamento?", "Confirma Arquivamento?\nInforme um motivo e selecione uma #tag e clique em salvar");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> cd.close());
        });
        this.btnInteracao = UIUtils.createSmallButton((String)"Registrar Interacao com Cliente");
        this.btnInteracao.setVisible(this.pedido.getId() != null && ((PedidoTipoEnum)this.rbTipo.getValue()).equals((Object)PedidoTipoEnum.COMERCIAL));
        this.btnInteracao.addClickListener((ComponentEventListener & Serializable)e -> this.interacaoCliente());
        box1.add(new com.vaadin.flow.component.Component[]{lblTags, this.cbTags, this.tfEtapa});
        this.informacoes = new TextArea("Informa\u00e7\u00f5es");
        this.informacoes.setHeight("490px");
        this.informacoes.setWidth("98%");
        this.informacoes.setValue(this.pedido.getComplementos() == null ? "" : this.pedido.getComplementos().replaceAll("(?i)<BR>", "\n").replace("null", ""));
        this.btnProposta = UIUtils.createSmallButton((String)"Proposta", (VaadinIcon)VaadinIcon.CALENDAR_BRIEFCASE);
        this.btnProposta.setVisible(this.pedido.getId() != null);
        this.btnProposta.addClickListener((ComponentEventListener & Serializable)e -> this.enviarProposta());
        Button bWhats = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.COMMENTS_O, (String)"Abrir conversa");
        bWhats.setId("btnWhats");
        bWhats.setVisible(this.pedido.getId() != null && this.pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
        bWhats.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                WhatsAppAtendimento wa = this.whatsAppAtendimentoService.getByPedido(this.pedido.getId());
                if (wa == null) {
                    this.whatsAppAtendimentoCreate.create(null, this.pedido, this.getEu());
                    this.whatsAppAtendimentoCreate.addOpenedChangeListener((ComponentEventListener & Serializable)op -> {
                        if (!op.isOpened()) {
                            bWhats.setIcon((com.vaadin.flow.component.Component)VaadinIcon.COMMENTS_O.create());
                            WhatsAppAtendimento atendimento = this.whatsAppAtendimentoService.getByPedido(this.pedido.getId());
                            if (atendimento != null) {
                                this.whatsAppViewDialog.create(atendimento);
                            } else {
                                UIUtils.showNotification((String)"ERRO: N\u00e3o localizei o atendimento");
                            }
                        }
                    });
                } else {
                    bWhats.setIcon((com.vaadin.flow.component.Component)VaadinIcon.COMMENTS_O.create());
                    this.whatsAppViewDialog.create(wa);
                }
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        this.btnFatura = UIUtils.createSmallButton((String)"Fatura", (VaadinIcon)VaadinIcon.INVOICE);
        this.btnFatura.setVisible(this.pedido.getId() != null && this.isTelefonia() && !this.pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP) && !this.isProvedor());
        this.btnFatura.addClickListener((ComponentEventListener & Serializable)e -> {
            Dialog d = new Dialog();
            d.setWidth("600px");
            d.removeAll();
            d.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Inserir itens a partir de uma Fatura")});
            this.analiseFaturaFormView.setPedido(this.pedido);
            d.add(new com.vaadin.flow.component.Component[]{this.analiseFaturaFormView.create()});
            Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
            close.addClickListener((ComponentEventListener & Serializable)ex -> d.close());
            d.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{close})});
            d.open();
            d.addOpenedChangeListener((ComponentEventListener & Serializable)closeEv -> {
                if (!closeEv.isOpened() && this.pedido.getId() != null) {
                    this.pedido = this.pedidoService.getById(this.pedido.getId());
                    this.itens = this.pedidoService.getItens(this.pedido);
                    this.createItensContainer();
                }
            });
        });
        this.movimentacao = new TextArea("Movimenta\u00e7\u00e3o");
        this.movimentacao.setWidthFull();
        this.movimentacao.setHeight("100px");
        this.observacoes = new TextArea("Observa\u00e7\u00f5es");
        this.observacoes.setWidth("98%");
        this.observacoes.setHeight("170px");
        this.observacoes.setReadOnly(this.pedido.getEstruturaUsuario() != null && !this.pedido.getEstruturaUsuario().equals((Object)this.getEu()));
        Icon cancel = VaadinIcon.TRASH.create();
        cancel.setColor(Color.RED.getValue());
        this.btnAudioCancel = UIUtils.createSmallButton((Icon)cancel, (String)"Cancelar audio");
        this.btnAudioCancel.setVisible(false);
        this.btnAudio = UIUtils.createSmallButton((Icon)this.normalMic, (String)"Gravar audio");
        VerticalContainer containerDireita = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        containerDireita.setWidth("330px");
        UIUtils.setShadow((Shadow)Shadow.XS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{containerDireita});
        if (this.pedido.getId() != null) {
            this.cliente = this.pedido.getCliente();
            this.setNomeCliente();
            btnCliente.setVisible(true);
            this.bChangeCnpj.setVisible(true);
            bPessoaCliente.setVisible(true);
            bClip.setVisible(true);
            btnTimeline.setVisible(true);
            btnProdutos.setVisible(true);
            this.informacoes.setReadOnly(true);
            this.movimentacao.setReadOnly(false);
            this.observacoes.setValue(this.pedido.getObservacao() == null ? "" : this.pedido.getObservacao());
            Div div = new Div();
            div.setHeight("250px");
            div.setWidth("98%");
            UIUtils.setOverflow((Overflow)Overflow.AUTO, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{div});
            div.getStyle().set("overlay", "auto");
            div.getElement().setProperty("innerHTML", "<span>" + this.pedidoService.getInformacoesPedido(this.pedido, this.getTipoEstrutura()) + "</span>");
            containerDireita.add(new com.vaadin.flow.component.Component[]{div, this.observacoes, this.getAudio()});
        } else {
            this.informacoes.setReadOnly(false);
            this.movimentacao.setReadOnly(true);
            containerDireita.add(new com.vaadin.flow.component.Component[]{this.informacoes});
        }
        HorizontalContainer hOptions = new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.btnAudio, this.btnAudioCancel, this.btnFatura, this.btnProposta});
        containerDireita.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.compromissoMensal, this.total})});
        containerDireita.add(new com.vaadin.flow.component.Component[]{hOptions});
        containerDireita.setHeight("650px");
        VerticalContainer containerEsquerda = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        containerEsquerda.setId("containerEsquerda");
        containerEsquerda.setHeight("650px");
        containerEsquerda.setWidth("370px");
        UIUtils.setShadow((Shadow)Shadow.XS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{containerEsquerda});
        HorizontalContainer containerBotoes = new HorizontalContainer(new com.vaadin.flow.component.Component[]{bClipPedido, bGravacao, bMovPedido, this.bUser, this.bMove, this.bStatus, this.bAnchor, bClock, bWhats});
        containerBotoes.setId("containerBotoes");
        containerEsquerda.add(new com.vaadin.flow.component.Component[]{s, this.cbPedidoCategoria, this.cbPedidoSubCategoria, new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.retornoFuturo, this.cbFuturo}), new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbVendaPerdida, this.cbArquivar}), containerBotoes, new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.btnInteracao}).setPaddingOn().setSpacingOn()});
        if (this.isClaro()) {
            containerEsquerda.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtVlBaseAtual, this.txtVlAgregado})});
        }
        HorizontalContainer firstBlock = new HorizontalContainer(new com.vaadin.flow.component.Component[]{containerEsquerda, containerDireita}).setStartAlign();
        firstBlock.setMaxWidth("850px");
        firstBlock.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        firstBlock.setId("firstBlock");
        this.firstContainer.add(new com.vaadin.flow.component.Component[]{firstBlock, this.movimentacao});
    }

    private void moveEtapa(Pedido ped) {
        ComboBox cbMove = new ComboBox("Fila");
        cbMove.setWidth("300px");
        cbMove.setItemLabelGenerator(PedidoEtapa::getNome);
        ComboBox cbOrigem = new ComboBox("Origem", (Collection)this.pedidoOrigemService.getByEstruturaTipoActiveOnly(this.getEu().getEstrutura().getEstruturaTipo()));
        cbOrigem.setItemLabelGenerator(PedidoOrigem::getNome);
        cbOrigem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (cbOrigem.getValue() == null) {
                cbMove.clear();
                UIUtils.showError((String)"Selecione uma origem para depois selecionar a etapa");
                return;
            }
            if (this.hasPermission("PAINEL_ATIVIDADE_ETAPA_CHANGE")) {
                cbMove.setItems((Collection)this.pedidoEtapaService.getAtivos(this.getEstrutura(), ped.getPedidoTipo(), (PedidoOrigem)cbOrigem.getValue()));
            } else {
                ArrayList<PedidoEtapa> lista = new ArrayList<PedidoEtapa>();
                for (KanbanPedidos kp : this.kanbanPedidosService.getKanban(this.getEu().getId(), ped.getPedidoTipo())) {
                    lista.add(kp.getPedidoEtapa());
                }
                cbMove.setItems(lista);
            }
        });
        cbOrigem.setValue((Object)ped.getPedidoOrigem());
        Dialog d = new Dialog();
        Button btnConfirmar = UIUtils.createSmallButton((String)"Confirmar");
        Button bf = UIUtils.createSmallButton((String)"Fechar");
        bf.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbMove.getValue() == null) {
                UIUtils.showNotification((String)"Selecione uma etapa para movimentar");
                return;
            }
            if (((PedidoEtapa)cbMove.getValue()).getId().equals(this.pedido.getPedidoEtapa().getId())) {
                UIUtils.showNotification((String)"Atividade j\u00e1 est\u00e1 nessa etapa, imposs\u00edvel movimentar");
                return;
            }
            this.pedido.setPedidoEtapa((PedidoEtapa)cbMove.getValue());
            this.pedido.setDataHoraUltimaMov(LocalDateTime.now());
            this.tfEtapa.setValue(((PedidoEtapa)cbMove.getValue()).getNome());
            this.pedidoService.alterarEtapaPedido(this.pedido.getId(), (PedidoEtapa)cbMove.getValue(), this.getEu());
            this.precisaRefresh = true;
            this.itens = this.pedidoService.getItens(this.pedido);
            this.createItensContainer();
            this.controlaBotoes();
            UIUtils.showNotification((String)"Atividade movido com sucesso");
            d.close();
            this.setObrigacaoRetornoFuturo();
        });
        d.add(new com.vaadin.flow.component.Component[]{new VerticalContainer(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Mover atividade"), cbOrigem, cbMove, new FooterContainer(new com.vaadin.flow.component.Component[]{bf, btnConfirmar})})});
        d.open();
    }

    private void enviarProposta() {
        try {
            Dialog dialog = new Dialog();
            dialog.removeAll();
            VerticalLayout lay = new VerticalLayout();
            lay.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Enviar proposta ao cliente")});
            ComboBox cbModelo = new ComboBox("Selecione o Modelo", (Collection)this.modeloPropostaRepository.findByEstruturaAndAtivo(this.getEstrutura(), Boolean.valueOf(true)));
            cbModelo.setItemLabelGenerator(ModeloProposta::getNome);
            if (this.pedido.getModeloProposta() != null) {
                cbModelo.setValue((Object)this.pedido.getModeloProposta());
            }
            TextArea taObs = new TextArea("Observa\u00e7\u00e3o Proposta");
            taObs.setWidth("100%");
            taObs.setHeight("150px");
            if (this.pedido.getObservacaoProposta() != null) {
                taObs.setValue(this.pedido.getObservacaoProposta());
            }
            lay.add(new com.vaadin.flow.component.Component[]{cbModelo, taObs});
            String url = this.getUrl() + "atividade-proposta";
            Anchor anchor = new Anchor((String)(this.pedido.getHashProposta() == null ? "" : url + "?id=" + this.pedido.getHashProposta()), new com.vaadin.flow.component.Component[0]);
            anchor.setTarget("_blank");
            anchor.setText("Link da Proposta");
            anchor.setTitle("Abrir a Proposta");
            anchor.setVisible(this.pedido.getPedidoEtapa().isEditavel());
            Anchor anchorResumo = new Anchor((String)(this.pedido.getHashProposta() == null ? "" : url + "?id=" + this.pedido.getHashProposta() + "&rl=true"), new com.vaadin.flow.component.Component[0]);
            anchorResumo.setTarget("_blank");
            anchorResumo.setText("Link Resumo de Linhas");
            anchorResumo.setTitle("Abrir o Resumo de Linhas");
            anchorResumo.setVisible(this.pedido.getPedidoEtapa().isEditavel());
            lay.add(new com.vaadin.flow.component.Component[]{anchor, anchorResumo});
            Button salvar = UIUtils.createSmallButton((String)"Gerar", (VaadinIcon)VaadinIcon.INBOX);
            salvar.addClickListener((ComponentEventListener & Serializable)ex -> {
                if (cbModelo.getValue() == null) {
                    UIUtils.showNotification((String)"Selecione um modelo");
                    return;
                }
                if (this.pedido.getHashProposta() == null || this.pedido.getHashProposta().isEmpty()) {
                    this.pedido.setHashProposta(HashUtil.getUUI());
                }
                this.pedido.setObservacaoProposta(taObs.getValue());
                this.pedido.setModeloProposta((ModeloProposta)cbModelo.getValue());
                this.pedido = this.pedidoService.salvar(this.pedido);
                UIUtils.showNotification((String)"Salvo com sucesso");
                this.enviarProposta();
                dialog.close();
            });
            Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
            close.addClickListener((ComponentEventListener & Serializable)ex -> dialog.close());
            lay.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{close, salvar})});
            if (this.pedido.getHashProposta() != null && !this.pedido.getHashProposta().isBlank()) {
                lay.add(new com.vaadin.flow.component.Component[]{this.clienteContatoComp.create(this.getEu(), this.cliente, this.pedido.getId(), ClienteContatoVerficadoEnum.VALIDO)});
            }
            dialog.add(new com.vaadin.flow.component.Component[]{lay});
            dialog.open();
        }
        catch (Exception e) {
            UIUtils.showNotification((String)("Proposta erro " + e.getMessage()));
        }
    }

    private void createItensContainer() {
        this.itensContainer.removeAll();
        for (PedidoItem item : this.itens) {
            this.itensContainer.add(new com.vaadin.flow.component.Component[]{this.criarCardItem(item)});
        }
    }

    private VerticalContainer criarCardItem(PedidoItem item) {
        VerticalContainer box = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        box.setDataObject((Object)item);
        UIUtils.setShadow((Shadow)Shadow.S, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{box});
        box.setWidth("220px");
        box.setHeight("260px");
        Span lblSol = UIUtils.createSmallSpan((String)item.getPedidoItemSolicitacao().getNome());
        Checkbox checkBox = new Checkbox();
        checkBox.setVisible(false);
        checkBox.setId("checkbox");
        Span span = new Span();
        span.setHeight("180px");
        String mensagem = " " + item.getProduto().getNome() + "<BR> Quant: " + item.getQuantidade() + " Valor: " + UIUtils.formatCurrency((BigDecimal)item.getValorUnitario()) + "<BR> Total: " + UIUtils.formatCurrency((BigDecimal)item.getValorUnitario().subtract(item.getDescontoPorItem() == null ? BigDecimal.ZERO : item.getDescontoPorItem()).multiply(item.getQuantidade() != null ? BigDecimal.valueOf(item.getQuantidade().longValue()) : BigDecimal.ZERO));
        if (this.isClaro()) {
            mensagem = mensagem + "<BR> Vl Base Atual: " + String.valueOf(item.getValorBaseAtual());
            mensagem = mensagem + "<BR> Vl Agregado: " + String.valueOf(item.getValorAgregado());
        }
        mensagem = mensagem + "<BR> Numero: " + item.getNumero() + "<BR> Etapa: " + item.getPedidoItemEtapa().getNome();
        mensagem = item.getDataPortabilidade() != null ? mensagem + "<BR> Portabilidade: " + item.getDataPortabilidade().format(FormatDate.DATE_BR.toDTF()) + "\n" : mensagem + "<BR> Referencia: " + item.getDataReferencia().format(FormatDate.DATE_BR.toDTF()) + "\n";
        span.getElement().setProperty("innerHTML", "<span>" + mensagem + "</span>");
        Button btnEdit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar Item");
        btnEdit.setEnabled(this.pedido.getId() != null && this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        btnEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            this.atividadeItemView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                if (!close.isOpened()) {
                    this.itens = this.pedidoService.getItens(this.pedido);
                    this.createItensContainer();
                    this.setTotal();
                }
            });
            this.atividadeItemView.create(this.pedido, item, this.listaCategoria, this.solicitacoes, this.produtos);
        });
        Button btnExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir item");
        btnExcluir.setEnabled(this.pedido.getId() != null && this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o", "Confirma a exclus\u00e3o do item?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.pedidoItemService.removeItem(item, this.getEu());
                this.itens = this.pedidoService.getItens(this.pedido);
                this.setTotal();
                cd.close();
                this.createItensContainer();
            });
        });
        HorizontalContainer h1 = new HorizontalContainer(new com.vaadin.flow.component.Component[]{lblSol, checkBox});
        h1.setNoWrap();
        FooterContainer footer = new FooterContainer(new com.vaadin.flow.component.Component[]{btnEdit, btnExcluir});
        footer.setWidth("97%");
        box.add(new com.vaadin.flow.component.Component[]{h1, span});
        box.add(new com.vaadin.flow.component.Component[]{footer});
        return box;
    }

    private void habilitaDesmembramento(ClickEvent<Button> e) {
        if (((Button)e.getSource()).getText().equals("Desmembrar")) {
            InformationDialog.show((String)"Desmembramento", (String)"Selecione os produtos que quer desmembrar");
            ((Button)e.getSource()).setText("Confirmar");
            this.itensContainer.getChildren().forEach(item -> item.getChildren().forEach(content -> content.getChildren().forEach(ch -> {
                if (ch.getId().isPresent() && ((String)ch.getId().get()).equals("checkbox")) {
                    ch.setVisible(true);
                }
            })));
        } else {
            ((Button)e.getSource()).setText("Desmembrar");
            ConfirmationDialog cd = new ConfirmationDialog("Desmembramento", "Confirma desmembramento do Pedido?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                int totalItens = this.itens.size();
                this.itensContainer.getChildren().forEach(item -> item.getChildren().forEach(content -> content.getChildren().forEach(ch -> {
                    if (ch.getId().isPresent() && ((String)ch.getId().get()).equals("checkbox") && ((Boolean)((Checkbox)ch).getValue()).booleanValue()) {
                        PedidoItem pi = (PedidoItem)((VerticalContainer)item).getDataObject();
                        this.itensContainer.remove(new com.vaadin.flow.component.Component[]{item});
                        this.itens.remove(pi);
                        this.itensDesmembramento.put(pi, this.pedidoItemService.getItemDados(pi));
                        this.pedidoItemService.deleteItemDados(pi);
                    }
                })));
                if (totalItens != this.itens.size()) {
                    this.salvar();
                    this.itens = this.pedidoService.getItens(this.pedido);
                    this.setTotal();
                    this.precisaRefresh = true;
                    Pedido novo = this.pedidoService.desmembrarPedido(this.getEu(), this.pedido, this.itensDesmembramento);
                    UIUtils.showNotification((String)("Desmembrado com sucesso, novo n\u00famero: " + novo.getNumero()));
                    this.itensDesmembramento = new HashMap();
                    this.createItensContainer();
                } else {
                    UIUtils.showNotification((String)"Nenhum item selecionado.");
                }
                cd.close();
            });
        }
    }

    public Button getBtnSalvar() {
        return this.btnSalvar;
    }

    public Button getBtnFechar() {
        return this.btnFechar;
    }

    public Button getBtnInserir() {
        return this.btnInserir;
    }

    public String getErros() {
        Object erros = "";
        if (this.rbTipo.getValue() == null) {
            erros = (String)erros + "Selecione o tipo da atividade\n";
        }
        if (this.cliente == null) {
            erros = (String)erros + "Selecione o cliente\n";
        }
        if (((Boolean)this.cbFuturo.getValue()).booleanValue() && (this.retornoFuturo.getValue() == null || ((LocalDate)this.retornoFuturo.getValue()).isBefore(LocalDate.now().plusDays(1L)))) {
            erros = (String)erros + "Retorno futuro tem que ser maior que hoje. Que tal usar Notificacao de atividade?";
        }
        if (this.obrigaTagRetornoFuturo.booleanValue() && (((Boolean)this.cbArquivar.getValue()).booleanValue() || ((Boolean)this.cbVendaPerdida.getValue()).booleanValue() || this.cbFuturo.getValue() != null && ((Boolean)this.cbFuturo.getValue()).booleanValue()) && (this.movimentacao.getValue().isBlank() || this.cbTags.getValue().size() <= 0 || this.tagsOriginais.equals(this.pedidoTagsService.getStringtags(this.cbTags.getValue())))) {
            erros = (String)erros + "Informe um motivo na movimentacao\nSelecione uma nova tag com motivo\n";
        }
        if (this.complEstrutura.getObrigaCampoCategoria().booleanValue() && this.cbPedidoCategoria.getValue() == null) {
            erros = (String)erros + this.complEstrutura.getNomeCampoCategoria() + " \u00e9 obrigat\u00f3rio";
        }
        if (this.complEstrutura.getObrigaCampoSubCategoria().booleanValue() && this.cbPedidoSubCategoria.getValue() == null) {
            erros = (String)erros + this.complEstrutura.getNomeCampoSubCategoria() + " \u00e9 obrigat\u00f3rio";
        }
        return erros;
    }

    public Boolean getPrecisaRefresh() {
        return this.precisaRefresh;
    }

    public void setPrecisaRefresh(Boolean precisaRefresh) {
        this.precisaRefresh = precisaRefresh;
    }

    public Pedido salvar() {
        if (!this.getErros().isEmpty()) {
            UIUtils.showNotification((String)this.getErros());
            return null;
        }
        if (this.pedido.getId() == null) {
            this.precisaRefresh = true;
        }
        this.pedido.setCliente(this.cliente);
        this.pedido.setComplementos(this.informacoes.getValue());
        if (this.pedido.getPedidoTipo() == null) {
            this.pedido.setPedidoTipo((PedidoTipoEnum)this.rbTipo.getValue());
        }
        StringBuilder movText = new StringBuilder();
        if (!this.movimentacao.getValue().isEmpty()) {
            movText.append("<B>").append(this.movimentacao.getValue()).append("</B><BR>");
        }
        if (this.pedido.getId() == null && this.cbTags.getValue() != null && !this.cbTags.getValue().isEmpty()) {
            this.pedido.setTags(this.pedidoTagsService.getStringtags(this.cbTags.getValue()));
        }
        if (this.pedido.getTags() == null && this.tagsAnteriores != null || this.tagsAnteriores != null && !this.tagsAnteriores.equals(this.pedidoTagsService.getStringtags(this.cbTags.getValue()))) {
            this.precisaRefresh = true;
            StringBuilder log = new StringBuilder();
            String[] tagsAntes = this.pedido.getTags().split(",");
            for (String ta : tagsAntes) {
                if (ta.isEmpty()) continue;
                boolean achei = false;
                for (PedidoTags pt : this.cbTags.getValue()) {
                    if (!ta.equals(pt.getTag())) continue;
                    achei = true;
                    break;
                }
                if (achei) continue;
                log.append("excluido tag ").append(ta).append("\n");
            }
            for (PedidoTags pt : this.cbTags.getValue()) {
                boolean achei = false;
                for (String ta : tagsAntes) {
                    if (!ta.equals(pt.getTag())) continue;
                    achei = true;
                    break;
                }
                if (achei) continue;
                log.append("incluido tag ").append(pt.getTag()).append("\n");
            }
            if (!log.toString().isEmpty()) {
                movText.append("Altera\u00e7\u00e3o TAGS de [").append(log.toString()).append("]<BR>");
            }
            HashSet tags = new HashSet(this.cbTags.getValue());
            if (!this.hasPermission("ATIVIDADE_TAG_CHANGE") && !this.tagsOriginais.isEmpty()) {
                tags.addAll(this.pedidoTagsService.getHashTags(this.tagsOriginais, this.getEu()));
            }
            this.pedido.setTags(this.pedidoTagsService.getStringtags(tags));
        }
        if (this.pedido.getPedidoEtapa() == null) {
            this.pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaInicial(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
        }
        this.pedido.setObservacao(this.observacoes.getValue() == null || this.observacoes.getValue().isEmpty() ? null : this.observacoes.getValue());
        this.pedido.setItens(this.itens);
        if (((Boolean)this.cbFuturo.getValue()).booleanValue()) {
            this.pedido.setDataRetornoFuturo((LocalDate)this.retornoFuturo.getValue());
            this.pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaRetornoFuturo(this.pedido.getEstruturaUsuario().getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
            this.pedido.setDataHoraUltimaMov(LocalDateTime.now());
            this.precisaRefresh = true;
            movText.append("Retorno Futuro: ").append(((LocalDate)this.retornoFuturo.getValue()).format(FormatDate.DATE_BR.toDTF())).append("<BR>");
            PedidoNotificacao pn = new PedidoNotificacao();
            pn.setData((LocalDate)this.retornoFuturo.getValue());
            pn.setEstruturaUsuario(this.pedido.getEstruturaUsuario());
            pn.setHora(LocalTime.of(8, 0));
            pn.setNotificada(Boolean.valueOf(false));
            pn.setPedido(this.pedido);
            pn.setTipo(PedidoNotificacaoEnum.NOTIFICACAO);
            this.pedidoNotificacaoService.save(pn);
        } else {
            this.pedido.setDataRetornoFuturo(null);
        }
        if (((Boolean)this.cbVendaPerdida.getValue()).booleanValue()) {
            movText.append("(Venda Perdida)<BR>");
            this.pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaVendaPerdida(this.pedido.getEstruturaUsuario().getEstrutura()));
            this.pedido.setDataHoraUltimaMov(LocalDateTime.now());
            this.precisaRefresh = true;
        }
        if (((Boolean)this.cbArquivar.getValue()).booleanValue()) {
            this.pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaArquivamento(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
            this.pedido.setDataHoraUltimaMov(LocalDateTime.now());
            movText.append("(Arquivamento)<BR> ");
            this.precisaRefresh = true;
        }
        if (this.pedido.getPedidoCategoria() == null && this.cbPedidoCategoria.getValue() != null) {
            movText.append(this.complEstrutura.getNomeCampoCategoria()).append(" Inserido ").append(((PedidoCategoria)this.cbPedidoCategoria.getValue()).getNome()).append("<BR>");
        } else if (this.pedido.getPedidoCategoria() != null && this.cbPedidoCategoria.getValue() == null) {
            movText.append(this.complEstrutura.getNomeCampoCategoria()).append(" Removido ").append(this.pedido.getPedidoCategoria().getNome()).append("<BR>");
        } else if (this.pedido.getPedidoCategoria() != null && this.cbPedidoCategoria.getValue() != null && !this.pedido.getPedidoCategoria().getId().equals(((PedidoCategoria)this.cbPedidoCategoria.getValue()).getId())) {
            movText.append(this.complEstrutura.getNomeCampoCategoria()).append(" alterada de ").append(this.pedido.getPedidoCategoria().getNome()).append(" Para ").append(((PedidoCategoria)this.cbPedidoCategoria.getValue()).getNome()).append("<BR>");
        }
        if (this.pedido.getPedidoSubCategoria() == null && this.cbPedidoSubCategoria.getValue() != null) {
            movText.append(this.complEstrutura.getNomeCampoSubCategoria()).append(" Inserido ").append(((PedidoSubCategoria)this.cbPedidoSubCategoria.getValue()).getNome()).append("<BR>");
        } else if (this.pedido.getPedidoSubCategoria() != null && this.cbPedidoSubCategoria.getValue() == null) {
            movText.append(this.complEstrutura.getNomeCampoSubCategoria()).append(" Removido ").append(this.pedido.getPedidoSubCategoria().getNome()).append("<BR>");
        } else if (this.pedido.getPedidoSubCategoria() != null && this.cbPedidoSubCategoria.getValue() != null && !this.pedido.getPedidoSubCategoria().getId().equals(((PedidoSubCategoria)this.cbPedidoSubCategoria.getValue()).getId())) {
            movText.append(this.complEstrutura.getNomeCampoSubCategoria()).append(" alterada de ").append(this.pedido.getPedidoSubCategoria().getNome()).append(" Para").append(((PedidoSubCategoria)this.cbPedidoSubCategoria.getValue()).getNome()).append("<BR>");
        }
        this.pedido.setPedidoCategoria((PedidoCategoria)this.cbPedidoCategoria.getValue());
        this.pedido.setPedidoSubCategoria((PedidoSubCategoria)this.cbPedidoSubCategoria.getValue());
        this.pedido = this.pedidoService.salvar(this.pedido, movText.toString(), this.getEu(), true);
        if (!this.hasPermission("ATIVIDADE_NAO_ENCARTEIRA") && ((PedidoTipoEnum)this.rbTipo.getValue()).equals((Object)PedidoTipoEnum.COMERCIAL)) {
            this.clienteService.insereResponsaveis(this.pedido.getEstruturaUsuario(), this.pedido.getCliente().getId(), this.pedido.getEstruturaUsuario().getId());
        }
        return this.pedido;
    }

    private void setNomeCliente() {
        if (this.cliente.getCpfCnpj().length() == 14) {
            Mailing mailing = this.mailingService.justGet(this.cliente.getCpfCnpj());
            if (mailing != null && !mailing.getSituacao().equals("ATIVA")) {
                this.lblCliente.setText(this.cliente.getNome() + "**INATIVO NA RECEITA**");
                UIUtils.setTextColor((String)"var(--lumo-error-color)", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.lblCliente});
            } else {
                this.lblCliente.setText(this.cliente.getNome());
            }
        } else {
            this.lblCliente.setText(this.cliente.getNome());
        }
    }

    private void setObrigacaoRetornoFuturo() {
        if (this.pedido != null && this.pedido.getId() != null) {
            this.obrigaTagRetornoFuturo = this.complEstrutura.getObrigaTagRetornoFuturo() != false && this.pedido.getPedidoEtapa().getObrigaTagRetornoFuturo() != false;
        }
    }

    private void encarteirar() {
        ArrayList<ProducaoPedidoDTO> lista = new ArrayList<ProducaoPedidoDTO>();
        lista.add(new ProducaoPedidoDTO(this.pedido.getId()));
        DialogAlterarUsuario dau = new DialogAlterarUsuario(this.getEu(), lista, this.pedidoService, this.eus, this.hierarquiaUsuario);
        dau.open();
        dau.getDialog().addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
            if (!close.isOpened()) {
                Pedido pedidoGravado = this.pedidoService.getById(this.pedido.getId());
                this.pedido.setEstruturaUsuario(pedidoGravado.getEstruturaUsuario());
                this.pedido.setEstruturaUsuarioAdm(pedidoGravado.getEstruturaUsuarioAdm());
                this.txtUsuario.setValue(this.pedido.getEstruturaUsuario().getUsuario().getNome());
                this.precisaRefresh = true;
            }
        });
    }

    private void controlaBotoes() {
        if (this.pedido.getId() != null && !this.pedido.getPedidoEtapa().isEditavel()) {
            this.bUser.setEnabled(this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
            this.bMove.setEnabled(this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
            this.bAnchor.setEnabled(this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        } else {
            this.bUser.setEnabled(this.hasPermission("PAINEL_ATIVIDADE_USER_CHANGE"));
            this.bMove.setEnabled(this.hasPermission("PAINEL_ATIVIDADE_ETAPA_CHANGE") || this.hasPermission("KANBAN_ETAPA_CHANGE"));
            this.bAnchor.setEnabled(this.hasPermission("PAINEL_ATIVIDADE_VINCULO"));
        }
    }

    private void changeButtons() {
        if (((PedidoTipoEnum)this.rbTipo.getValue()).equals((Object)PedidoTipoEnum.COMERCIAL)) {
            this.cbVendaPerdida.setVisible(true);
            this.btnInserir.setVisible(true);
            this.compromissoMensal.setVisible(true);
            this.total.setVisible(true);
            this.txtVlAgregado.setVisible(true);
            this.txtVlBaseAtual.setVisible(true);
        } else {
            this.cbVendaPerdida.setVisible(false);
            this.cbVendaPerdida.setValue((Object)false);
            this.compromissoMensal.setVisible(false);
            this.total.setVisible(false);
            this.txtVlAgregado.setVisible(true);
            this.txtVlBaseAtual.setVisible(true);
        }
    }

    private void removeChildrens() {
        try {
            this.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VerticalContainer getAudio() {
        this.btnAudio.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.gravando) {
                this.btnAudio.setIcon((com.vaadin.flow.component.Component)this.normalMic);
                UIUtils.setTooltip((String)"Gravar audio", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnAudio});
                UI.getCurrent().getPage().executeJs("stopRecord()", new Serializable[0]);
                this.btnAudioCancel.setVisible(false);
            } else {
                this.btnAudio.setIcon((com.vaadin.flow.component.Component)this.redMic);
                UIUtils.setTooltip((String)"Enviar grava\u00e7\u00e3o", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnAudio});
                UI.getCurrent().getPage().executeJs("startRecord($0)", new Serializable[]{this});
                this.btnAudioCancel.setVisible(true);
            }
            this.gravando = !this.gravando;
        });
        this.btnAudioCancel.addClickListener((ComponentEventListener & Serializable)e -> {
            this.gravando = false;
            this.btnAudio.setIcon((com.vaadin.flow.component.Component)this.normalMic);
            UIUtils.setTooltip((String)"Gravar audio", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnAudio});
            this.btnAudioCancel.setVisible(false);
            UI.getCurrent().getPage().executeJs("cancelRecord()", new Serializable[0]);
        });
        this.gridAudio = new Grid(PedidoAudio.class);
        this.gridAudio.setColumns(new String[0]);
        this.gridAudio.setWidth("100%");
        this.gridAudio.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            PedidoAudio tl = eg;
            Button b = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.VOLUME, (String)"Ouvir");
            b.setVisible(tl.getHashGravacao() != null);
            b.addClickListener((ComponentEventListener & Serializable)e -> this.audioPlayerView.create(tl.getHashGravacao()));
            Button bt = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir Grava\u00e7\u00e3o");
            bt.setVisible(tl.getHashGravacao() != null);
            bt.setEnabled(tl.getEstruturaUsuario().equals((Object)this.getEu()));
            bt.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("AUDIO", "Confirma exclus\u00e3o?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)x -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)x -> {
                    cd.close();
                    this.pedidoAudioService.delete(tl);
                    UIUtils.showNotification((String)"Excluido com sucesso");
                    this.povoaGridAudio();
                });
            });
            return new HorizontalContainer(new com.vaadin.flow.component.Component[]{b, bt});
        })).setFlexGrow(0).setWidth("150px").setHeader("Anota\u00e7\u00e3o Audio");
        this.gridAudio.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoAudio pa = e;
            return UIUtils.createBreakWrapSpan((String)pa.getNomeAudio());
        })).setHeader("Nome Audio");
        VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        v.setWidth("98%");
        v.setHeight("180px");
        v.add(new com.vaadin.flow.component.Component[]{this.gridAudio});
        this.povoaGridAudio();
        return v;
    }

    private void povoaGridAudio() {
        this.gridAudio.setItems((Collection)this.pedidoAudioService.getAudio(this.pedido));
    }

    @ClientCallable
    public void audioReturn(String audiobase64) {
        try {
            if (audiobase64 == null || audiobase64.isEmpty()) {
                return;
            }
            Dialog d = new Dialog();
            TextField t = new TextField("Nome Audio");
            Button bClose = UIUtils.createSmallButton((String)"Fechar");
            bClose.addClickListener((ComponentEventListener & Serializable)e -> d.close());
            Button bSave = UIUtils.createSmallButton((String)"Salvar");
            bSave.addClickListener((ComponentEventListener & Serializable)e -> {
                if (t.getValue() == null || t.getValue().isEmpty()) {
                    UIUtils.showNotification((String)"Informe um nome para este audio");
                    return;
                }
                this.pedidoAudioService.save(this.getEu(), t.getValue(), this.pedido, audiobase64);
                d.close();
                UIUtils.showNotification((String)"Audio inserido com sucesso");
                this.povoaGridAudio();
            });
            d.add(new com.vaadin.flow.component.Component[]{t, new FooterContainer(new com.vaadin.flow.component.Component[]{bClose, bSave})});
            d.open();
        }
        catch (Exception e2) {
            UIUtils.showNotification((String)("Erro retorno audio " + e2.getMessage()));
        }
    }

    private void interacaoCliente() {
        Dialog d = new Dialog();
        Button btnSave = UIUtils.createSmallButton((String)"Salvar");
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        TextArea ta = new TextArea("Observa\u00e7\u00f5es");
        ta.setWidth("300px");
        ta.setHeight("250px");
        PedidoEtapa pe = this.pedidoEtapaService.getEtapaInteracao(this.getEstrutura());
        btnSave.addClickListener((ComponentEventListener & Serializable)e -> {
            if (ta.getValue() == null || ta.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe uma observacao");
                return;
            }
            this.pedidoService.movimentarInteracao(this.pedido, this.eu, pe, ta.getValue());
            d.close();
        });
        d.setHeaderTitle("Registrar intera\u00e7\u00e3o com o cliente");
        d.add(new com.vaadin.flow.component.Component[]{ta});
        d.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnSave})});
        d.open();
    }

    private void changeCnpj() {
        Dialog d = new Dialog();
        d.setHeaderTitle("Alterar CPF-CNPJ da atividade");
        TextField field = new TextField("Novo Cpf/Cnpj");
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        Button btnSave = UIUtils.createSmallButton((String)"Salvar");
        btnSave.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!ValidationUtil.isValidCnpjAndCpf((String)field.getValue())) {
                UIUtils.showNotification((String)"Cpf-Cnpj inv\u00e1lido");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Alteracao cpf-cnpj", "Confirma a troca de CPF/CNPJ para " + field.getValue() + "?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                Cliente clienteaux = this.clienteService.getAndCreateCliente(this.eu, field.getValue(), new ClienteContato[0]);
                if (!this.clienteService.souResponsavel(clienteaux, this.eu, this.rbTipo.getValue() == null ? this.tipoDefault : (PedidoTipoEnum)this.rbTipo.getValue(), Boolean.valueOf(this.hasPermission("ATIVIDADE_CRIAR_MESMO_ENCARTEIRADO")))) {
                    UIUtils.showNotification((String)"Voc\u00ea n\u00e3o est\u00e1 na lista de respons\u00e1veis deste cliente.");
                    return;
                }
                this.cliente = clienteaux;
                this.pedido.setCliente(this.cliente);
                this.pedido = this.pedidoService.salvar(this.pedido, "CPF-CNPJ alterado de " + this.cpfCnpj.getValue() + " para " + this.cliente.getCpfCnpj(), this.getEu(), false);
                this.cpfCnpj.setValue(this.cliente.getCpfCnpj());
                cd.close();
                d.close();
                clienteaux = null;
            });
        });
        d.add(new com.vaadin.flow.component.Component[]{field});
        d.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnSave})});
        d.open();
    }

    private void setTotal() {
        if (this.pedido != null && this.pedido.getId() != null) {
            BigDecimal valorAgregado = BigDecimal.ZERO;
            BigDecimal valorBaseAtual = BigDecimal.ZERO;
            this.compromissoMensal.setValue(UIUtils.formatCurrency((BigDecimal)this.pedido.getCompromissoMensal()));
            this.total.setValue(UIUtils.formatCurrency((BigDecimal)this.pedido.getTotal()));
            if (!this.isClaro()) {
                return;
            }
            for (PedidoItem pi : this.itens) {
                if (pi.getValorAgregado() != null) {
                    valorAgregado = valorAgregado.add(pi.getValorAgregado());
                }
                if (pi.getValorBaseAtual() == null) continue;
                valorBaseAtual = valorBaseAtual.add(pi.getValorBaseAtual());
            }
            this.txtVlAgregado.setValue(UIUtils.formatCurrency((BigDecimal)valorAgregado));
            this.txtVlBaseAtual.setValue(UIUtils.formatCurrency((BigDecimal)valorBaseAtual));
        }
    }
}

