/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.portabilidade.service;

import br.com.system.app.features.portabilidade.model.Operadora;
import br.com.system.app.features.portabilidade.repository.OperadoraRepository;
import br.com.system.app.features.shared.model.OperadoraEnum;
import br.com.system.commons.TelefoneUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperadoraService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private OperadoraRepository operadoraRepository;

    public List<Operadora> getByAbreviacao(OperadoraEnum operadora) {
        return this.operadoraRepository.findByAbreviacao(operadora);
    }

    public List<Operadora> getByAbreviacaoNot(OperadoraEnum operadora) {
        return this.operadoraRepository.findByAbreviacaoNot(operadora);
    }

    public Long getOperadoraId(String numero) {
        return this.operadoraRepository.getIdOperadora(numero);
    }

    public Operadora getByNome(String nome) {
        return this.operadoraRepository.findFirstByNome(nome);
    }

    public Operadora getOperadora(String numero) {
        if (numero == null) {
            return null;
        }
        Long operadoraId = this.operadoraRepository.getIdOperadora(numero = TelefoneUtil.normalize((String)numero));
        Optional findById = this.operadoraRepository.findById((Object)operadoraId);
        if (findById.isPresent()) {
            return (Operadora)findById.get();
        }
        return this.getByNome("OUTRA");
    }
}

