/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.cep.model.Ddd;
import br.com.system.app.features.cep.repository.DddRepository;
import br.com.system.app.features.claro.CalculoVariacaoRenovacao;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaRepository;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.kanbanpedidos.model.KanbanListenerDTO;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoItemEtapa;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.producaopainel.dto.ProducaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoExportacaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.producaopainel.dto.ProducaoReturnType;
import br.com.system.app.features.producaopainel.model.ProducaoColunas;
import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.model.ProducaoPedidoEtapa;
import br.com.system.app.features.producaopainel.model.ProducaoPedidoItemEtapa;
import br.com.system.app.features.producaopainel.model.ProducaoProdutos;
import br.com.system.app.features.producaopainel.model.ProducaoTipoSolicitacao;
import br.com.system.app.features.producaopainel.repository.ProducaoColunasRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoLinhasRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoPedidoEtapaRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoPedidoItemEtapaRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoTipoSolicitacaoRepository;
import br.com.system.app.features.producaopainel.service.LinhaColuna;
import br.com.system.app.features.producaopainel.service.ProducaoProdutosService;
import br.com.system.app.features.producaopainel.service.ValorQtde;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProducaoPainelService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProducaoPainelRepository producaoPainelRepository;
    @Autowired
    private EstruturaRepository estruturaRepository;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoItemEtapaService pedidoItemEtapaService;
    @Autowired
    private ProducaoColunasRepository producaoColunasRepository;
    @Autowired
    private ProducaoLinhasRepository producaoLinhasRepository;
    @Autowired
    private ProducaoPedidoEtapaRepository producaoPedidoEtapaRepository;
    @Autowired
    private ProducaoPedidoItemEtapaRepository producaoPedidoItemEtapaRepository;
    @Autowired
    private ProducaoTipoSolicitacaoRepository producaoTipoSolicitacaoRepository;
    @Autowired
    private ProducaoProdutosService producaoProdutosService;
    @Autowired
    private DddRepository dddRepository;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private EstruturaTipoService ets;
    @Autowired
    private NotificacoesService notificacoesService;

    public Integer countProducaoByPedido(EstruturaUsuario eu, KanbanListenerDTO dto) {
        return this.producaoPainelRepository.countProducaoByPedido(eu, dto.getFilter());
    }

    public List<ProducaoPedidoDTO> getProducaoByFilter(EstruturaUsuario eu, ProducaoPedidoFilter ppf, Pageable pageable) {
        return this.producaoPainelRepository.getProducaoByPedido(eu, ppf, Boolean.valueOf(false), pageable);
    }

    @Async(value="asyncKanban")
    public void getProducaoByPedido(EstruturaUsuario eu, KanbanListenerDTO dto, Consumer<KanbanListenerDTO> listener) {
        try {
            Thread.currentThread().setName("asyncDefault-get-producao-by-pedido");
            dto.setLista(this.producaoPainelRepository.getProducaoByPedido(eu, dto.getFilter(), dto.isAsc(), (Pageable)PageRequest.of((int)dto.getPaginaAtual(), (int)10)));
            listener.accept(dto);
        }
        catch (Exception e) {
            listener.accept(dto);
        }
    }

    public ProducaoPainel getById(Long id) {
        return this.producaoPainelRepository.findById((Object)id).orElse(null);
    }

    public List<ProducaoPainel> get(EstruturaUsuario eu) {
        return this.producaoPainelRepository.findByEstruturaOrderByPadraoDesc(eu.getEstrutura());
    }

    public List<ProducaoPainel> getByEstrutura(Estrutura estrutura) {
        return this.producaoPainelRepository.findByEstruturaOrderByPadraoDesc(estrutura);
    }

    public ProducaoPainel getPadraoByEstrutura(Estrutura estrutura) {
        return this.producaoPainelRepository.findFirstByEstruturaAndPadrao(estrutura, true);
    }

    public List<ProducaoPainel> getByNomeContains(EstruturaUsuario eu, String nome, Pageable pageable) {
        if (nome != null && !nome.isEmpty()) {
            return this.producaoPainelRepository.findByEstruturaAndNomeContains(eu.getEstrutura(), nome, pageable);
        }
        return this.producaoPainelRepository.findByEstrutura(eu.getEstrutura(), pageable);
    }

    public long countByNomeContains(EstruturaUsuario eu, String nome) {
        if (nome != null && !nome.isEmpty()) {
            return this.producaoPainelRepository.countByEstruturaAndNomeContains(eu.getEstrutura(), nome);
        }
        return this.producaoPainelRepository.countByEstrutura(eu.getEstrutura());
    }

    @Transactional
    public void excluirPainel(ProducaoPainel pp, EstruturaUsuario euContext) {
        List paineis = this.producaoPainelRepository.findByEstruturaEstruturaTipoAndNome(euContext.getEstrutura().getEstruturaTipo(), pp.getNome());
        for (ProducaoPainel painel : paineis) {
            this.producaoPainelRepository.delete((Object)painel);
        }
    }

    @Async(value="asyncDefault")
    public void duplicarPainel(ProducaoPainel pp, EstruturaUsuario euContext, boolean self, boolean sobrepor) {
        Thread.currentThread().setName("asyncDefault-duplicar-painel");
        this.duplicarPainel(pp, euContext, self, sobrepor, null);
    }

    @Async(value="asyncDefault")
    public void duplicarPainel(ProducaoPainel pp, EstruturaUsuario euContext, boolean self, boolean sobrepor, Estrutura destino) {
        List<Estrutura> lista;
        StringBuilder log = new StringBuilder();
        if (self) {
            pp.setNome("Copy " + pp.getNome());
            lista = Arrays.asList(pp.getEstrutura());
        } else {
            lista = destino != null ? Arrays.asList(destino) : this.estruturaRepository.findByEstruturaTipoIdAndAtivo(pp.getEstrutura().getEstruturaTipo().getId(), true);
        }
        int ind = 0;
        for (Estrutura estrutura : lista) {
            try {
                ProducaoPainel newPp;
                if (estrutura.getId().equals(pp.getEstrutura().getId()) && !self) continue;
                log.append(++ind).append(" de ").append(lista.size()).append(" ").append(estrutura.getNome()).append("\n");
                boolean inclusao = false;
                List listaPainelExistente = this.producaoPainelRepository.findByEstruturaAndNome(estrutura, pp.getNome());
                if (listaPainelExistente.size() > 1 && !sobrepor) continue;
                if (listaPainelExistente.size() == 1) {
                    newPp = (ProducaoPainel)listaPainelExistente.get(0);
                } else {
                    inclusao = true;
                    newPp = new ProducaoPainel();
                }
                if (sobrepor && !listaPainelExistente.isEmpty()) {
                    this.producaoPainelRepository.delete((Object)((ProducaoPainel)listaPainelExistente.get(0)));
                    newPp = new ProducaoPainel();
                    inclusao = true;
                }
                newPp.setDataHoraCriacao(LocalDateTime.now());
                newPp.setEstrutura(estrutura);
                newPp.setNome(pp.getNome());
                EstruturaComplemento ec = this.estruturaComplementoService.getComplementos(estrutura);
                newPp.setUsuarioCriacao(ec.getUsuarioMaster());
                newPp.setPadrao(pp.getPadrao());
                if (sobrepor || inclusao) {
                    HashSet<ProducaoColunas> producaoColunas = new HashSet<ProducaoColunas>();
                    for (ProducaoColunas pc : this.producaoColunasRepository.findByProducaoPainel(pp)) {
                        Object ppe2;
                        ProducaoColunas novaColuna = new ProducaoColunas();
                        novaColuna.setConsiderarData(pc.getConsiderarData());
                        novaColuna.setNome(pc.getNome());
                        novaColuna.setPosicaoColuna(pc.getPosicaoColuna());
                        novaColuna.setProducaoPainel(newPp);
                        novaColuna.setNomeBi(pc.getNomeBi());
                        novaColuna.setExecutados(pc.getExecutados());
                        HashSet<ProducaoPedidoEtapa> producaoPedidoEtapa = new HashSet<ProducaoPedidoEtapa>();
                        for (Object ppe2 : this.producaoPedidoEtapaRepository.findByProducaoColunas(pc)) {
                            ProducaoPedidoEtapa newppe = new ProducaoPedidoEtapa();
                            PedidoEtapa etapaPedidoParceiro = this.pedidoEtapaService.getByNome(estrutura, ppe2.getPedidoEtapa().getNome(), ppe2.getPedidoEtapa().getPedidoOrigem(), ppe2.getPedidoEtapa().getPedidoTipo());
                            if (etapaPedidoParceiro == null) continue;
                            newppe.setPedidoEtapa(etapaPedidoParceiro);
                            newppe.setProducaoColunas(novaColuna);
                            producaoPedidoEtapa.add(newppe);
                        }
                        novaColuna.setProducaoPedidoEtapa(producaoPedidoEtapa);
                        HashSet producaoPedidoItemEtapa = new HashSet();
                        ppe2 = this.producaoPedidoItemEtapaRepository.findByProducaoColunas(pc).iterator();
                        while (ppe2.hasNext()) {
                            ProducaoPedidoItemEtapa ppie = (ProducaoPedidoItemEtapa)ppe2.next();
                            ProducaoPedidoItemEtapa newppie = new ProducaoPedidoItemEtapa();
                            PedidoItemEtapa etapaPedidoItemParceiro = this.pedidoItemEtapaService.getByNome(estrutura, ppie.getPedidoItemEtapa().getNome(), ppie.getPedidoItemEtapa().getPedidoOrigem());
                            if (etapaPedidoItemParceiro == null) continue;
                            newppie.setPedidoItemEtapa(etapaPedidoItemParceiro);
                            newppie.setProducaoColunas(novaColuna);
                            producaoPedidoItemEtapa.add(newppie);
                        }
                        novaColuna.setProducaoPedidoItemEtapa((Set)producaoPedidoItemEtapa);
                        producaoColunas.add(novaColuna);
                    }
                    newPp.setProducaoColunas(producaoColunas);
                }
                HashSet<ProducaoLinhas> producaoLinhas = new HashSet<ProducaoLinhas>();
                for (ProducaoLinhas pl : this.producaoLinhasRepository.findByProducaoPainel(pp)) {
                    ProducaoLinhas newpl = inclusao ? new ProducaoLinhas() : this.getLinha(newPp, pl);
                    newpl.setNome(pl.getNome());
                    newpl.setNomeBi(pl.getNomeBi());
                    newpl.setPosicaoLinha(pl.getPosicaoLinha());
                    newpl.setProducaoPainel(newPp);
                    HashSet<ProducaoProdutos> producaoProdutos = new HashSet<ProducaoProdutos>();
                    for (ProducaoProdutos prodProd : this.producaoProdutosService.getByProducaoLinhas(pl)) {
                        ProducaoProdutos newProdProd = new ProducaoProdutos();
                        newProdProd.setProducaoLinhas(newpl);
                        newProdProd.setProduto(prodProd.getProduto());
                        producaoProdutos.add(newProdProd);
                    }
                    newpl.setProducaoProdutos(producaoProdutos);
                    HashSet<ProducaoTipoSolicitacao> producaoTipoSolicitacao = new HashSet<ProducaoTipoSolicitacao>();
                    for (ProducaoTipoSolicitacao pts : this.producaoTipoSolicitacaoRepository.findByProducaoLinhas(pl)) {
                        ProducaoTipoSolicitacao newpts = new ProducaoTipoSolicitacao();
                        newpts.setPedidoItemSolicitacao(pts.getPedidoItemSolicitacao());
                        newpts.setProducaoLinhas(newpl);
                        producaoTipoSolicitacao.add(newpts);
                    }
                    newpl.setProducaoTipoSolicitacao(producaoTipoSolicitacao);
                    producaoLinhas.add(newpl);
                }
                newPp.setProducaoLinhas(producaoLinhas);
                this.salvarPainel(newPp, euContext);
            }
            catch (Exception e) {
                log.append("Erro: ").append(e.getMessage());
            }
        }
        this.notificacoesService.notify(euContext, "Replica\u00e7\u00e3o de painel finalizada", log.toString());
    }

    public void delete(ProducaoPainel producaoPainel) {
        this.producaoPainelRepository.delete((Object)producaoPainel);
    }

    @Transactional
    public ProducaoPainel salvarPainel(ProducaoPainel pp, EstruturaUsuario euContext) {
        ValidationUtil.getInstance().isBlank((Object)pp.getNome(), "Nome \u00e9 obrigat\u00f3rio").isNull((Object)pp.getProducaoColunas(), "Colunas n\u00e3o informadas.").isNull((Object)pp.getProducaoLinhas(), "Linhas n\u00e3o informadas");
        if (pp.getDataHoraCriacao() == null) {
            pp.setDataHoraCriacao(LocalDateTime.now());
        }
        if (pp.getUsuarioCriacao() == null) {
            pp.setUsuarioCriacao(euContext.getUsuario());
        }
        if (pp.getEstrutura() == null) {
            pp.setEstrutura(euContext.getEstrutura());
        }
        return (ProducaoPainel)this.producaoPainelRepository.save((Object)pp);
    }

    @Async(value="asyncDefault")
    public void getDados(ProducaoPainel painel, String dataInicial, String dataFinal, ProducaoReturnType prt, HierarquiaDTO usuarioFiltro, Set<Equipe> equipes, Set<EstruturaSenhas> senha, EstruturaUsuario euContext, Boolean ignoraHierarquia, Consumer<List<ProducaoDTO>> listener) {
        try {
            HashSet<Long> equipe = new HashSet<Long>();
            for (Equipe e : equipes) {
                equipe.add(e.getId());
            }
            List producao = this.producaoPainelRepository.getProducao(euContext, painel, dataInicial, dataFinal, usuarioFiltro, equipe, senha, prt, ignoraHierarquia);
            HashMap<LinhaColuna, ValorQtde> hm = new HashMap<LinhaColuna, ValorQtde>();
            for (Object p : producao) {
                LinhaColuna linhaColuna = new LinhaColuna();
                linhaColuna.setColuna(p.getNomeColuna());
                linhaColuna.setLinha(p.getNomeLinha());
                linhaColuna.setPosicaoLinha(p.getPosicaoLinha());
                linhaColuna.setPosicaoColuna(p.getPosicaoColuna());
                if (hm.containsKey(linhaColuna)) {
                    ((ValorQtde)hm.get(linhaColuna)).setQuantidade(Integer.valueOf(((ValorQtde)hm.get(linhaColuna)).getQuantidade() + p.getQuantidade()));
                    ((ValorQtde)hm.get(linhaColuna)).setValor(Double.valueOf(((ValorQtde)hm.get(linhaColuna)).getValor() + p.getValor()));
                    continue;
                }
                ValorQtde valorQtde = new ValorQtde();
                valorQtde.setQuantidade(p.getQuantidade());
                valorQtde.setValor(p.getValor());
                hm.put(linhaColuna, valorQtde);
            }
            producao.clear();
            ArrayList<ProducaoDTO> retorno = new ArrayList<ProducaoDTO>();
            for (Map.Entry entry : hm.entrySet()) {
                ProducaoDTO p = new ProducaoDTO();
                p.setId(HashUtil.getUUI());
                p.setNomeColuna(((LinhaColuna)entry.getKey()).getColuna());
                p.setNomeLinha(((LinhaColuna)entry.getKey()).getLinha());
                p.setQuantidade(((ValorQtde)entry.getValue()).getQuantidade());
                p.setPosicaoColuna(((LinhaColuna)entry.getKey()).getPosicaoColuna());
                p.setPosicaoLinha(((LinhaColuna)entry.getKey()).getPosicaoLinha());
                p.setValor(((ValorQtde)entry.getValue()).getValor());
                retorno.add(p);
            }
            if (prt.equals((Object)ProducaoReturnType.GERAL)) {
                comparator = Comparator.comparingInt(ProducaoDTO::getPosicaoLinha).thenComparingInt(ProducaoDTO::getPosicaoColuna);
                retorno.sort(comparator);
            } else {
                comparator = Comparator.comparing(ProducaoDTO::getNomeLinha).thenComparing(ProducaoDTO::getNomeLinha);
                retorno.sort(comparator);
            }
            listener.accept(retorno);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("Erro ao buscar dados de producao");
        }
    }

    @Async(value="asyncDefault")
    public void getDadosExportacao(ProducaoPainel painel, String dataInicial, String dataFinal, ProducaoReturnType prt, HierarquiaDTO usuarioFiltro, Set<Equipe> equipes, Set<EstruturaSenhas> senha, EstruturaUsuario euContext, Boolean ignoraHierarquia, Consumer<String> listener) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            HashSet<Long> equipe = new HashSet<Long>();
            for (Equipe e : equipes) {
                equipe.add(e.getId());
            }
            List lista = this.producaoPainelRepository.getProducaoExportacao(euContext, painel, dataInicial, dataFinal, usuarioFiltro, equipe, senha, prt, null, null, ignoraHierarquia);
            String nomeArquivo = this.ets.isVivo(painel.getEstrutura()) ? "ExportacaoProducaoVivo-v10.xlsx" : (this.ets.isClaro(painel.getEstrutura()) ? "ExportacaoProducaoClaro-v10.xlsx" : (this.ets.isTim(painel.getEstrutura()) ? "ExportacaoProducaoTim-v6.xlsx" : (this.ets.isConsultoria(painel.getEstrutura()) ? "ExportacaoProducaoConsultoria-v6.xlsx" : (this.ets.isOi(painel.getEstrutura()) ? "ExportacaoProducaoOi-v3.xlsx" : (this.ets.isAlgar(painel.getEstrutura()) ? "ExportacaoProducaoAlgar-v3.xlsx" : (this.ets.isTicket(painel.getEstrutura()) ? "ExportacaoProducaoTicket-v1.xlsx" : (this.ets.isProvedor(painel.getEstrutura()) ? "ExportacaoProducaoProvedor-v3.xlsx" : "ExportacaoProducaoOutros-v6.xlsx")))))));
            is = StorageUtil.getObjectModelo((String)nomeArquivo);
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int i = 1;
            EstruturaComplemento eComp = this.estruturaComplementoService.getComplementos(painel.getEstrutura());
            for (ProducaoExportacaoDTO ped : lista) {
                aba.createRow(i);
                int col = 0;
                aba.getRow(i).createCell(col).setCellValue(ped.getNomeLinha());
                aba.getRow(i).createCell(++col).setCellValue(ped.getNomeColuna());
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNumeroPedido()));
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    String psc = "";
                    if (ped.getNumeroPedidoVinculado() != null && !ped.getNumeroPedidoVinculado().isEmpty()) {
                        psc = ped.getNumeroPedidoVinculado();
                    } else if (ped.getCotacao() != null && !ped.getCotacao().isEmpty()) {
                        psc = ped.getCotacao();
                    } else if (ped.getNumeroSimulacao() != null && !ped.getNumeroSimulacao().isEmpty()) {
                        psc = ped.getNumeroSimulacao();
                    }
                    aba.getRow(i).createCell(++col).setCellValue(psc);
                }
                if (this.ets.isVivo(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCotacao()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNumeroPedidoOrigem()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCodigoPortabilidade()));
                }
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getLoginOperadora()));
                }
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeCliente()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCpfCnpj()));
                aba.getRow(i).createCell(++col).setCellValue(ped.getCpfCnpj().length() == 14 ? "PJ" : "PF");
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCidade()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getEstado()));
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getDDD(ped));
                }
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeUsuario()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getUsuarioTags()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeUsuarioAdm()));
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeConsultorOperadora()));
                }
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeEquipe()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeEtapa()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCategoriaAtividade()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getSubCategoriaAtividade()));
                aba.getRow(i).createCell(++col).setCellValue(this.getDate(ped.getDataCadastro()));
                aba.getRow(i).createCell(++col).setCellValue(this.getDateTime(ped.getDataHoraAtualizacao()));
                aba.getRow(i).createCell(++col).setCellValue(PedidoItemSolicitacao.getStaticName((Long)ped.getPedidoItemSolicitacaoId()));
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getTipoNegociacao()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNotasFiscais()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getRevisao()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getAtividades()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getItem()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNumeroTelefoneItem()));
                }
                if (this.ets.isVivo(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNumeroProvisorio()));
                }
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeEtapaItem()));
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getDate(ped.getDataPortabilidade()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getOperadoraCedente()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeCedente()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCpfCnpjCedente()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getTelefoneCedente()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getEmailCedente()));
                }
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeProduto()));
                if (this.ets.isTicket(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNumeroTelefoneItem()));
                    aba.getRow(i).createCell(++col).setCellValue(ped.getValorUnitario().doubleValue());
                    aba.getRow(i).createCell(++col).setCellValue(ped.getValorDesconto().doubleValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    aba.getRow(i).createCell(++col).setCellValue(ped.getSomaQuantidade() != false ? (double)ped.getQuantidade().intValue() : 0.0);
                    aba.getRow(i).createCell(++col).setCellValue(ped.getValor().doubleValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                } else {
                    aba.getRow(i).createCell(++col).setCellValue(ped.getValor().doubleValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    aba.getRow(i).createCell(++col).setCellValue(ped.getSomaQuantidade() != false ? (double)ped.getQuantidade().intValue() : 0.0);
                }
                aba.getRow(i).createCell(++col).setCellValue(this.getDate(ped.getDataReferencia()));
                if (this.ets.isTelefonia(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getNomeOrigem()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getDate(ped.getDataInstalacao()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getPeriodo()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getCidadeInstalacao()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getEstadoInstalacao()));
                }
                if (this.ets.isVivo(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getRpon()));
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getInstancia()));
                }
                String[] arrTag = this.getField(ped.getTags()).split(",");
                if (this.ets.isClaro(painel.getEstrutura())) {
                    aba.getRow(i).createCell(++col).setCellValue(ped.getPercentualDesconto() == null ? 0.0 : (double)ped.getPercentualDesconto().intValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    Double variacao = CalculoVariacaoRenovacao.calcular((Double)(ped.getValorUnitario() == null ? null : Double.valueOf(ped.getValorUnitario().doubleValue())), (Double)(ped.getValorBaseAtual() == null ? null : Double.valueOf(ped.getValorBaseAtual().doubleValue())), ped.getValorAgregado() == null ? null : Double.valueOf(ped.getValorAgregado().doubleValue()), (EstruturaComplemento)eComp);
                    if (variacao == null) {
                        variacao = 0.0;
                    }
                    aba.getRow(i).createCell(++col).setCellValue(variacao.doubleValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    aba.getRow(i).createCell(++col).setCellValue(ped.getValorBaseAtual() == null ? 0.0 : ped.getValorBaseAtual().doubleValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    aba.getRow(i).createCell(++col).setCellValue(ped.getValorAgregado() == null ? 0.0 : ped.getValorAgregado().doubleValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    aba.getRow(i).createCell(++col).setCellValue(ped.getPercentualTroca() == null ? 0.0 : (double)ped.getPercentualTroca().intValue());
                    aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                    aba.getRow(i).createCell(++col).setCellValue(this.getField(ped.getClusterOrigem()));
                    aba.getRow(i).createCell(++col).setCellValue(ped.getAparelhoCartaoCredito() == null ? "" : (ped.getAparelhoCartaoCredito() != false ? "SIM" : "N\u00c3O"));
                    for (int t = 0; t < arrTag.length; ++t) {
                        aba.getRow(i).createCell(++col).setCellValue(arrTag[t]);
                    }
                } else {
                    for (int t = 0; t < arrTag.length; ++t) {
                        aba.getRow(i).createCell(++col).setCellValue(arrTag[t]);
                    }
                }
                ++i;
            }
            String hashFile = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String hash = StorageUtil.uploadObjectInputStream((String)hashFile, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            listener.accept(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("Erro ao buscar dados de producao");
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getField(String field) {
        if (field == null) {
            return "";
        }
        return field.trim();
    }

    private String getDate(LocalDate dataBanco) {
        return dataBanco == null ? "" : dataBanco.format(FormatDate.DATE_BR.toDTF());
    }

    private String getDateTime(LocalDateTime dataHoraBanco) {
        return dataHoraBanco == null ? "" : dataHoraBanco.format(FormatDate.DATETIME_BR.toDTF());
    }

    private String getDDD(ProducaoExportacaoDTO ped) {
        Ddd ddd;
        if ((ped.getDdd() == null || ped.getDdd().isEmpty() || ped.getDdd().equals("0")) && (ddd = this.dddRepository.findFirstByEstadoAndCidade(ped.getEstado(), ped.getCidade())) != null && ddd.getDdd() > 0) {
            return ddd.getDdd().toString();
        }
        return ped.getDdd();
    }

    private ProducaoLinhas getLinha(ProducaoPainel newPp, ProducaoLinhas pl) {
        List linhas = this.producaoLinhasRepository.findByProducaoPainel(newPp);
        if (linhas == null || linhas.isEmpty()) {
            return new ProducaoLinhas();
        }
        for (ProducaoLinhas linha : linhas) {
            if (!pl.getNome().equals(linha.getNome())) continue;
            return linha;
        }
        return new ProducaoLinhas();
    }
}

