/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.produto.repository;

import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.produto.dto.ProdutoDTO;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.repository.ProdutoRepositoryQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class ProdutoRepositoryImpl
implements ProdutoRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<ProdutoDTO> findProdutos(EstruturaTipo estruturaTipo, String nome, ProdutoCategoria categoria, Boolean ativo, Pageable pageable) {
        if (estruturaTipo == null) {
            return new ArrayList<ProdutoDTO>();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select produto.id,produto.nome,produto_categoria.nome categoria,produto.ativo,produto.origem,produto.valor,");
        sql.append("produto.desconto_prateleira,produto.compromisso_mensal,produto.soma_quantidade,estrutura_tipo.nome estrutura_tipo");
        sql.append(" from produto , produto_categoria,estrutura_tipo");
        sql.append(" WHERE produto.produto_categoria_id=produto_categoria.id and produto.estrutura_tipo_id=estrutura_tipo.id");
        sql.append(" AND produto.estrutura_tipo_id=:estruturaTipoId");
        if (nome != null && !nome.isEmpty()) {
            sql.append(" and nome like :nome");
        }
        if (categoria != null) {
            sql.append(" and produto_categoria_id=:produtoCategoriaId");
        }
        if (ativo != null) {
            sql.append(" and produto.ativo=:ativo");
        }
        if (pageable != null) {
            sql.append(" limit :limit offset :offset");
        }
        Query query = this.manager.createNativeQuery(sql.toString(), ProdutoDTO.class);
        query.setParameter("estruturaTipoId", (Object)estruturaTipo.getId());
        if (nome != null && !nome.isEmpty()) {
            query.setParameter("nome", (Object)nome);
        }
        if (categoria != null) {
            query.setParameter("produtoCategoriaId", (Object)categoria.getId());
        }
        if (ativo != null) {
            query.setParameter("ativo", (Object)ativo);
        }
        if (pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query.getResultList();
    }
}

