/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sac.service;

import br.com.system.app.features.sac.model.SacChamado;
import br.com.system.app.features.sac.model.SacEtapa;
import br.com.system.app.features.sac.model.SacMovimentacao;
import br.com.system.app.features.sac.repository.SacMovimentacaoRepository;
import br.com.system.app.features.sac.repository.SacRepository;
import br.com.system.app.features.sac.service.SacEtapaService;
import br.com.system.app.features.sac.service.SacService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SacMovimentacaoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SacService sacService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private SacEtapaService sacEtapaService;
    @Autowired
    private SacRepository sacRepository;
    @Autowired
    private SacMovimentacaoRepository sacMovimentacaoRepository;

    @Transactional
    public SacMovimentacao movimentar(Long idSac, SacMovimentacao sacMovimentacao) {
        SacChamado sac = this.sacService.buscarPeloId(idSac);
        Usuario usuario = (Usuario)this.usuarioService.getById(sacMovimentacao.getUsuario().getId()).orElseThrow(() -> new BusinessException("exceptions.usuario.not-found"));
        SacEtapa etapaAtual = this.sacEtapaService.buscarPeloId(sacMovimentacao.getEtapaAtual().getId());
        sacMovimentacao.setDataHora(LocalDateTime.now());
        sacMovimentacao.setSacChamado(sac);
        sacMovimentacao.setEtapaAtual(etapaAtual);
        sacMovimentacao.setEtapaAnterior(sac.getEtapa());
        sacMovimentacao.setUsuario(usuario);
        SacMovimentacao movimentacaoSalva = (SacMovimentacao)this.sacMovimentacaoRepository.save((Object)sacMovimentacao);
        sac.setEtapa(etapaAtual);
        this.sacRepository.save((Object)sac);
        return movimentacaoSalva;
    }
}

