/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sessions;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.sessions.model.SessionsDTO;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinSession;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="sessions", layout=MainLayout.class)
@PageTitle(value="Sess\u00f5es ativas")
@RolesAllowed(value={"SESSIONS_VIEW"})
public class SessionsView
extends ViewFrame {
    private static final long serialVersionUID = 1L;
    private final SessionsService sessionsService;
    private Span lblTotal;

    public SessionsView(SessionsService sessionsService) {
        this.sessionsService = sessionsService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.create());
        }
    }

    private VerticalContainer create() {
        GridCrud crud = new GridCrud(SessionsDTO.class);
        RadioButtonGroup rb = new RadioButtonGroup();
        rb.setItems((Object[])new String[]{"Sessoes Ativas", "Todas"});
        rb.setValue((Object)"Sessoes Ativas");
        DatePicker dataInicial = new DatePicker();
        dataInicial.setLabel("Inicial");
        dataInicial.setValue(LocalDate.now());
        dataInicial.setLocale(UIUtils.getLocale());
        DatePicker dataFinal = new DatePicker();
        dataFinal.setLabel("Final");
        dataFinal.setValue(LocalDate.now());
        dataFinal.setLocale(UIUtils.getLocale());
        Button pesquisar = UIUtils.createSmallButton((String)"Pesquisar", (String)"");
        pesquisar.setDisableOnClick(true);
        pesquisar.addClickListener((ComponentEventListener & Serializable)e -> {
            crud.refreshGrid();
            pesquisar.setEnabled(true);
        });
        this.lblTotal = new Span();
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por login");
        filter.setClearButtonVisible(true);
        crud.getCrudLayout().addFilterComponent((Component)filter);
        crud.getCrudLayout().addToolbarComponent((Component)this.lblTotal);
        crud.getAddButton().setText("Adicionar");
        crud.getGrid().setColumns(new String[0]);
        crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)s -> {
            Icon icon = new Icon(VaadinIcon.USER);
            if (s.getSessionId().equals(VaadinSession.getCurrent().getSession().getId())) {
                icon.setVisible(true);
            } else {
                icon.setVisible(false);
            }
            return icon;
        })).setFlexGrow(0).setWidth("80px");
        crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeUsuario()))).setHeader("Usuario").setFlexGrow(0).setWidth("250px");
        crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLoginUsuario()))).setHeader("Login").setFlexGrow(0).setWidth("250px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)s -> s.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Cria\u00e7\u00e3o").setFlexGrow(0).setWidth("180px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)s -> s.getLastHeartbeat().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Last Heartbeat").setFlexGrow(0).setWidth("180px");
        crud.getGrid().addColumns(new String[]{"hostname", "ipAddress", "browser", "os"});
        crud.getDeleteButton().setVisible(false);
        crud.getAddButton().setVisible(false);
        crud.getUpdateButton().setVisible(false);
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        return new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{rb, dataInicial, dataFinal, pesquisar}), crud});
    }
}

