/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.sms.service.SmsService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioConfirmacao;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnum;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnvioEnum;
import br.com.system.app.features.usuario.repository.UsuarioConfirmacaoRepository;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.commons.HashUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UsuarioConfirmacaoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioConfirmacaoRepository repository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private WhatsAppSendService whatsAppSendService;
    @Autowired
    private SendMailService sendMailService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private UsuarioService usuarioService;

    public void isValidLogin(String login, String codigo, UsuarioConfirmacaoTipoEnum tipo) throws Exception {
        if (codigo.isEmpty()) {
            throw new Exception("Informe o C\u00f3digo Autenticador 2FA");
        }
        Usuario usuario = this.usuarioService.getByLogin(login);
        if (usuario == null) {
            throw new Exception("Usu\u00e1rio n\u00e3o encontrado ");
        }
        EstruturaUsuario eu = this.eus.getFirstByUsuario(usuario);
        if (eu == null) {
            throw new Exception("Usu\u00e1rio n\u00e3o encontrado ");
        }
        if (!this.isValid(eu, codigo, tipo)) {
            throw new Exception("C\u00f3digo inv\u00e1lido");
        }
    }

    public boolean isValid(EstruturaUsuario eu, String codigo, UsuarioConfirmacaoTipoEnum tipo) {
        UsuarioConfirmacao uc = this.getByEstruturaUsuario(eu, tipo);
        if (uc == null) {
            return false;
        }
        if (!uc.getCodigoGerado().equals(codigo)) {
            return false;
        }
        if (uc.getDataHoraConfirmacao() != null) {
            return false;
        }
        if (uc.getDataHoraSolicitacao().plusMinutes(uc.getMinutosValidade().intValue()).isBefore(LocalDateTime.now())) {
            return false;
        }
        uc.setDataHoraConfirmacao(LocalDateTime.now());
        this.save(uc);
        return true;
    }

    public UsuarioConfirmacao save(UsuarioConfirmacao uc) {
        return (UsuarioConfirmacao)this.repository.save((Object)uc);
    }

    private UsuarioConfirmacao sendConfirmation(EstruturaUsuario eu, UsuarioConfirmacaoTipoEnum tipo, Integer minutosValidade) {
        UsuarioConfirmacao uc = this.repository.findByEstruturaUsuarioAndTipo(eu, tipo);
        if (uc == null) {
            uc = new UsuarioConfirmacao();
        }
        String codigo = HashUtil.get6Code();
        uc.setCodigoGerado(codigo);
        uc.setDataHoraSolicitacao(LocalDateTime.now());
        uc.setDataHoraConfirmacao(null);
        uc.setTipo(tipo);
        uc.setEstruturaUsuario(eu);
        uc.setMinutosValidade(minutosValidade);
        return this.save(uc);
    }

    @Async(value="asyncDefault")
    public void sendForLogin(String login, UsuarioConfirmacaoTipoEnvioEnum tipo) {
        try {
            Usuario usuario = this.usuarioService.getByLogin(login);
            if (usuario == null) {
                return;
            }
            EstruturaUsuario eu = this.eus.getFirstByUsuario(usuario);
            if (eu == null) {
                return;
            }
            if (!eu.isAtivo() || !eu.getEstrutura().isAtivo()) {
                return;
            }
            if (tipo.equals((Object)UsuarioConfirmacaoTipoEnvioEnum.EMAIL)) {
                this.sendByEmail(eu, usuario.getEmail(), UsuarioConfirmacaoTipoEnum.EMAIL, Integer.valueOf(5));
            } else {
                this.sendByPhone(eu, usuario.getCelular(), UsuarioConfirmacaoTipoEnum.TELEFONE, tipo, Integer.valueOf(5));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Async(value="asyncDefault")
    public void sendByPhone(EstruturaUsuario eu, String celular, UsuarioConfirmacaoTipoEnum tipo, UsuarioConfirmacaoTipoEnvioEnum tipoEnvio, Integer minutosValidade) {
        Thread.currentThread().setName("asyncDefault-send-by-phone");
        UsuarioConfirmacao uc = this.sendConfirmation(eu, tipo, minutosValidade);
        String texto = "Ol\u00e1, seu codigo de Verifica\u00e7\u00e3o \u00e9 [" + uc.getCodigoGerado() + "] e estar\u00e1 v\u00e1lido por " + uc.getMinutosValidade() + " min.";
        if (tipoEnvio.equals((Object)UsuarioConfirmacaoTipoEnvioEnum.SMS)) {
            this.smsService.sendSms(eu, celular, texto);
        } else if (tipoEnvio.equals((Object)UsuarioConfirmacaoTipoEnvioEnum.WHATSAPP)) {
            this.whatsAppSendService.sendAutenticacao(celular, texto);
        }
    }

    @Async(value="asyncDefault")
    public void sendByEmail(EstruturaUsuario eu, String email, UsuarioConfirmacaoTipoEnum tipo, Integer minutosValidade) {
        Thread.currentThread().setName("asyncDefault-send-by-email");
        try {
            UsuarioConfirmacao uc = this.sendConfirmation(eu, tipo, minutosValidade);
            this.sendMailService.sendNoReply(eu, email, "NEO SALES C\u00f3digo de Verifica\u00e7\u00e3o " + uc.getCodigoGerado(), this.getHtmlCodigo(uc));
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao solicitar senha: " + e.getMessage());
        }
    }

    public UsuarioConfirmacao getByEstruturaUsuario(EstruturaUsuario eu, UsuarioConfirmacaoTipoEnum tipo) {
        return this.repository.findByEstruturaUsuarioAndTipo(eu, tipo);
    }

    private String getHtmlCodigo(UsuarioConfirmacao uc) {
        return "<!DOCTYPE html>\n<html lang=\"pt-BR\">\n<head>\n  <meta charset=\"UTF-8\">\n  <title>C\u00f3digo de Verifica\u00e7\u00e3o - NEO SALES</title>\n</head>\n<body style=\"margin: 0; padding: 0; background-color: #f4f6f8; font-family: Arial, sans-serif;\">\n  <table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n    <tr>\n      <td align=\"center\" style=\"padding: 40px 0;\">\n        <table width=\"600\" cellpadding=\"0\" cellspacing=\"0\" style=\"background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 0 10px rgba(0,0,0,0.05);\">\n          <tr>\n            <td align=\"center\" style=\"background-color: #005bac; padding: 20px;\">\n              <img src=\"http://neocrm.com.br/wp-content/uploads/2022/07/neo-login.png\" alt=\"NEO SALES\" style=\"width: 150px;\">\n            </td>\n          </tr>\n          <tr>\n            <td style=\"padding: 40px 30px; color: #333333;\">\n              <h2 style=\"margin-top: 0;\">Seu c\u00f3digo de verifica\u00e7\u00e3o</h2>\n              <p style=\"font-size: 16px; line-height: 1.5;\">\n                Ol\u00e1,<br><br>\n                Recebemos uma solicita\u00e7\u00e3o para acessar sua conta na <strong>NEO SALES</strong>. Para continuar, use o c\u00f3digo abaixo:\n              </p>\n\n              <div style=\"text-align: center; margin: 30px 0;\">\n                <span style=\"display: inline-block; font-size: 28px; font-weight: bold; color: #005bac; background-color: #f0f4fa; padding: 15px 30px; border-radius: 6px;\">\n                  " + uc.getCodigoGerado() + "\n                </span>\n              </div>\n\n              <p style=\"font-size: 14px; color: #666;\">\n                O c\u00f3digo \u00e9 v\u00e1lido por " + uc.getMinutosValidade() + " minutos. Se voc\u00ea n\u00e3o solicitou este acesso, pode ignorar este e-mail com seguran\u00e7a.\n              </p>\n            </td>\n          </tr>\n          <tr>\n            <td style=\"background-color: #f0f4fa; padding: 20px; text-align: center; font-size: 12px; color: #999;\">\n              \u00a9 2025 NEO SALES. Todos os direitos reservados.\n            </td>\n          </tr>\n        </table>\n      </td>\n    </tr>\n  </table>\n</body>\n</html>";
    }
}

