/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.util;

import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioSenhaService;
import br.com.system.commons.StringUtil;

public class UsuarioValidacaoSenha {
    public static String valido(Usuario usuario, String senha, String senhaConfirmacao, UsuarioSenhaService usuarioSenhaService) {
        StringBuilder erro = new StringBuilder();
        if (senha == null) {
            return "Senha deve ser informada";
        }
        if (senhaConfirmacao == null) {
            return "Senha de confirmacao deve ser informada";
        }
        if (senha.length() < 8) {
            return "M\u00ednimo de 8 caracteres\n";
        }
        if (senha.toLowerCase().equals(senha)) {
            return "M\u00ednimo 1 letra Mai\u00fascula\n";
        }
        if (senha.toUpperCase().equals(senha)) {
            return "M\u00ednimo 1 letra Min\u00fascula\n";
        }
        if (StringUtil.removeNonLetters((String)senha).equals(senha)) {
            return "M\u00ednimo 1 N\u00famero\n";
        }
        if (StringUtil.removeNonNumber((String)senha).equals(senha)) {
            return "M\u00ednimo 1 letra Mai\u00fascula e 1 Min\u00fascula\n";
        }
        if (StringUtil.hasExcessiveOccurrences((String)senha, (int)2)) {
            return "Nao pode haver mais de 2 caracteres iguais em sequencia\n";
        }
        if (!usuarioSenhaService.checarSenhasUtilizadas(usuario, senha)) {
            return "Voce nao pode reutilizar as ultimas 5 senhas.\n";
        }
        String login = usuario.getLogin().split("@")[0].toUpperCase();
        String estrutura = usuario.getLogin().split("@")[1].toUpperCase();
        if (senha.toUpperCase().contains(login)) {
            return "Seu login nao pode fazer parte da senha\n";
        }
        if (senha.toUpperCase().contains(estrutura)) {
            return "Nome da sua estrutura nao pode fazer parte da senha\n";
        }
        if (!senha.equals(senhaConfirmacao)) {
            return "Senhas n\u00e3o conferem\n";
        }
        return erro.toString();
    }

    public static String getRegras() {
        return "<span>M\u00ednimo de 8 caracteres<BR>M\u00ednimo 1 letra Maiuscula<BR>M\u00ednimo 1 letra Min\u00fascula<BR>M\u00ednimo 1 N\u00famero<BR>Nao pode conter seu usuario<BR>Nao pode conter o nome da sua empresa<BR>Nao pode conter mais de 2 caracteres em sequencia<BR>Nao pode reutilizar as ultimas 5 senhas</span>";
    }
}

