/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.vivo;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.oportunidade.service.OportunidadeService;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.features.vivo.VivoProspectBiView;
import br.com.system.app.features.vivo.model.VivoProspectBiFile;
import br.com.system.app.features.vivo.model.VivoProspectBiItens;
import br.com.system.app.features.vivo.service.VivoProspectBiService;
import br.com.system.app.features.vivo.service.VivoProspectBiUploadService;
import br.com.system.app.features.whatsapp.service.WhatsAppCobrancaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.SleepUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="vivoprospectbi", layout=MainLayout.class)
@PageTitle(value="VIVO Prospect BI")
@RolesAllowed(value={"PROSPECT_BI_VIEW"})
public class VivoProspectBiView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final VivoProspectBiUploadService uploadService;
    private final VivoProspectBiService prospectBiService;
    private final OportunidadeService oportunidadeService;
    private final EnriquecimentoService enriquecimentoService;
    private final WhatsAppCobrancaService whatsAppCobrancaDialog;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private GridCrud<VivoProspectBiFile> crud;
    private VivoProspectBiFile selectedFile;
    private Registration registrationDialogWhats;
    private DownloadDialog dd;

    @Autowired
    public VivoProspectBiView(VivoProspectBiUploadService uploadService, VivoProspectBiService prospectBiService, OportunidadeService oportunidadeService, EnriquecimentoService enriquecimentoService, WhatsAppCobrancaService whatsAppCobrancaDialog) {
        this.uploadService = uploadService;
        this.whatsAppCobrancaDialog = whatsAppCobrancaDialog;
        this.enriquecimentoService = enriquecimentoService;
        this.oportunidadeService = oportunidadeService;
        this.prospectBiService = prospectBiService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.clear();
    }

    private void clear() {
        if (this.registrationDialogWhats != null) {
            this.registrationDialogWhats.remove();
        }
    }

    private Component createContent() {
        this.clear();
        this.dd = new DownloadDialog();
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.createUpload()})});
        v.add(new Component[]{this.getButtons()});
        v.add(new Component[]{this.createGrid()});
        return v;
    }

    private HorizontalContainer getButtons() {
        Button btnEnriquecimento = UIUtils.createSmallButton((String)"Enriquecimento");
        btnEnriquecimento.addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(ProcessoEnum.ENRIQUECIMENTO));
        Button btnOportunidade = UIUtils.createSmallButton((String)"Oportunidade");
        btnOportunidade.addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(ProcessoEnum.OPORTUNIDADE));
        return new HorizontalContainer(new Component[]{btnEnriquecimento, btnOportunidade});
    }

    private void openDialog(ProcessoEnum processo) {
        if (this.selectedFile == null) {
            this.showNotification("Selecione um arquivo para processar");
            return;
        }
        List itens = this.prospectBiService.getItens(this.selectedFile, Integer.valueOf(3));
        long registros = itens.size();
        if (registros <= 0L) {
            this.showNotification("N\u00e3o h\u00e1 registros com FLAG 3 neste arquivo");
            return;
        }
        Dialog dialog = new Dialog();
        Integer disp = 0;
        disp = processo.equals((Object)ProcessoEnum.OPORTUNIDADE) ? this.oportunidadeService.getLimiteDisponivel(this.getEu().getEstrutura()) : (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO) ? Integer.valueOf(50000) : Integer.valueOf(0));
        Span label = UIUtils.createSmallSpan((String)("Limite disponivel: " + disp + (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO) ? "(limitado a seu saldo)" : "")));
        NumberField quantos = new NumberField("Quantos?");
        quantos.setMax((double)disp.intValue());
        quantos.setMin(1.0);
        TextField nome = new TextField("Nome Campanha");
        TextArea descricao = new TextArea("Informa\u00e7\u00f5es");
        descricao.setHeight("100px");
        ListField tags = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Tags");
        Button btn = UIUtils.createSmallButton((String)(processo.equals((Object)ProcessoEnum.ATIVIDADE) ? "Continuar" : "Criar"), (String)"");
        btn.setDisableOnClick(true);
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            btn.setEnabled(true);
            if (nome.isEmpty() && (processo.equals((Object)ProcessoEnum.ATIVIDADE) || processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO))) {
                this.showNotification("Informe um nome para a campanha");
                return;
            }
            if (descricao.isEmpty() && processo.equals((Object)ProcessoEnum.ATIVIDADE)) {
                this.showNotification("Informe uma descri\u00e7\u00e3o para a atividade");
                return;
            }
            if (itens.size() <= 0 && (quantos.getValue() == null || (Double)quantos.getValue() <= 0.0)) {
                this.showNotification("Selecione alguns itens ou informe a quantidade que deseja selecionar automaticamente");
                return;
            }
            HashSet<String> listaCnpj = new HashSet<String>();
            for (VivoProspectBiItens selectedItem : itens) {
                listaCnpj.add(selectedItem.getCpfCnpj());
            }
            if (processo.equals((Object)ProcessoEnum.OPORTUNIDADE)) {
                this.whatsAppCobrancaDialog.create();
                this.whatsAppCobrancaDialog.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.oportunidadeService.exportacao(listaCnpj, this.getEu(), nome.getValue(), TipoProcessoEnum.CNPJ, Boolean.valueOf(this.whatsAppCobrancaDialog.getValue()));
                        UIUtils.showProcessNotification();
                    }
                });
            } else if (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO)) {
                this.whatsAppCobrancaDialog.create();
                this.registrationDialogWhats = this.whatsAppCobrancaDialog.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.enriquecimentoService.processar(this.getEu(), listaCnpj, nome.getValue(), TipoProcessoEnum.CNPJ, this.whatsAppCobrancaDialog.getValue(), true, false);
                        UIUtils.showProcessNotification();
                    }
                });
            }
            dialog.close();
        });
        FlexBoxLayout dLay = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingS();
        dLay.add(new Component[]{label});
        if (processo.equals((Object)ProcessoEnum.ATIVIDADE)) {
            dLay.add(new Component[]{descricao, tags});
        } else if (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO) || processo.equals((Object)ProcessoEnum.OPORTUNIDADE)) {
            dLay.add(new Component[]{nome});
        }
        dLay.add(new Component[]{btn});
        dialog.add(new Component[]{dLay});
        dialog.open();
    }

    private VerticalContainer createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".csv"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .csv"));
        Button processar = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        processar.setDisableOnClick(true);
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    this.uploadService.upload(this.getEu(), this.mBuffer.getInputStream(), this.nomeArquivo);
                    UIUtils.showProcessNotification();
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
                this.nomeArquivo = "";
                this.mBuffer.clear();
            }
            processar.setEnabled(true);
        });
        VerticalContainer card = new VerticalContainer(new Component[0]);
        card.setShadow(Shadow.S);
        card.add(new Component[]{UIUtils.createHeader((String)"Upload arquivos")});
        card.add(new Component[]{upload, new FooterContainer(new Component[]{processar})});
        return card;
    }

    private GridCrud<VivoProspectBiFile> createGrid() {
        this.crud = new GridCrud(VivoProspectBiFile.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getFileName())).setHeader("Arquivo");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDateTime((LocalDateTime)p.getDataHora()))).setHeader("Data/Hora").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getTotalRegistros().toString())).setHeader("Registros").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatusProcesso().name())).setHeader("Status").setFlexGrow(0).setWidth("210px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaUsuario().getUsuario().getNome())).setHeader("Usu\u00e1rio");
        this.crud.getGrid().addComponentColumn((ValueProvider & Serializable)item -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(item.getUrlFile() != null && !item.getUrlFile().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                String url;
                String string = url = item.getUrlFile() == null ? "" : item.getUrlFile();
                if (item.getUrlFile() == null) {
                    item.setUrlFile("");
                }
                this.dd.open(url, item.getFileName());
            });
            return b;
        }).setHeader("Download");
        this.crud.getGrid().addItemClickListener((ComponentEventListener & Serializable)e -> {
            this.selectedFile = (VivoProspectBiFile)e.getItem();
        });
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.isMaster());
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nomeArquivo"});
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }
}

