/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="fechar-atendimentos", layout=MainLayout.class)
@PageTitle(value="Fechar atendimentos")
@RolesAllowed(value={"ATENDIMENTO_FECHAR_VIEW"})
public class WhatsAppFecharAtendimentosView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppAtendimentoService service;

    @Autowired
    public WhatsAppFecharAtendimentosView(WhatsAppAtendimentoService service) {
        this.service = service;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        FlexBoxLayout main = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingM();
        main.setAlignItems(FlexComponent.Alignment.CENTER);
        Card card = new Card();
        card.setMaxWidth("400px");
        card.setHeader("Fechar Atendimentos");
        card.getContentBox().setAlignItems(FlexComponent.Alignment.BASELINE);
        RadioButtonGroup rbTipo = new RadioButtonGroup();
        rbTipo.setItems((Object[])new String[]{"ID ATENDIMENTO", "NUMERO ATIVIDADE"});
        rbTipo.setValue((Object)"NUMERO ATIVIDADE");
        rbTipo.setVisible(this.isMaster());
        ListField lista = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Lista Atendimentos");
        Button b = UIUtils.createSmallButton((String)"Fechar", (String)"Fechar Atendimentos");
        b.setVisible(this.isMaster());
        b.addClickListener((ComponentEventListener & Serializable)e -> {
            if (lista.getValue().size() <= 0) {
                this.showNotification("Informe pelo menos um atendimento");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Fechamento", "Confirma o fechamento dos atendimentos informados?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                if (((String)rbTipo.getValue()).equals("NUMERO ATIVIDADE")) {
                    this.service.closeByAtividadeNumber(lista.getValue(), this.getEu());
                } else {
                    this.service.closeByAtividadeId(lista.getValue(), this.getEu());
                }
                cd.close();
                lista.clear();
                this.showNotification("Fechamento iniciado com sucesso, ao final voce sera notificado");
            });
        });
        card.setContent(new Component[]{rbTipo, lista});
        card.setFooter(new Component[]{b});
        main.add(new Component[]{card});
        return main;
    }
}

