/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.whatsapp.model.WhatsAppResposta;
import br.com.system.app.features.whatsapp.model.WhatsAppRespostaCategoria;
import br.com.system.app.features.whatsapp.service.WhatsAppRespostaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vdurmont.emoji.EmojiParser;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cadastro-respostas", layout=MainLayout.class)
@PageTitle(value="Cadastro de Respostas")
@RolesAllowed(value={"ATENDIMENTO_RESPOSTA_VIEW"})
public class WhatsAppRespostaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppRespostaService wars;
    private GridCrud<WhatsAppResposta> crud;
    private ComboBox<WhatsAppRespostaCategoria> cbFiltroCategoria;

    @Autowired
    public WhatsAppRespostaView(WhatsAppRespostaService wars) {
        this.wars = wars;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private VerticalContainer createContent() {
        this.removeAll();
        VerticalContainer mainLayout = new VerticalContainer(new Component[0]);
        this.cbFiltroCategoria = new ComboBox("Filtro Categoria");
        this.cbFiltroCategoria.setItemLabelGenerator(WhatsAppRespostaCategoria::getNome);
        this.cbFiltroCategoria.setItems((Collection)this.wars.getCategoria(this.getEstrutura()));
        this.cbFiltroCategoria.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        Button bAdd = UIUtils.createSmallButton((String)"Adicionar", (VaadinIcon)VaadinIcon.PLUS);
        bAdd.addClickListener((ComponentEventListener & Serializable)e -> this.form(new WhatsAppResposta()));
        Button bEdit = UIUtils.createSmallButton((String)"Editar", (VaadinIcon)VaadinIcon.PENCIL);
        bEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().isEmpty()) {
                this.showNotification("Selecione uma resposta para editar");
                return;
            }
            WhatsAppResposta r = (WhatsAppResposta)this.crud.getGrid().getSelectedItems().iterator().next();
            this.form(r);
        });
        this.crud = new GridCrud(WhatsAppResposta.class);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getWhatsappRespostaCategoria().getNome()))).setHeader("Categoria").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)EmojiParser.parseToUnicode((String)p.getResposta())))).setHeader("Repostas Prontas").setFlexGrow(0).setWidth("500px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getOrdem().toString())).setHeader("Ordem");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{""});
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("ATENDIMENTO_RESPOSTA_SAVE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        mainLayout.setHeight("100%");
        this.crud.setHeight("100%");
        mainLayout.add(new Component[]{new HorizontalContainer(new Component[]{bAdd, bEdit, this.cbFiltroCategoria}), this.crud});
        return mainLayout;
    }

    private void form(WhatsAppResposta r) {
        Dialog dForm = new Dialog();
        dForm.setWidth("600px");
        dForm.setHeight("100%");
        TextArea ta = new TextArea("Resposta");
        ta.setHeight("200px");
        ta.setWidth("100%");
        ta.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> ta.setValue(EmojiParser.parseToUnicode((String)ta.getValue())));
        if (r.getResposta() != null) {
            ta.setValue(r.getResposta());
        }
        NumberField ordem = new NumberField("Ordem");
        ordem.setValue((Number)0.0);
        ordem.setStep(1.0);
        ordem.setMin(0.0);
        ordem.setMax(999.0);
        if (r.getOrdem() != null) {
            ordem.setValue((Number)r.getOrdem().doubleValue());
        }
        ComboBox cbCategoria = new ComboBox("Categoria", (Collection)this.wars.getCategoria(this.getEstrutura()));
        cbCategoria.setItemLabelGenerator(WhatsAppRespostaCategoria::getNome);
        cbCategoria.setWidth("200px");
        if (r.getWhatsappRespostaCategoria() != null) {
            cbCategoria.setValue((Object)r.getWhatsappRespostaCategoria());
        }
        Button bFechar = UIUtils.createSmallButton((String)"Fechar");
        bFechar.addClickListener((ComponentEventListener & Serializable)e -> dForm.close());
        Button bSalvar = UIUtils.createSmallButton((String)"Salvar");
        bSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbCategoria.getValue() == null) {
                this.showNotification("Selecione uma categoria");
                return;
            }
            if (ta.getValue() == null || ta.getValue().isEmpty()) {
                this.showNotification("Informe uma resposta");
                return;
            }
            if (ordem.getValue() == null || (Double)ordem.getValue() < 0.0) {
                this.showNotification("Informe uma ordem");
                return;
            }
            r.setEstrutura(this.getEstrutura());
            r.setOrdem(Integer.valueOf(((Double)ordem.getValue()).intValue()));
            r.setResposta(EmojiParser.parseToHtmlDecimal((String)ta.getValue()));
            r.setWhatsappRespostaCategoria((WhatsAppRespostaCategoria)cbCategoria.getValue());
            this.wars.save(r);
            dForm.close();
            this.crud.refreshGrid();
        });
        dForm.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"Respostas"), cbCategoria, ta, ordem, new FooterContainer(new Component[]{bFechar, bSalvar})})});
        dForm.open();
    }
}

