/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import com.vaadin.flow.component.html.Image;

public class WhatsStatusImage
extends Image {
    private static final long serialVersionUID = 1L;
    private final String imgSent = "images/whats_check_simples.png";
    private final String imgDelivered = "images/whats_double_check_cinza.png";
    private final String imgRead = "images/whats_double_check_azul.png";
    private final String imgClock = "images/clock-blue.png";

    public WhatsStatusImage(WhatsAppStatusEnum statusMsg) {
        this.setStatus(statusMsg, null);
    }

    public WhatsStatusImage(WhatsAppStatusEnum statusMsg, WhatsAppMensagemTipoEnum tipo) {
        this.setStatus(statusMsg, tipo);
    }

    private void setStatus(WhatsAppStatusEnum statusMsg, WhatsAppMensagemTipoEnum tipo) {
        this.setWidth("20px");
        this.setHeight("20px");
        if (tipo != null && tipo.equals((Object)WhatsAppMensagemTipoEnum.RECEBIDA)) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        if (statusMsg == null) {
            this.setSrc("images/clock-blue.png");
            this.setAlt("Aguardando");
            this.setTitle("Aguardando");
        } else if (statusMsg.equals((Object)WhatsAppStatusEnum.RECEBIDA)) {
            this.setSrc("images/whats_double_check_cinza.png");
            this.setAlt("Entregue");
            this.setTitle("Entregue");
        } else if (statusMsg.equals((Object)WhatsAppStatusEnum.LIDA)) {
            this.setSrc("images/whats_double_check_azul.png");
            this.setAlt("Lida");
            this.setTitle("Lida");
        } else {
            this.setSrc("images/whats_check_simples.png");
            this.setAlt("Enviada");
            this.setTitle("Enviada");
        }
    }
}

