/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppSetores;
import br.com.system.app.features.whatsapp.repository.WhatsAppSetoresRepository;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppSetoresService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppSetoresRepository repository;
    @Autowired
    private WhatsAppSendService whatsAppSendService;

    public WhatsAppSetores getByEstruturaAndNome(Estrutura e, String nome) {
        return this.repository.findFirstByEstruturaAndNome(e, nome);
    }

    public WhatsAppSetores getByEstruturaAndPosicao(Estrutura e, Integer posicao) {
        return this.repository.findFirstByEstruturaAndPosicao(e, posicao);
    }

    public List<WhatsAppSetores> getByEstrutura(Estrutura e) {
        return this.repository.findByEstruturaAndAtivoOrderByPosicao(e, Boolean.TRUE);
    }

    public List<WhatsAppSetores> getByEstrutura(Estrutura e, Pageable pageable) {
        return this.repository.findByEstruturaOrderByPosicao(e, pageable);
    }

    public long countByEstrutura(Estrutura e) {
        return this.repository.countByEstrutura(e);
    }

    public WhatsAppSetores save(WhatsAppSetores ws) {
        return (WhatsAppSetores)this.repository.save((Object)ws);
    }

    public void sendSetor(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master, String titulo) {
        this.sendSetor(w, wa, master, titulo, "Para qual setor deseja atendimento?\n");
    }

    public void sendSetor(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master, String titulo, String msgInicial) {
        List setores = this.getByEstrutura(master.getEstrutura());
        ArrayList<String> buttons = new ArrayList<String>();
        if (setores.size() > 3) {
            Object msg = msgInicial;
            for (WhatsAppSetores ws : setores) {
                msg = (String)msg + ws.getPosicao() + " - " + ws.getNome() + "\n";
            }
            this.whatsAppSendService.sendMessageText(wa, master, (String)msg);
        } else {
            for (WhatsAppSetores ws : setores) {
                buttons.add(ws.getNome());
            }
            this.whatsAppSendService.sendButton(wa, master, titulo, "", buttons);
        }
        w.setEtapa(WhatsAppEtapaEnum.ESCOLHA_TIPO);
        wa.setEtapa(WhatsAppEtapaEnum.ESCOLHA_TIPO);
    }

    public WhatsAppSetores checkSetor(Estrutura e, String resposta) {
        try {
            WhatsAppSetores setor = this.getByEstruturaAndNome(e, resposta);
            if (setor != null) {
                return setor;
            }
            return this.getByEstruturaAndPosicao(e, Integer.valueOf(resposta));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void deleteByEstrutura(Estrutura e) {
        this.repository.deleteByEstrutura(e);
    }
}

