/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import java.io.Serializable;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppStatusService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;

    public WhatsAppAtendimento controlar(JSONObject json) {
        try {
            if (!json.has("integrationId") || !json.has("status")) {
                return null;
            }
            WhatsAppConta conta = this.whatsappContaService.getContaByMoorseId(json.getString("integrationId"));
            WhatsApp w = this.whatsAppService.getByNumeroAndConta(json.getString("to"), conta);
            if (w == null) {
                return null;
            }
            WhatsAppMensagem wm = this.getMsg(json);
            if (wm == null) {
                return null;
            }
            WhatsAppStatusEnum status = WhatsAppStatusEnum.valueOf((String)json.getString("status"));
            if (status.equals((Object)WhatsAppStatusEnum.ENVIADA)) {
                wm.setDataHoraEnvio(DateTimeUtil.timeStampToDate((String)json.getString("sendDate")));
            } else if (status.equals((Object)WhatsAppStatusEnum.RECEBIDA)) {
                wm.setDataHoraRecebimento(DateTimeUtil.timeStampToDate((String)json.getString("receivedDate")));
                SleepUtil.inMiliseconds((Integer)500);
            } else if (status.equals((Object)WhatsAppStatusEnum.LIDA)) {
                wm.setDataHoraLeitura(DateTimeUtil.timeStampToDate((String)json.getString("readDate")));
                SleepUtil.inSeconds((Integer)1);
            } else {
                return null;
            }
            this.whatsAppControleService.gravarAlteracao(wm, status);
            wm.setStatus(status);
            return this.whatsAppMensagemService.saveMessage(wm).getWhatsappAtendimento();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(WhatsAppStatusService.class).error("WHATSAPP ERRO, recebi notificacao mas deu erro " + e.getMessage());
            return null;
        }
    }

    private WhatsAppMensagem getMsg(JSONObject json) {
        if (!json.has("id")) {
            return null;
        }
        for (int retry = 0; retry < 5; ++retry) {
            WhatsAppMensagem msg = this.whatsAppMensagemService.getByMessageId(json.getString("id"));
            if (msg != null) {
                return msg;
            }
            SleepUtil.inSeconds((Integer)2);
        }
        return null;
    }
}

