/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons;

import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.strings.StringTransformer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.text.MaskFormatter;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StringUtil {
    private String filtering;
    public static final Charset ISO_8859_15 = Charset.forName("ISO-8859-15");

    public static Boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private StringUtil() {
    }

    public static String getString(Object obj) {
        try {
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getCurrency(BigDecimal valor) {
        try {
            return CurrencyUtil.toCurrency((BigDecimal)valor);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getDomainName(String url) {
        if (url == null || ((String)url).isEmpty()) {
            return "";
        }
        try {
            URL uri;
            String domain;
            if (!((String)url).startsWith("http")) {
                url = "http://" + (String)url;
            }
            if ((domain = (uri = new URL((String)url)).getHost()).startsWith("www")) {
                return domain.substring(domain.indexOf(".") + 1);
            }
            return domain;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static String getProtocolFromUrl(String url) {
        if (url == null || ((String)url).isEmpty()) {
            return "";
        }
        try {
            if (!((String)url).startsWith("http")) {
                url = "http://" + (String)url;
            }
            URL u = new URL((String)url);
            return u.getProtocol();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static StringUtil set(String filteringString) {
        if (filteringString == null) {
            throw new IllegalStateException("filteringString n\u00e3o pode ser nula.");
        }
        StringUtil stringUtil = new StringUtil();
        stringUtil.filtering = filteringString;
        return stringUtil;
    }

    public boolean anyMatch(List<?> list) {
        if (list == null || this.filtering == null) {
            return false;
        }
        for (Object value : list) {
            if (!StringUtil.containsIgnoreCase((String)this.filtering, (String)value.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean fullMatch(List<?> list) {
        if (this.filtering == null || StringUtil.isBlank(list)) {
            return false;
        }
        for (Object listVal : list) {
            if (StringUtil.containsIgnoreCase((String)this.filtering, (String)listVal.toString())) continue;
            return false;
        }
        return true;
    }

    public StringUtil normalize() {
        this.filtering = StringUtil.normalize((String)this.filtering);
        return this;
    }

    public StringUtil normalizeWhitespaces() {
        this.filtering = StringUtil.normalizeWhitespaces((String)this.filtering);
        return this;
    }

    public static int toInt(String str) {
        return StringUtil.toInteger((String)str);
    }

    public static Integer toInteger(String str) {
        if (str == null) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Long toLong(String str) {
        if (str == null) {
            return 0L;
        }
        str = StringUtil.numbersOnly((String)str);
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static Double toDouble(String str) {
        if (str == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static BigDecimal toBigDecimal(String str) {
        if (str == null) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static String numbersOnly(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("[^0-9]+", "");
    }

    public static boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        String str = String.valueOf(obj);
        return StringUtil.removeWhitespaces((String)str).isEmpty();
    }

    public static boolean hasAnyBlank(Object ... objs) {
        if (objs == null) {
            return true;
        }
        for (Object obj : objs) {
            if (!StringUtil.isBlank((Object)obj)) continue;
            return true;
        }
        return false;
    }

    public static String clearArea(String area, String from, String to) {
        String clearRgx = StringUtil.escapeSpecialChars((String)from) + "[\\s\\S]+" + StringUtil.escapeSpecialChars((String)to);
        return area.replaceAll(clearRgx, "");
    }

    public static String removeWhitelines(String str) {
        return str.replaceAll("(?m)^\\s+", "");
    }

    public static String removeNonLetters(String str) {
        return str.replaceAll("[^\\pL]+", "");
    }

    public static String removeNonNumber(String str) {
        return str.replaceAll("[^\\pN]+", "");
    }

    public static String removeWhitespaces(String str) {
        return str.replaceAll(" ", "");
    }

    public static String removeSpecialChars(String str) {
        return str.replaceAll("[^\\pL\\pN\\pM ]", "");
    }

    public static String removeLineBreaks(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        str = str.replaceAll("\n", "");
        str = str.replaceAll("\r", "");
        return str;
    }

    public static boolean isNumber(String str) {
        return str.matches("([0-9]+)");
    }

    public static boolean containsIgnoreCase(String source, String value) {
        int length = value.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(value.charAt(0));
        char firstUp = Character.toUpperCase(value.charAt(0));
        for (int i = source.length() - length; i >= 0; --i) {
            char ch = source.charAt(i);
            if (ch != firstLo && ch != firstUp || !source.regionMatches(true, i, value, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String normalize(String text) {
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        text = text.replace("\n\n", "\n");
        text = text.replace("  ", " ").trim();
        text = text.replace("\"", "");
        text = text.replace("'", "");
        return Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String normalizeWhitespaces(String text) {
        return text.replaceAll("\\s+", " ");
    }

    public static String crop(String toCrop, String from, String to) {
        int cropBgnIdx = toCrop.indexOf(from);
        if (cropBgnIdx == -1) {
            return "";
        }
        int cropEndIdx = (toCrop = toCrop.substring(cropBgnIdx + from.length())).indexOf(to);
        if (cropEndIdx == -1) {
            return "";
        }
        return toCrop.substring(0, cropEndIdx);
    }

    public static String cut(String toCut, String from, String to) {
        return StringUtil.cut((String)toCut, (String)from, (String)to, (boolean)false);
    }

    public static String cutAtLastEndOccurrence(String toCut, String from, String to) {
        return StringUtil.cut((String)toCut, (String)from, (String)to, (boolean)true);
    }

    public static String cut(String toCut, String what) {
        return toCut.replaceAll(what, "");
    }

    public static String cut(String toCut, String from, String to, boolean atLastEndOcurrence) {
        String middle = StringUtil.crop((String)toCut, (String)from, (String)to);
        return middle.isEmpty() ? "" : from + middle + to;
    }

    public static String replaceFirst(String value, String from, String to, String replacement) {
        return StringUtil.replaceAll((String)value, (String)from, (String)to, (String)replacement, (int)1);
    }

    public static String replaceAll(String value, String from, String to, String replacement) {
        return StringUtil.replaceAll((String)value, (String)from, (String)to, (String)replacement, (int)Integer.MAX_VALUE);
    }

    public static String replaceAll(String value, String from, String to, String replacement, int timesToReplace) {
        int iofB;
        int iofA;
        if (ValidationUtil.hasAnyBlank((Object[])new Object[]{value, from, to})) {
            return value;
        }
        StringBuilder replacing = new StringBuilder(value);
        int iofLastRpl = 0;
        for (int timesReplaced = 0; timesReplaced < timesToReplace && (iofA = replacing.indexOf(from, iofLastRpl)) != -1 && (iofB = replacing.indexOf(to, iofA)) != -1; ++timesReplaced) {
            replacing.replace(iofA, iofB + to.length(), replacement);
            iofLastRpl = iofA;
        }
        return replacing.toString();
    }

    public static String replaceLast(String value, String toReplace, String replacement) {
        if (StringUtil.isBlank((Object)value) || StringUtil.isBlank((Object)toReplace)) {
            return "";
        }
        int lastIndex = value.lastIndexOf(toReplace);
        if (lastIndex >= 0) {
            StringBuilder sb = new StringBuilder(value);
            sb.replace(lastIndex, lastIndex + toReplace.length(), replacement);
            value = sb.toString();
            sb = null;
        }
        return value;
    }

    public static boolean startsWith(String regex, String value) {
        if (StringUtil.hasAnyBlank((Object[])new Object[]{regex, value})) {
            return false;
        }
        regex = String.format("^%s{1}[\\s\\S]+", regex);
        return value.matches(regex);
    }

    public static boolean endsWith(String regex, String value) {
        if (StringUtil.hasAnyBlank((Object[])new Object[]{regex, value})) {
            return false;
        }
        regex = String.format("[\\s\\S]+%s$", regex);
        return value.matches(regex);
    }

    public static String escapeSpecialChars(String value) {
        Pattern p = Pattern.compile("[^\\pL\\pN\\pM ]");
        Matcher m = p.matcher(value);
        return m.replaceAll("\\\\$0");
    }

    public static String removeBars(String text) {
        return text.replaceAll("\\\\", "").replaceAll("\\/", "");
    }

    public static String removeLastChar(String text) {
        return text == null ? "" : text.replaceAll(".$", "");
    }

    public static String complement(String conjunctA, String conjunctB) {
        if (StringUtil.containsIgnoreCase((String)conjunctA, (String)conjunctB)) {
            return conjunctA.replaceAll(conjunctB, "");
        }
        return "";
    }

    public static String removeLinesOf(String refValue, String content) {
        String rgx = ".*" + refValue + ".*";
        return content.replaceAll(rgx, "");
    }

    public static String getFirstTerminalString(String value, String from, String ... terminals) {
        if (ValidationUtil.hasAnyNull((Object[])new Object[]{value, terminals}) || ValidationUtil.isNull((Object)from)) {
            return "";
        }
        int fromIdx = value.indexOf(from);
        if (fromIdx == -1) {
            return "";
        }
        String earlierStr = "";
        int earlierIdx = Integer.MAX_VALUE;
        for (String terminal : terminals) {
            int endingIdx = value.indexOf(terminal, fromIdx);
            if (endingIdx >= earlierIdx || endingIdx == -1) continue;
            earlierIdx = endingIdx;
            earlierStr = terminal;
        }
        return earlierStr;
    }

    public static String underscoreToCamelcase(String target) {
        return StringTransformer.underscoreToCamelcase((String)target);
    }

    public static boolean isFullUppercase(String str) {
        return str.matches("\\p{Lu}+");
    }

    public static String formataCpfCnpj(String cpfCnpj) {
        try {
            String patern;
            switch (cpfCnpj.length()) {
                case 14: {
                    patern = "##.###.###/####-##";
                    break;
                }
                case 11: {
                    patern = "###.###.###-##";
                    break;
                }
                default: {
                    return cpfCnpj;
                }
            }
            MaskFormatter mask = new MaskFormatter(patern);
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(cpfCnpj);
        }
        catch (ParseException pe) {
            return cpfCnpj;
        }
    }

    public static String zeroLeft(String value, int size) {
        while (((String)value).length() < size) {
            value = "0" + (String)value;
        }
        return value;
    }

    public static String removeZeroLeft(String value) {
        while (value.startsWith("0") && value.length() > 1) {
            value = value.substring(1);
        }
        return value;
    }

    public static String removeAllHtmlTags(String html) {
        return Jsoup.parse((String)html).text();
    }

    public static String normalizeCpf(String cpf) {
        String cpf11 = StringUtil.zeroLeft((String)cpf, (int)11);
        if (ValidationUtil.isValidCPF((String)cpf11)) {
            return cpf11;
        }
        return "";
    }

    public static String normalizeCnpj(String cnpj) {
        String cnpj14;
        if ((cnpj = StringUtil.numbersOnly((String)cnpj)).length() > 14) {
            cnpj = cnpj.substring(cnpj.length() - 14);
        }
        if (ValidationUtil.isValidCNPJ((String)(cnpj14 = StringUtil.zeroLeft((String)cnpj, (int)14)))) {
            return cnpj14;
        }
        return "";
    }

    public static String normalizeCpfCnpj(String cnpj) {
        String cnpj14;
        if ((cnpj = StringUtil.numbersOnly((String)cnpj)).length() > 14) {
            cnpj = cnpj.substring(cnpj.length() - 14);
        }
        if (ValidationUtil.isValidCNPJ((String)(cnpj14 = StringUtil.zeroLeft((String)cnpj, (int)14)))) {
            return cnpj14;
        }
        String cpf11 = StringUtil.zeroLeft((String)cnpj, (int)11);
        if (ValidationUtil.isValidCPF((String)cpf11)) {
            return cpf11;
        }
        return "";
    }

    public static String removeWordsLessThan(String value, int minLength) {
        List<String> sentences = Arrays.asList(value.split("\\s+"));
        return sentences.stream().filter(sentence -> sentence.trim().length() > minLength).collect(Collectors.joining(" "));
    }

    public static String removeOccurrences(String value, List<String> occurrences) {
        List<String> sentences = Arrays.asList(value.split("\\s+"));
        return sentences.stream().filter(sentence -> !occurrences.contains(sentence)).collect(Collectors.joining(" "));
    }

    public static String normalizeTags(String tags) {
        Object retorno = "";
        if (tags == null || tags.isBlank()) {
            return retorno;
        }
        String[] arr = tags.split(",");
        for (int i = 0; i < arr.length; ++i) {
            Object s = arr[i].replace(".", "").replace("-", "").replace("%", "").replace("(", "").replace(")", "").replace("/", "").replace("  ", " ").replace(" ", "_").trim();
            s = StringUtil.normalize((String)s);
            if (((String)(s = StringUtil.toCamelCase((String)s))).isBlank()) continue;
            if (!((String)s).startsWith("#")) {
                s = "#" + (String)s;
            }
            retorno = (String)retorno + (String)s;
            if (i < arr.length - 1) {
                retorno = (String)retorno + ",";
            }
            s = null;
            tags = null;
        }
        return retorno;
    }

    public static String toCamelCase(String s) {
        if (!(s = s.replaceAll(" ", "_")).contains("_")) {
            return s;
        }
        String[] parts = s.split("_");
        Object camelCaseString = "";
        for (String part : parts) {
            if (part.isEmpty()) continue;
            camelCaseString = (String)camelCaseString + StringUtil.toProperCase((String)part);
        }
        parts = null;
        s = null;
        return camelCaseString;
    }

    static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String htmlTableToCsv(String htmlTable) {
        StringBuilder s = new StringBuilder();
        Document doc = Jsoup.parseBodyFragment((String)htmlTable);
        Elements rows = doc.getElementsByTag("tr");
        for (Element row : rows) {
            Elements cells = row.getElementsByTag("td");
            for (Element cell : cells) {
                s.append(cell.text().concat(";"));
            }
            s.append("\n");
            cells = null;
        }
        doc = null;
        rows = null;
        return s.toString();
    }

    public static String[] getCols(String linha, String separador) {
        while (((String)linha).contains("\"")) {
            int pAspas = ((String)linha).indexOf("\"");
            int sAspas = ((String)linha).indexOf("\"", pAspas + 1) + 1;
            String middle = ((String)linha).substring(pAspas, sAspas);
            middle = middle.replace(separador, "").replace("\"", "");
            linha = ((String)linha).substring(0, pAspas) + middle + ((String)linha).substring(sAspas);
        }
        return ((String)linha).split(separador);
    }

    public static String formatString(String value, String pattern) {
        try {
            MaskFormatter mf = new MaskFormatter(pattern);
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(value);
        }
        catch (ParseException ex) {
            return value;
        }
    }

    public static String convertCamelCaseToSnakeCase(String input) {
        return input.replaceAll("([A-Z])(?=[A-Z])", "$1_").replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String collectionToMapString(List<String> lista) {
        return lista.stream().map(f -> "\"" + f + "\"").collect(Collectors.joining(",", "(", ")"));
    }

    public static String collectionToMapString(Set<String> lista) {
        return lista.stream().map(f -> "\"" + f + "\"").collect(Collectors.joining(",", "(", ")"));
    }

    public static String collectionToMapLong(List<Long> lista) {
        return lista.stream().map(f -> "" + f).collect(Collectors.joining(",", "(", ")"));
    }

    public static String collectionToMapLong(Set<Long> lista) {
        return lista.stream().map(f -> "" + f).collect(Collectors.joining(",", "(", ")"));
    }

    public static CharSequence collectionToMapInteger(List<Integer> lista) {
        return lista.stream().map(f -> "" + f).collect(Collectors.joining(",", "(", ")"));
    }

    public static CharSequence collectionToMapInteger(Set<Integer> lista) {
        return lista.stream().map(f -> "" + f).collect(Collectors.joining(",", "(", ")"));
    }

    public static boolean hasExcessiveOccurrences(String input, int maxOccurrences) {
        if (input == null || input.isEmpty() || maxOccurrences < 1) {
            return false;
        }
        char prevChar = input.charAt(0);
        int count = 0;
        for (char c : input.toCharArray()) {
            if (c == prevChar) {
                ++count;
            } else {
                count = 1;
                prevChar = c;
            }
            if (count <= maxOccurrences) continue;
            return true;
        }
        return false;
    }

    public static String normalizeToId(String valor) {
        valor = StringUtil.normalize((String)valor);
        valor = StringUtil.removeNonLettersAndNumbersWithSpace((String)valor);
        valor = StringUtil.spaceToUnderline((String)valor);
        return valor;
    }

    public static String removeNonLettersAndNumbersWithSpace(String valor) {
        return valor.replaceAll("[^A-Za-z0-9 ]", "");
    }

    public static String spaceToUnderline(String valor) {
        return valor.replace(" ", "_");
    }

    public static String removeItemFromStringList(String list, String itemRemove) {
        return StringUtil.removeItemFromStringList((String)list, (String)itemRemove, (String)",");
    }

    public static String removeItemFromStringList(String list, String itemRemove, String delimiter) {
        String[] arr;
        ArrayList<String> retorno = new ArrayList<String>();
        for (String s : arr = list.split(delimiter)) {
            if (s.equals(itemRemove)) continue;
            retorno.add(s);
        }
        return StringUtils.join(retorno, (String)",");
    }
}

