/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.ValueProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class GridX<T>
extends Grid<T>
implements SecurityContext {
    private static final long serialVersionUID = 1L;

    public GridX() {
        this.init();
    }

    public GridX(Collection<T> items) {
        super(items);
        this.init();
    }

    public GridX(Class<T> beanType) {
        super(beanType);
        this.init();
    }

    public Grid.Column<T> addButton(ComponentRenderer<?, T> componentRenderer, String header) {
        return this.addColumn(componentRenderer).setWidth("120px").setFlexGrow(0).setHeader(header);
    }

    public Grid.Column<T> addButton(ComponentRenderer<?, T> componentRenderer, String header, Integer tamanho) {
        return this.addColumn(componentRenderer).setWidth(tamanho + "px").setFlexGrow(0).setHeader(header);
    }

    public Grid.Column<T> addColumn(ValueProvider<T, ?> valueProvider, String key) {
        return this.addColumn(valueProvider).setFlexGrow(0).setWidth("100px").setHeader(key.toUpperCase()).setSortable(true).setKey(key);
    }

    public Grid.Column<T> addColumn(ValueProvider<T, ?> valueProvider, String key, Integer tamanho) {
        return this.addColumn(valueProvider).setFlexGrow(0).setWidth(tamanho + "px").setHeader(key.toUpperCase()).setSortable(true).setKey(key);
    }

    public Grid.Column<T> addColumn(ValueProvider<T, ?> valueProvider, String key, Integer tamanho, String header) {
        return this.addColumn(valueProvider).setFlexGrow(0).setWidth(tamanho + "px").setHeader(header).setSortable(true).setKey(key);
    }

    private void init() {
        this.setHeight("98%");
        this.setWidth("100%");
        if (!this.isMobileDevice()) {
            this.getStyle().set("align-self", "center");
        }
        this.setColumns(new String[0]);
        this.addThemeVariants(new GridVariant[]{GridVariant.LUMO_WRAP_CELL_CONTENT, GridVariant.LUMO_COMPACT});
    }

    public PageRequest page(Query<?, Void> query) {
        ArrayList<Sort.Order> springSortOrders = new ArrayList<Sort.Order>();
        for (QuerySortOrder so : query.getSortOrders()) {
            String colKey = (String)so.getSorted();
            if (so.getDirection() == SortDirection.ASCENDING) {
                springSortOrders.add(Sort.Order.asc((String)colKey));
                continue;
            }
            springSortOrders.add(Sort.Order.desc((String)colKey));
        }
        return PageRequest.of((int)query.getPage(), (int)query.getPageSize(), (Sort)Sort.by(springSortOrders));
    }

    public Sort getSort() {
        ArrayList<Sort.Order> springSortOrders = new ArrayList<Sort.Order>();
        List sortOrder = this.getSortOrder();
        for (GridSortOrder so : sortOrder) {
            String colKey = so.getSorted().getKey();
            if (so.getDirection() == SortDirection.ASCENDING) {
                springSortOrders.add(Sort.Order.asc((String)colKey));
                continue;
            }
            springSortOrders.add(Sort.Order.desc((String)colKey));
        }
        return Sort.by(springSortOrders);
    }
}

