/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components.containers;

import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;

public class HorizontalContainer
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    private Object dataObject;

    public HorizontalContainer(Component ... components) {
        super(components);
        this.setDefault();
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    private void setDefault() {
        this.addClassNames(new String[]{"text-xs", "p-xs"});
        this.getStyle().set("flex-wrap", "wrap");
        this.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.setSpacing(true);
    }

    public HorizontalContainer setNoWrap() {
        this.getStyle().set("flex-wrap", "no-wrap");
        return this;
    }

    public HorizontalContainer setStartAlign() {
        this.setAlignItems(FlexComponent.Alignment.START);
        return this;
    }

    public HorizontalContainer setTransparent() {
        this.getElement().getStyle().set("background", "transparent");
        return this;
    }

    public HorizontalContainer setHorizontalFull() {
        this.setWidthFull();
        return this;
    }

    public HorizontalContainer setVerticalFull() {
        this.setHeightFull();
        return this;
    }

    public HorizontalContainer setVerticalAlign(FlexComponent.Alignment alignment) {
        this.setAlignItems(alignment);
        return this;
    }

    public HorizontalContainer setHorizontalAlign(FlexComponent.JustifyContentMode alignment) {
        if (alignment == null) {
            this.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        } else {
            this.setJustifyContentMode(alignment);
        }
        return this;
    }

    public HorizontalContainer setShadow(Shadow shadow) {
        UIUtils.setShadow((Shadow)shadow, (Component[])new Component[]{this});
        return this;
    }

    public HorizontalContainer setBackgroundColor(Color color) {
        UIUtils.setBackgroundColor((Color)color, (Component[])new Component[0]);
        return this;
    }

    public HorizontalContainer setPaddingOn() {
        this.setPadding(true);
        return this;
    }

    public HorizontalContainer setPaddingOff() {
        this.setPadding(false);
        return this;
    }

    public HorizontalContainer setSpacingOn() {
        this.setSpacing(true);
        return this;
    }

    public HorizontalContainer setSpacingOff() {
        this.setSpacing(false);
        return this;
    }
}

