/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.bots.service;

import br.com.system.app.features.analisefatura.model.BotTypeEnum;
import br.com.system.app.features.analisefatura.service.AnaliseFaturaBot;
import br.com.system.app.features.bots.model.BotProcess;
import br.com.system.app.features.bots.service.BotService;
import br.com.system.app.features.marketing.service.MarketingBot;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.commons.SleepUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BotStartThreads
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MarketingBot marketingBot;
    @Autowired
    private AnaliseFaturaBot analiseFaturaBot;
    @Autowired
    private BotService botService;
    @Autowired
    private WhatsAppContaService whatsappContaService;

    @Async(value="asyncDefault")
    public void start(BotTypeEnum type, int qtos, Long id) {
        Thread.currentThread().setName("asyncDefault-bot-start-threads");
        if (id == null || id <= 0L) {
            this.botService.deleteByProcessType(type);
            this.botService.waitProcess(type);
            if (type.equals((Object)BotTypeEnum.BOTFAT)) {
                this.analiseFaturaBot.breakProcess();
            }
        }
        LocalDateTime startTime = LocalDateTime.now();
        String processName = "asyncDefault-" + type.name() + startTime.getHour() + startTime.getMinute() + startTime.getSecond();
        this.botService.save(new BotProcess(type, processName));
        if (type.equals((Object)BotTypeEnum.BOTFAT)) {
            this.analiseFaturaBot.start(processName, id);
        } else if (type.equals((Object)BotTypeEnum.BOTMARKETING)) {
            this.marketingBot.start(processName, this.whatsappContaService.getContaMarketing(Boolean.FALSE));
        }
        SleepUtil.inSeconds((Integer)20);
        startTime = null;
        processName = null;
    }
}

