/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.TelefoneField;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.portabilidade.model.Portabilidade;
import br.com.system.app.features.portabilidade.service.PortabilidadeConsultaService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.vaadin.lineawesome.LineAwesomeIcon;

public class ClienteContatoComp
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    public final TelefoneService telefoneService;
    private final PortabilidadeConsultaService portabilidadeService;
    private List<ClienteContato> lista;
    private Cliente cliente;
    private EstruturaUsuario eu;
    private Long atividadeId;
    private ClienteContatoVerficadoEnum verificado;
    private VerticalContainer container;
    private ComboBox<ClienteContatoVerficadoEnum> cbVerificado;
    private TelefoneField tel;
    private TextField val;

    public ClienteContatoComp(TelefoneService telefoneService, PortabilidadeConsultaService portabilidadeService) {
        this.telefoneService = telefoneService;
        this.portabilidadeService = portabilidadeService;
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public VerticalLayout create(EstruturaUsuario eu, Cliente cliente, Long atividadeId) {
        return this.create(eu, cliente, atividadeId, null);
    }

    public VerticalLayout create(EstruturaUsuario eu, Cliente cliente, Long atividadeId, ClienteContatoVerficadoEnum verificado) {
        this.cliente = cliente;
        this.eu = eu;
        this.verificado = verificado;
        this.atividadeId = atividadeId;
        this.container = new VerticalContainer(new Component[0]);
        this.container.setWidth("100%");
        if (cliente != null) {
            this.lista = new ArrayList(cliente.getClienteContato());
            if (this.lista == null) {
                this.lista = new ArrayList();
            }
        } else {
            this.lista = new ArrayList();
        }
        return this.create();
    }

    public String validar() {
        StringBuilder s = new StringBuilder();
        if (this.lista == null) {
            return s.toString();
        }
        for (ClienteContato cc : this.lista) {
            if (cc.getTipo() != null && cc.getTipo().equals((Object)TipoContatoEnum.EMAIL)) {
                if (ValidationUtil.isValidEmail((String)cc.getValor())) continue;
                s.append("E-mail ").append(cc.getValor()).append(" Inv\u00e1lido\n");
                continue;
            }
            if (cc.getTipo() == null || !cc.getTipo().equals((Object)TipoContatoEnum.TELEFONE) || TelefoneUtil.isValid((String)cc.getValor())) continue;
            s.append("Telefone ").append(cc.getValor()).append(" Inv\u00e1lido\n");
        }
        return s.toString();
    }

    public List<ClienteContato> getValue() {
        return this.lista;
    }

    private VerticalLayout create() {
        VerticalLayout lay = new VerticalLayout();
        lay.setEnabled(this.cliente != null && this.cliente.getId() != null);
        lay.add(new Component[]{new Hr()});
        lay.add(new Component[]{UIUtils.createHeader((String)"Contatos do Cliente")});
        Button btnPlus = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar contato");
        btnPlus.addClickListener((ComponentEventListener & Serializable)e -> {
            ClienteContato clienteContato = new ClienteContato();
            clienteContato.setCliente(this.cliente);
            this.createItem(clienteContato);
            this.lista.add(clienteContato);
        });
        this.cbVerificado = new ComboBox("Filtro Valida\u00e7\u00e3o");
        this.cbVerificado.setWidth("200px");
        this.cbVerificado.setItems((Object[])ClienteContatoVerficadoEnum.values());
        this.cbVerificado.setItemLabelGenerator(Enum::name);
        if (this.verificado != null) {
            this.cbVerificado.setValue((Object)this.verificado);
        }
        this.cbVerificado.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoar());
        lay.add(new Component[]{new HorizontalContainer(new Component[]{this.cbVerificado, btnPlus, UIUtils.createHeader((String)"Adicionar Contato")})});
        lay.add(new Component[]{new Span("Relev\u00e2ncia de 0 a 6 quanto maior mais relev\u00e2nte")});
        lay.add(new Component[]{this.container});
        this.povoar();
        return lay;
    }

    private void povoar() {
        this.container.removeAll();
        Collections.sort(this.lista, new /* Unavailable Anonymous Inner Class!! */);
        for (ClienteContato cc : this.lista) {
            if (this.cbVerificado.getValue() != null && !cc.getVerificado().equals(this.cbVerificado.getValue()) || cc.getValor() == null || cc.getValor().isEmpty()) continue;
            this.createItem(cc);
        }
    }

    private void createItem(ClienteContato cc) {
        Button btnTrash = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir contato");
        btnTrash.setVisible(this.hasPermission("CLIENTE_EXCLUIR_CONTATOS"));
        HorizontalContainer item = this.item(cc, btnTrash);
        this.container.add(new Component[]{item});
        btnTrash.addClickListener((ComponentEventListener & Serializable)e -> {
            this.lista.remove(cc);
            this.container.remove(new Component[]{item});
        });
    }

    private HorizontalContainer item(ClienteContato cc, Button btnTrash) {
        if (cc == null) {
            throw new BusinessException("Erro cc null");
        }
        if (cc.getNivelRelevancia() == null) {
            cc.setNivelRelevancia(Integer.valueOf(0));
        }
        HorizontalContainer h = new HorizontalContainer(new Component[]{btnTrash});
        ComboBox cb = new ComboBox("Tipo", (Object[])TipoContatoEnum.values());
        cb.setWidth("120px");
        cb.setValue((Object)cc.getTipo());
        ComboBox cbVerItem = new ComboBox("Valida\u00e7\u00e3o", (Object[])ClienteContatoVerficadoEnum.values());
        boolean bloqueioNaoperturbe = false;
        cbVerItem.setWidth("220px");
        if (cc.getVerificado() != null) {
            cbVerItem.setValue((Object)cc.getVerificado());
            if (cc.getVerificado().equals((Object)ClienteContatoVerficadoEnum.NAO_PERTURBE)) {
                cbVerItem.setEnabled(false);
                bloqueioNaoperturbe = true;
            }
        }
        cbVerItem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> cc.setVerificado((ClienteContatoVerficadoEnum)cbVerItem.getValue()));
        h.add(new Component[]{cb});
        if (cc.getTipo() != null && cc.getTipo().equals((Object)TipoContatoEnum.TELEFONE)) {
            this.tel = new TelefoneField(Boolean.valueOf(bloqueioNaoperturbe), Boolean.valueOf(this.hasPermission("IGNORAR_NAO_PERTURBE")), this.eu, this.telefoneService, "Telefone", cc.getValor() == null ? "" : cc.getValor(), Boolean.valueOf(false), "", this.cliente.getCpfCnpj(), this.atividadeId);
            this.tel.setWidth("130px");
            this.tel.getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                this.tel.mostraWhats();
                for (ClienteContato c : this.lista) {
                    if (c.getTipo() == null || !c.getTipo().equals(cb.getValue()) || c.getValor() == null || !c.getValor().equals(this.tel.getValue())) continue;
                    UIUtils.showNotification((String)"Esse contato j\u00e1 existe");
                    this.tel.setValue("");
                    break;
                }
                cc.setValor(this.tel.getValue());
            });
            h.add(new Component[]{this.tel});
        } else {
            this.val = new TextField(cc.getTipo() != null && cc.getTipo().equals((Object)TipoContatoEnum.EMAIL) ? "E-mail" : "Valor");
            this.val.setWidth("190px");
            this.val.setValue(cc.getValor() == null ? "" : cc.getValor());
            this.val.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                for (ClienteContato c : this.lista) {
                    if (c.getTipo() == null || !c.getTipo().equals(cb.getValue()) || c.getValor() == null || !c.getValor().equals(this.val.getValue())) continue;
                    UIUtils.showNotification((String)"Esse contato j\u00e1 existe");
                    this.val.setValue("");
                    break;
                }
                cc.setValor(this.val.getValue());
            });
            h.add(new Component[]{this.val});
        }
        h.add(new Component[]{cbVerItem});
        if (cc.getTipo() != null && cc.getTipo().equals((Object)TipoContatoEnum.TELEFONE)) {
            TextField txtNivel = new TextField("Rel");
            txtNivel.setWidth("40px");
            txtNivel.setValue(cc.getNivelRelevancia().toString());
            txtNivel.setReadOnly(true);
            Span txtDados = new Span();
            txtDados.setVisible(false);
            Button btnPort = UIUtils.createSmallButton((LineAwesomeIcon)LineAwesomeIcon.SATELLITE_DISH_SOLID, (String)"Operadora e Portabilidade");
            btnPort.addClickListener((ComponentEventListener & Serializable)e -> this.portabilidade(txtDados, cc.getValor()));
            h.add(new Component[]{txtNivel, btnPort, txtDados});
        }
        cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> cc.setTipo((TipoContatoEnum)cb.getValue()));
        return h;
    }

    public void portabilidade(Span txtDados, String numero) {
        try {
            Portabilidade portabilidade = this.portabilidadeService.getPortabilidade(Long.valueOf(numero));
            if (portabilidade != null) {
                Object port = "";
                if (portabilidade.getOperadora() != null) {
                    port = (String)port + "Operadora: ";
                    port = (String)port + (portabilidade.getOperadora().getAbreviacao() != null ? portabilidade.getOperadora().getAbreviacao().name() : portabilidade.getOperadora().getNome());
                    port = (String)port + " - ";
                }
                if (portabilidade.getDataHora() != null) {
                    port = (String)port + "Portabilidade: ";
                    port = (String)port + portabilidade.getDataHora().format(FormatDate.DATE_BR.toDTF());
                }
                txtDados.setText((String)port);
                txtDados.setVisible(true);
            } else {
                txtDados.setText("Sem Informa\u00e7\u00f5es");
                txtDados.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

