/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cliente.model.ClienteClassificacao;
import br.com.system.app.features.cliente.model.ClienteFilter;
import br.com.system.app.features.cliente.model.ClienteFornecedor;
import br.com.system.app.features.cliente.model.ClienteProdutoCadastro;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.TagOptionEnum;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;

public class ClienteFilterView
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private ComboBox<CepUf> cbUf;
    private MultiComboBox<CepLocalidade> cbLocalidade;
    private ListField listaCpfCnpj;
    private ListField listaCep;
    private ListField listaBairro;
    private TextField txtNome;
    private ClienteFilter filter;
    private MultiSelectComboBox<ClienteTag> cbTags;
    private MultiComboBox<String> cbDdd;
    private MultiComboBox<HierarquiaDTO> cbResponsaveis;
    private MultiComboBox<Equipe> cbEquipe;
    private MultiComboBox<ClienteFornecedor> cbFornecedor;
    private MultiComboBox<ClienteProdutoCadastro> cbProduto;
    private NumberField qtdeInicial;
    private NumberField qtdeFinal;
    private NumberField valorInicial;
    private NumberField valorFinal;
    private DatePicker ativacaoInicial;
    private DatePicker ativacaoFinal;
    private DatePicker fidelidadeInicial;
    private DatePicker fidelidadeFinal;
    private MultiComboBox<ClienteClassificacao> cbClassificacao;
    private NumberField tempoMedioInicial;
    private NumberField tempoMedioFinal;
    private RadioButtonGroup<String> temWhats;
    private ComboBox<TagOptionEnum> cbTagOption;
    private final CepService cepService;
    private final EstruturaUsuario euContext;
    private final ClienteTagService clienteTagService;
    private final EstruturaUsuarioService eus;
    private final ClienteService clienteService;
    private final ClienteProdutoService clienteProdutoService;
    private final UsuarioHierarquiaService hierarquiaService;
    private Button btnPesquisar;
    private final HorizontalContainer container;

    public ClienteFilterView(CepService cepService, ClienteTagService clienteTagService, EstruturaUsuario euContext, EstruturaUsuarioService eus, ClienteService clienteService, ClienteProdutoService clienteProdutoService, UsuarioHierarquiaService hierarquiaService) {
        this.cepService = cepService;
        this.hierarquiaService = hierarquiaService;
        this.clienteProdutoService = clienteProdutoService;
        this.eus = eus;
        this.clienteService = clienteService;
        this.clienteTagService = clienteTagService;
        this.euContext = euContext;
        this.container = new HorizontalContainer(new Component[0]);
        this.getFilterView();
    }

    public HorizontalContainer getContent() {
        return this.container;
    }

    private void clear() {
        this.container.setSpacingOn();
        this.cbDdd.clear();
        this.temWhats.setValue((Object)"Ignorar");
        this.cbFornecedor.clear();
        this.cbProduto.clear();
        this.qtdeInicial.clear();
        this.qtdeFinal.clear();
        this.valorInicial.clear();
        this.valorFinal.clear();
        this.ativacaoInicial.clear();
        this.ativacaoFinal.clear();
        this.fidelidadeInicial.clear();
        this.fidelidadeFinal.clear();
        this.listaCpfCnpj.clear();
        this.listaCep.clear();
        this.txtNome.clear();
        this.cbLocalidade.clear();
        this.cbTags.clear();
        this.cbResponsaveis.clear();
        this.cbEquipe.clear();
        this.listaBairro.clear();
        this.cbClassificacao.clear();
        this.tempoMedioInicial.clear();
        this.tempoMedioFinal.clear();
    }

    private void getFilterView() {
        this.cbDdd = new MultiComboBox("DDD", (Collection)this.cepService.getDdd());
        this.temWhats = new RadioButtonGroup();
        this.temWhats.setVisible(true);
        this.temWhats.setLabel("Cadastro Whatsapp");
        this.temWhats.setItems((Object[])new String[]{"Ignorar", "Com cadastro", "Sem cadastro"});
        this.temWhats.setValue((Object)"Ignorar");
        this.cbFornecedor = new MultiComboBox("Fornecedores", (Collection)this.clienteProdutoService.getFornecedores(this.euContext.getEstrutura().getEstruturaTipo()));
        this.cbFornecedor.setItemLabelGenerator(ClienteFornecedor::getNome);
        this.cbProduto = new MultiComboBox("Produtos", (Collection)this.clienteProdutoService.getProdutos(this.euContext.getEstrutura().getEstruturaTipo()));
        this.cbProduto.setItemLabelGenerator(ClienteProdutoCadastro::getNome);
        this.qtdeInicial = new NumberField(this.isTicket() ? "Colab Inicial" : "Qtde Inicial");
        this.qtdeFinal = new NumberField(this.isTicket() ? "Colab Final" : "Qtde Final");
        this.valorInicial = new NumberField(this.isTicket() ? "Vl Dia Inicial" : "Valor Inicial");
        this.valorFinal = new NumberField(this.isTicket() ? "Vl Dia Final" : "Valor Final");
        this.ativacaoInicial = new DatePicker("Ativa\u00e7\u00e3o Inicial");
        this.ativacaoInicial.setVisible(!EstruturaTipoEnum.getById((Long)this.euContext.getEstrutura().getEstruturaTipo().getId()).equals((Object)EstruturaTipoEnum.TICKET));
        this.ativacaoInicial.setLocale(UIUtils.getLocale());
        this.ativacaoFinal = new DatePicker("Ativa\u00e7\u00e3o Final");
        this.ativacaoFinal.setVisible(!EstruturaTipoEnum.getById((Long)this.euContext.getEstrutura().getEstruturaTipo().getId()).equals((Object)EstruturaTipoEnum.TICKET));
        this.ativacaoFinal.setLocale(UIUtils.getLocale());
        this.fidelidadeInicial = new DatePicker("Fidelidade Inicial");
        this.fidelidadeInicial.setLocale(UIUtils.getLocale());
        this.fidelidadeInicial.setVisible(!this.euContext.getEstrutura().getEstruturaTipo().getId().equals(13L));
        this.fidelidadeFinal = new DatePicker("Fidelidade Final");
        this.fidelidadeFinal.setLocale(UIUtils.getLocale());
        this.fidelidadeFinal.setVisible(!this.euContext.getEstrutura().getEstruturaTipo().getId().equals(13L));
        this.cbClassificacao = new MultiComboBox("Classifica\u00e7\u00e3o", (Collection)this.clienteService.getClassificacao(this.euContext.getEstrutura().getEstruturaTipo()));
        this.cbClassificacao.setItemLabelGenerator(ClienteClassificacao::getNome);
        this.tempoMedioInicial = new NumberField("Tempo M\u00e9dio Inicial");
        this.tempoMedioInicial.setVisible(EstruturaTipoEnum.getById((Long)this.euContext.getEstrutura().getEstruturaTipo().getId()).equals((Object)EstruturaTipoEnum.CLARO));
        this.tempoMedioFinal = new NumberField("Tempo M\u00e9dio Final");
        this.tempoMedioFinal.setVisible(EstruturaTipoEnum.getById((Long)this.euContext.getEstrutura().getEstruturaTipo().getId()).equals((Object)EstruturaTipoEnum.CLARO));
        this.listaCpfCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "Cpf/Cnpj");
        this.listaCep = new ListField(ListFieldTypeEnum.CEP, "Cep");
        this.txtNome = new TextField("Raz\u00e3o Social(Inicio)");
        this.cbLocalidade = new MultiComboBox("Cidade");
        this.cbLocalidade.setItemLabelGenerator(CepLocalidade::getNome);
        this.cbTags = new MultiSelectComboBox("Tags", (Collection)this.clienteTagService.getTags(this.euContext.getEstrutura()));
        this.cbTags.setItemLabelGenerator(ClienteTag::getTag);
        this.cbTags.setWidth("250px");
        this.cbTagOption = new ComboBox("Op\u00e7\u00e3o");
        this.cbTagOption.setId("cbTagOption");
        this.cbTagOption.setWidth("80px");
        this.cbTagOption.setItemLabelGenerator(Enum::name);
        this.cbTagOption.setItems((Object[])TagOptionEnum.values());
        this.cbTagOption.setValue((Object)TagOptionEnum.OU);
        this.cbResponsaveis = new MultiComboBox("Respons\u00e1veis", (Collection)this.hierarquiaService.getHierarquiaDto(this.euContext));
        this.cbResponsaveis.setItemLabelGenerator(HierarquiaDTO::getLoginAndEquipeName);
        this.cbEquipe = new MultiComboBox("Equipe");
        if (this.hasPermission("EQUIPE_VISUALIZACAO_RESTRITA") && !this.isMaster()) {
            if (this.getEu().getEquipe() != null) {
                this.cbEquipe.setItems((Object[])new Equipe[]{this.getEu().getEquipe()});
            }
        } else {
            this.cbEquipe.setItems((Collection)this.eus.getEquipe(this.euContext.getEstrutura()));
        }
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.cbUf = new ComboBox("Estado", (Collection)this.cepService.getUf());
        this.cbUf.setItemLabelGenerator(CepUf::getSigla);
        this.cbUf.setMaxWidth("80px");
        this.cbUf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.cbLocalidade.setItems((Collection)this.cepService.getLocalidadeByUf((CepUf)e.getValue())));
        this.listaBairro = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Bairro");
        this.btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH);
        this.btnPesquisar.setDisableOnClick(true);
        Button btnClear = UIUtils.createSmallButton((String)"Limpar", (VaadinIcon)VaadinIcon.RECYCLE);
        btnClear.addClickListener((ComponentEventListener & Serializable)e -> this.clear());
        HorizontalContainer cvTag = new HorizontalContainer(new Component[0]);
        cvTag.setNoWrap();
        cvTag.add(new Component[]{this.cbTags, this.cbTagOption});
        if (this.isGeneric() || this.isPolo() || this.isTicket()) {
            this.container.add(new Component[]{this.cbUf, this.cbLocalidade, this.listaBairro, this.listaCpfCnpj, this.listaCep, this.txtNome, cvTag, this.cbResponsaveis, this.cbEquipe, this.cbFornecedor, this.cbProduto, this.qtdeInicial, this.qtdeFinal, this.valorInicial, this.valorFinal, this.fidelidadeInicial, this.fidelidadeFinal, this.cbClassificacao, this.tempoMedioInicial, this.tempoMedioFinal, this.temWhats, this.btnPesquisar, btnClear});
        } else {
            this.container.add(new Component[]{this.cbUf, this.cbLocalidade, this.listaBairro, this.listaCpfCnpj, this.listaCep, this.txtNome, cvTag, this.cbResponsaveis, this.cbEquipe, this.cbFornecedor, this.cbProduto, this.qtdeInicial, this.qtdeFinal, this.valorInicial, this.valorFinal, this.ativacaoInicial, this.ativacaoFinal, this.fidelidadeInicial, this.fidelidadeFinal, this.cbClassificacao, this.cbDdd, this.tempoMedioInicial, this.tempoMedioFinal, this.temWhats, this.btnPesquisar, btnClear});
        }
    }

    public ClienteFilter getFilter() {
        if (this.filter == null) {
            this.filter = new ClienteFilter();
        }
        this.filter.setCepFilters(this.listaCep.getValue());
        this.filter.setDocsFilters(this.listaCpfCnpj.getValue());
        this.filter.setBairroFilters(this.listaBairro.getValue());
        this.filter.setNome(this.txtNome.getValue());
        this.filter.setEquipes(this.cbEquipe.getValue());
        this.filter.setResponsaveis(this.cbResponsaveis.getValue());
        this.filter.setTags(this.cbTags.getValue());
        this.filter.setTagOptionEnum((TagOptionEnum)this.cbTagOption.getValue());
        this.filter.setCidadeFilters(this.cbLocalidade.getValue());
        this.filter.setFornecedor(this.cbFornecedor.getValue());
        this.filter.setProdutos(this.cbProduto.getValue());
        this.filter.setQtdInicial(this.qtdeInicial.getValue() == null ? null : Integer.valueOf(((Double)this.qtdeInicial.getValue()).intValue()));
        this.filter.setQtdFinal(this.qtdeFinal.getValue() == null ? null : Integer.valueOf(((Double)this.qtdeFinal.getValue()).intValue()));
        this.filter.setValorInicial(this.valorInicial.getValue() == null ? null : BigDecimal.valueOf((Double)this.valorInicial.getValue()));
        this.filter.setValorFinal(this.valorFinal.getValue() == null ? null : BigDecimal.valueOf((Double)this.valorFinal.getValue()));
        this.filter.setAtivacaoInicial((LocalDate)this.ativacaoInicial.getValue());
        this.filter.setAtivacaoFinal((LocalDate)this.ativacaoFinal.getValue());
        this.filter.setFidelidadeInicial((LocalDate)this.fidelidadeInicial.getValue());
        this.filter.setFidelidadeFinal((LocalDate)this.fidelidadeFinal.getValue());
        this.filter.setClassificacao(this.cbClassificacao.getValue());
        this.filter.setTempoMedioInicio(this.tempoMedioInicial.getValue() == null ? null : Integer.valueOf(((Double)this.tempoMedioInicial.getValue()).intValue()));
        this.filter.setTempoMedioFinal(this.tempoMedioFinal.getValue() == null ? null : Integer.valueOf(((Double)this.tempoMedioFinal.getValue()).intValue()));
        this.filter.setTemWhats((String)this.temWhats.getValue());
        this.filter.setDdds(this.cbDdd.getValue());
        if (this.cbUf.getValue() == null) {
            this.filter.setEstado("");
        } else {
            this.filter.setEstado(((CepUf)this.cbUf.getValue()).getSigla());
        }
        return this.filter;
    }

    public ComboBox<CepUf> getCbUf() {
        return this.cbUf;
    }

    public MultiComboBox<CepLocalidade> getCbLocalidade() {
        return this.cbLocalidade;
    }

    public ListField getListaCpfCnpj() {
        return this.listaCpfCnpj;
    }

    public ListField getListaCep() {
        return this.listaCep;
    }

    public ListField getListaBairro() {
        return this.listaBairro;
    }

    public void setListaBairro(ListField listaBairro) {
        this.listaBairro = listaBairro;
    }

    public TextField getTxtNome() {
        return this.txtNome;
    }

    public CepService getCepService() {
        return this.cepService;
    }

    public Button getBtnPesquisar() {
        return this.btnPesquisar;
    }
}

