/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteFornecedor;
import br.com.system.app.features.cliente.model.ClienteProduto;
import br.com.system.app.features.cliente.model.ClienteProdutoCadastro;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SelectionListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;

public class ClienteProdutoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ClienteProdutoService clienteProdutoService;
    private final Cliente cliente;
    private Grid<ClienteProduto> grid;
    private final EstruturaUsuario eu;
    private final HorizontalContainer formContainer;

    public ClienteProdutoView(Cliente cliente, EstruturaUsuario eu, ClienteProdutoService clienteProdutoService) {
        this.clienteProdutoService = clienteProdutoService;
        this.cliente = cliente;
        this.eu = eu;
        this.formContainer = new HorizontalContainer(new Component[0]);
        if (this.hasPermission("CLIENTE_PRODUTO_VIEW")) {
            this.init();
        } else {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar esta tela");
        }
    }

    private void init() {
        this.setWidth("1000px");
        this.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"Produtos do Cliente"), this.createGrid(), this.formContainer})});
        this.setForm(new ClienteProduto());
        this.open();
    }

    private void povoa() {
        this.grid.setItems((Collection)this.clienteProdutoService.getByCliente(this.cliente));
    }

    private HorizontalContainer createGrid() {
        this.grid = new Grid(ClienteProduto.class);
        this.grid.addSelectionListener((SelectionListener & Serializable)e -> {
            Optional firstSelectedItem = e.getFirstSelectedItem();
            if (firstSelectedItem.isPresent()) {
                this.setForm((ClienteProduto)firstSelectedItem.get());
            } else {
                this.setForm(new ClienteProduto());
            }
        });
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("955px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getClienteFornecedor().getNome())).setFlexGrow(0).setWidth("150px").setHeader("Fornecedor");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getClienteProdutoCadastro().getNome())).setHeader("Produto").setFlexGrow(0).setWidth("250px");
        if (this.isTicket()) {
            this.grid.addColumn("quantidade").setFlexGrow(0).setWidth("150px").setHeader("Colaboradores");
            this.grid.addColumn("valor").setFlexGrow(0).setWidth("120px").setHeader("Valor Dia");
            this.grid.addColumn("quantidadeDias").setFlexGrow(0).setWidth("130px").setHeader("Dias");
            this.grid.addColumn("desconto").setFlexGrow(0).setWidth("120px").setHeader("Desagio%");
        } else if (this.isGeneric() || this.isPolo()) {
            this.grid.addColumn("quantidade").setFlexGrow(0).setWidth("130px");
            this.grid.addColumn("valor").setFlexGrow(0).setWidth("120px");
        } else {
            this.grid.addColumn("quantidade").setFlexGrow(0).setWidth("130px");
            this.grid.addColumn("valor").setFlexGrow(0).setWidth("120px");
            this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataAtivacao() == null ? "" : p.getDataAtivacao().format(FormatDate.DATE_BR.toDTF()))).setHeader("Ativa\u00e7\u00e3o").setFlexGrow(0).setWidth("150px");
        }
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataFidelidade() == null ? "" : p.getDataFidelidade().format(FormatDate.DATE_BR.toDTF()))).setHeader("Fidelidade").setFlexGrow(0).setWidth("150px");
        this.povoa();
        return new HorizontalContainer(new Component[]{this.grid});
    }

    private void setForm(ClienteProduto cp) {
        this.formContainer.removeAll();
        ComboBox cbFornecedor = new ComboBox("Fornecedor", (Collection)this.clienteProdutoService.getFornecedores(this.getEstrutura().getEstruturaTipo()));
        cbFornecedor.setItemLabelGenerator(ClienteFornecedor::getNome);
        if (cp.getClienteFornecedor() != null) {
            cbFornecedor.setValue((Object)cp.getClienteFornecedor());
        }
        ComboBox cbProduto = new ComboBox("Produto", (Collection)this.clienteProdutoService.getProdutos(this.getEstrutura().getEstruturaTipo()));
        cbProduto.setItemLabelGenerator(ClienteProdutoCadastro::getNome);
        cbProduto.setWidth("250px");
        if (cp.getClienteProdutoCadastro() != null) {
            cbProduto.setValue((Object)cp.getClienteProdutoCadastro());
        }
        NumberField quantidade = new NumberField(this.isTicket() ? "Colaboradores" : "Quantidade");
        if (cp.getQuantidade() != null) {
            quantidade.setValue((Number)cp.getQuantidade().doubleValue());
        }
        NumberField valor = new NumberField(this.isTicket() ? "Valor Dia" : "Valor");
        if (cp.getValor() != null) {
            valor.setValue((Number)cp.getValor().doubleValue());
        }
        NumberField dias = new NumberField("Quantos Dias");
        if (cp.getQuantidadeDias() != null) {
            dias.setValue((Number)cp.getQuantidadeDias().doubleValue());
        }
        NumberField desagio = new NumberField("Desagio%");
        if (cp.getDesconto() != null) {
            desagio.setValue((Number)cp.getDesconto().doubleValue());
        }
        DatePicker dataAtivacao = new DatePicker();
        dataAtivacao.setLabel("Ativa\u00e7\u00e3o");
        dataAtivacao.setVisible(!this.eu.getEstrutura().getEstruturaTipo().getId().equals(13L));
        dataAtivacao.setLocale(UIUtils.getLocale());
        if (cp.getDataAtivacao() != null) {
            dataAtivacao.setValue(cp.getDataAtivacao());
        } else {
            dataAtivacao.setValue(null);
        }
        DatePicker dataFidelidade = new DatePicker();
        dataFidelidade.setLabel("Fidelidade");
        dataFidelidade.setVisible(!this.eu.getEstrutura().getEstruturaTipo().getId().equals(13L));
        dataFidelidade.setLocale(UIUtils.getLocale());
        if (cp.getDataFidelidade() != null) {
            dataFidelidade.setValue(cp.getDataFidelidade());
        } else {
            dataFidelidade.setValue(null);
        }
        Button btnGravar = UIUtils.createSmallButton((String)"Gravar", (VaadinIcon)VaadinIcon.INBOX);
        btnGravar.setEnabled(this.hasPermission("CLIENTE_PRODUTO_SAVE"));
        btnGravar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.hasPermission("CLIENTE_PRODUTO_SAVE")) {
                UIUtils.showNotification((String)"Sem permiss\u00e3o para salvar produtos.");
            }
            if (cbFornecedor.getValue() == null || cbProduto.getValue() == null) {
                UIUtils.showNotification((String)"Fornecedor e Produto s\u00e3o campos obrigat\u00f3rios.");
                return;
            }
            if (valor.getValue() == null && (Double)quantidade.getValue() == 0.0 && dataAtivacao.getValue() == null && dataFidelidade.getValue() == null) {
                UIUtils.showNotification((String)"Informe pelo menos 1 dos dados (valor, quantidade, ativacao, fidelidade");
                return;
            }
            cp.setCliente(this.cliente);
            cp.setDataAtivacao((LocalDate)dataAtivacao.getValue());
            cp.setDataFidelidade((LocalDate)dataFidelidade.getValue());
            cp.setClienteFornecedor((ClienteFornecedor)cbFornecedor.getValue());
            cp.setQuantidade(Integer.valueOf(quantidade.getValue() == null ? 0 : ((Double)quantidade.getValue()).intValue()));
            cp.setValor(valor.getValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)valor.getValue()));
            cp.setClienteProdutoCadastro((ClienteProdutoCadastro)cbProduto.getValue());
            cp.setQuantidadeDias(Integer.valueOf(dias.getValue() == null ? 0 : ((Double)dias.getValue()).intValue()));
            cp.setDesconto(desagio.getValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)desagio.getValue()));
            this.clienteProdutoService.salvar(cp, this.eu);
            this.setForm(new ClienteProduto());
            this.povoa();
            valor.clear();
            quantidade.clear();
            dataAtivacao.clear();
            dataFidelidade.clear();
            cbFornecedor.clear();
            cbProduto.clear();
            dias.clear();
            desagio.clear();
        });
        Button btnExcluir = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH);
        btnExcluir.setEnabled(cp.getId() != null && this.hasPermission("CLIENTE_PRODUTO_DELETE"));
        Button btnNovo = UIUtils.createSmallButton((String)"Novo", (VaadinIcon)VaadinIcon.PLUS);
        btnNovo.addClickListener((ComponentEventListener & Serializable)e -> this.setForm(new ClienteProduto()));
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cp.getId() == null || cp.getId() <= 0L) {
                UIUtils.showNotification((String)"Impossivel deletar");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Excluir Produto", "Confirma exclus\u00e3o do produto do cliente?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.clienteProdutoService.delete(cp, this.eu);
                cd.close();
                this.povoa();
            });
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        if (this.isTicket()) {
            this.formContainer.add(new Component[]{cbFornecedor, cbProduto, quantidade, valor, dias, desagio, dataFidelidade, new FooterContainer(new Component[]{btnFechar, btnExcluir, btnNovo, btnGravar})});
        } else if (this.isGeneric() || this.isPolo()) {
            this.formContainer.add(new Component[]{cbFornecedor, cbProduto, quantidade, valor, dataFidelidade, new FooterContainer(new Component[]{btnFechar, btnExcluir, btnNovo, btnGravar})});
        } else {
            this.formContainer.add(new Component[]{cbFornecedor, cbProduto, quantidade, valor, dataAtivacao, dataFidelidade, new FooterContainer(new Component[]{btnFechar, btnExcluir, btnNovo, btnGravar})});
        }
    }
}

