/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.model;

import br.com.system.app.features.cobranca.model.CobrancaTipoEnum;
import br.com.system.app.features.cobranca.model.ProprietarioEnum;
import br.com.system.app.features.shared.model.IEntity;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate
@Table(name="cobranca_assinatura")
public class CobrancaAssinatura
implements IEntity,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    private LocalDate dataCriacao;
    @Enumerated(value=EnumType.STRING)
    private CobrancaTipoEnum tipo;
    private String cpfCnpj;
    private String nome;
    private String cep;
    private String logradouro;
    private String numero;
    private String compl;
    private String bairro;
    private String cidade;
    private String estado;
    private boolean inadimplente;
    private boolean divergente;
    private boolean bloqueado;
    @NotNull
    private BigDecimal valorMensal;
    private BigDecimal valorDesconto;
    private LocalDate descontoAte;
    private Boolean ativo;
    private Integer periodoCobrancaMeses;
    @NotNull
    private LocalDate proximoVencimento;
    private String enotasClienteId;
    @NotNull
    private String listaEmail;
    private String celular;
    private String celular2;
    private String observacao;
    private Integer nroUsuarios;
    private Integer nroLoginsOperadora;
    private Integer nroWhatsapp;
    private Integer nroRamais;
    private Integer nroLeads;
    private LocalDate primeiroPagamento;
    private String vendedor;
    @Enumerated(value=EnumType.STRING)
    private ProprietarioEnum proprietario;

    public String getCpfCnpjAndNomeAndAtivo() {
        return this.getCpfCnpj() + " " + this.getNome() + " (" + (this.getAtivo() != false ? "ATIVO" : "INATIVO") + ")";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    public BigDecimal getValorMensal() {
        return this.valorMensal;
    }

    public void setValorMensal(BigDecimal valorMensal) {
        this.valorMensal = valorMensal;
    }

    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public LocalDate getDescontoAte() {
        return this.descontoAte;
    }

    public void setDescontoAte(LocalDate descontoAte) {
        this.descontoAte = descontoAte;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public LocalDate getProximoVencimento() {
        return this.proximoVencimento;
    }

    public void setProximoVencimento(LocalDate proximoVencimento) {
        this.proximoVencimento = proximoVencimento;
    }

    public String getListaEmail() {
        return this.listaEmail;
    }

    public void setListaEmail(String listaEmail) {
        this.listaEmail = listaEmail;
    }

    public CobrancaTipoEnum getTipo() {
        return this.tipo;
    }

    public void setTipo(CobrancaTipoEnum tipo) {
        this.tipo = tipo;
    }

    public Integer getPeriodoCobrancaMeses() {
        return this.periodoCobrancaMeses;
    }

    public void setPeriodoCobrancaMeses(Integer periodoCobrancaMeses) {
        this.periodoCobrancaMeses = periodoCobrancaMeses;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getCompl() {
        return this.compl;
    }

    public void setCompl(String compl) {
        this.compl = compl;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getEnotasClienteId() {
        return this.enotasClienteId;
    }

    public void setEnotasClienteId(String enotasClienteId) {
        this.enotasClienteId = enotasClienteId;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public boolean isInadimplente() {
        return this.inadimplente;
    }

    public void setInadimplente(boolean inadimplente) {
        this.inadimplente = inadimplente;
    }

    public boolean isBloqueado() {
        return this.bloqueado;
    }

    public void setBloqueado(boolean bloqueado) {
        this.bloqueado = bloqueado;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Integer getNroUsuarios() {
        return this.nroUsuarios;
    }

    public void setNroUsuarios(Integer nroUsuarios) {
        this.nroUsuarios = nroUsuarios;
    }

    public Integer getNroLoginsOperadora() {
        return this.nroLoginsOperadora;
    }

    public void setNroLoginsOperadora(Integer nroLoginsOperadora) {
        this.nroLoginsOperadora = nroLoginsOperadora;
    }

    public Integer getNroWhatsapp() {
        return this.nroWhatsapp;
    }

    public void setNroWhatsapp(Integer nroWhatsapp) {
        this.nroWhatsapp = nroWhatsapp;
    }

    public Integer getNroRamais() {
        return this.nroRamais;
    }

    public void setNroRamais(Integer nroRamais) {
        this.nroRamais = nroRamais;
    }

    public Integer getNroLeads() {
        return this.nroLeads;
    }

    public void setNroLeads(Integer nroLeads) {
        this.nroLeads = nroLeads;
    }

    public LocalDate getPrimeiroPagamento() {
        return this.primeiroPagamento;
    }

    public void setPrimeiroPagamento(LocalDate primeiroPagamento) {
        this.primeiroPagamento = primeiroPagamento;
    }

    public boolean isDivergente() {
        return this.divergente;
    }

    public void setDivergente(boolean divergente) {
        this.divergente = divergente;
    }

    public String getVendedor() {
        return this.vendedor;
    }

    public void setVendedor(String vendedor) {
        this.vendedor = vendedor;
    }

    public String getCelular2() {
        return this.celular2;
    }

    public void setCelular2(String celular2) {
        this.celular2 = celular2;
    }

    public ProprietarioEnum getProprietario() {
        return this.proprietario;
    }

    public void setProprietario(ProprietarioEnum proprietario) {
        this.proprietario = proprietario;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CobrancaAssinatura other = (CobrancaAssinatura)obj;
        return Objects.equals(this.id, other.id);
    }

    public CobrancaAssinatura clone() throws CloneNotSupportedException {
        return (CobrancaAssinatura)super.clone();
    }
}

