/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.repository;

import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaValorDTO;
import br.com.system.app.features.cobranca.repository.CobrancaAssinaturaRepositoryQuery;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class CobrancaAssinaturaRepositoryImpl
implements CobrancaAssinaturaRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<CobrancaAssinatura> filter(Boolean ativo, String nome, String cpfCnpj, boolean inadimplentes, boolean divergentes, LocalDate pagamentoIni, LocalDate pagamentoFim, Pageable pageable) {
        Query query = this.getQuery(ativo, nome, cpfCnpj, inadimplentes, divergentes, pagamentoIni, pagamentoFim, pageable);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public long count(Boolean ativo, String nome, String cpfCnpj, boolean inadimplentes, boolean divergentes, LocalDate pagamentoIni, LocalDate pagamentofim) {
        Query query = this.getQuery(ativo, nome, cpfCnpj, inadimplentes, divergentes, pagamentoIni, pagamentofim, null);
        return StringUtil.toLong((String)query.getSingleResult().toString());
    }

    private Query getQuery(Boolean ativo, String nome, String cpfCnpj, boolean inadimplentes, boolean divergentes, LocalDate pagamentoIni, LocalDate pagamentoFim, Pageable pageable) {
        Query query;
        StringBuilder sql = new StringBuilder();
        if (pageable == null) {
            sql.append("SELECT count(*) as total");
        } else {
            sql.append(" SELECT ca ");
        }
        sql.append(" FROM CobrancaAssinatura ca WHERE 1=1");
        if (ativo != null) {
            sql.append(" AND ca.ativo=:ativo");
        }
        if (nome != null && !nome.isEmpty()) {
            sql.append(" AND (ca.nome like :nome or ca.listaEmail like :nome)");
        }
        if (cpfCnpj != null && !cpfCnpj.isEmpty()) {
            sql.append(" AND ca.cpfCnpj =:cpfCnpj");
        }
        if (inadimplentes) {
            sql.append(" AND ca.inadimplente=1");
        }
        if (divergentes) {
            sql.append(" AND ca.divergente=1");
        }
        if (pagamentoIni != null) {
            sql.append(" AND ca.primeiroPagamento >=:pagamentoIni");
        }
        if (pagamentoFim != null) {
            sql.append(" AND ca.primeiroPagamento <=:pagamentoFim");
        }
        sql.append(" order by ca.inadimplente desc");
        if (pageable != null) {
            query = this.manager.createQuery(sql.toString(), CobrancaAssinatura.class);
            query.setFirstResult(pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        } else {
            query = this.manager.createQuery(sql.toString());
        }
        if (ativo != null) {
            query.setParameter("ativo", (Object)ativo);
        }
        if (nome != null && !nome.isEmpty()) {
            query.setParameter("nome", (Object)("%" + nome + "%"));
        }
        if (cpfCnpj != null && !cpfCnpj.isEmpty()) {
            query.setParameter("cpfCnpj", (Object)cpfCnpj);
        }
        if (pagamentoIni != null) {
            query.setParameter("pagamentoIni", (Object)pagamentoIni);
        }
        if (pagamentoFim != null) {
            query.setParameter("pagamentoFim", (Object)pagamentoFim);
        }
        return query;
    }

    @Transactional
    public void checarInadimplencia(String cpfCnpj) {
        Object sqlF = "update cobranca_assinatura set inadimplente=0 ";
        if (!cpfCnpj.isEmpty()) {
            sqlF = (String)sqlF + " where cpf_cnpj=:cpfCnpj";
        }
        Query query = this.manager.createNativeQuery((String)sqlF);
        if (!cpfCnpj.isEmpty()) {
            query.setParameter("cpfCnpj", (Object)cpfCnpj);
        }
        query.executeUpdate();
        Object sql = "update cobranca_assinatura ca,cobranca_fatura cf set ca.inadimplente=1 where ca.id=cf.cobranca_assinatura_id and cf.status='EM_ABERTO' and cf.data_vencimento<current_date()";
        if (!cpfCnpj.isEmpty()) {
            sql = (String)sql + " and ca.cpf_cnpj=:cpfCnpj";
        }
        Query query2 = this.manager.createNativeQuery((String)sql);
        if (!cpfCnpj.isEmpty()) {
            query2.setParameter("cpfCnpj", (Object)cpfCnpj);
        }
        query2.executeUpdate();
        this.manager.createNativeQuery("update cobranca_assinatura set bloqueado=0 where inadimplente=0 and ativo=1").executeUpdate();
        this.manager.createNativeQuery("update estrutura,estrutura_complemento,cobranca_assinatura set estrutura.ativo=0  where estrutura.id=estrutura_complemento.estrutura_id and estrutura_complemento.cobranca_assinatura_id=cobranca_assinatura.id and cobranca_assinatura.ativo=0 and estrutura.ativo=1").executeUpdate();
    }

    @Transactional(readOnly=true)
    public CobrancaValorDTO findMensalPago() {
        String sql = "select uuid_short() id,sum(valor_pago)valor,count(*) quantidade from cobranca_fatura where data_pagamento >=DATE_FORMAT(NOW() ,'%Y-%m-01')";
        Query query = this.manager.createNativeQuery(sql, CobrancaValorDTO.class);
        return (CobrancaValorDTO)query.getSingleResult();
    }

    @Transactional(readOnly=true)
    public CobrancaValorDTO findMensalAvencer() {
        String sql = "select uuid_short() id,sum(cf.valor)valor,count(*) quantidade from cobranca_fatura cf,cobranca_assinatura ca WHERE cf.cobranca_assinatura_id=ca.id AND ca.bloqueado=0 AND ca.ativo=1 AND cf.status='EM_ABERTO' AND data_vencimento >= current_date() and data_vencimento<=LAST_DAY(now())";
        Query query = this.manager.createNativeQuery(sql, CobrancaValorDTO.class);
        return (CobrancaValorDTO)query.getSingleResult();
    }

    @Transactional(readOnly=true)
    public CobrancaValorDTO findAGerar() {
        Object sql = "select uuid_short() id,sum(ca.valor_mensal)valor,count(*) quantidade from cobranca_assinatura ca";
        sql = (String)sql + " WHERE ca.ativo=1 and ca.bloqueado=0";
        sql = (String)sql + " AND ca.proximo_vencimento >current_date() and ca.proximo_vencimento <='" + String.valueOf(DateTimeUtil.getLastDayOfMonth((LocalDate)LocalDate.now()).minusDays(8L)) + "'";
        Query query = this.manager.createNativeQuery((String)sql, CobrancaValorDTO.class);
        return (CobrancaValorDTO)query.getSingleResult();
    }

    @Transactional(readOnly=true)
    public CobrancaValorDTO findFaturasVencidos() {
        String sql = "select uuid_short() id,sum(cf.valor)valor,count(*) quantidade from cobranca_fatura cf,cobranca_assinatura ca WHERE cf.cobranca_assinatura_id=ca.id AND ca.ativo=1 AND cf.status='EM_ABERTO' AND data_vencimento <current_date()";
        Query query = this.manager.createNativeQuery(sql, CobrancaValorDTO.class);
        return (CobrancaValorDTO)query.getSingleResult();
    }

    @Transactional(readOnly=true)
    public List<CobrancaValorDTO> findAssinaturasVencidas() {
        String sql = "select uuid_short() id,sum(cf.valor)valor,count(*) quantidade from cobranca_fatura cf,cobranca_assinatura ca WHERE cf.cobranca_assinatura_id=ca.id  AND ca.ativo=1 AND cf.status='EM_ABERTO' AND data_vencimento <current_date() AND ca.cpf_cnpj !='17738735000110' group by ca.id";
        Query query = this.manager.createNativeQuery(sql, CobrancaValorDTO.class);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<CobrancaValorDTO> findAssinaturasAtivas() {
        String sql = "select uuid_short() as id, (valor_mensal/periodo_cobranca_meses) as valor,  1 as quantidade from cobranca_assinatura ca WHERE ca.ativo=1 AND ca.bloqueado=0 AND ca.cpf_cnpj !='17738735000110'";
        Query query = this.manager.createNativeQuery(sql, CobrancaValorDTO.class);
        return query.getResultList();
    }
}

