/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.configurations.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.model.Configurations;
import br.com.system.app.features.configurations.repository.ConfigurationsRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationsService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ConfigurationsRepository configurationRepository;

    public boolean storageIsGoogle() {
        return this.get(ConfigurationEnum.STORAGE).getValor().equals("GOOGLE");
    }

    public Configurations get(ConfigurationEnum configuracao) {
        Configurations config = this.configurationRepository.findByConfiguracao(configuracao);
        if (config == null) {
            throw new BusinessException("N\u00e3o encontrei a configura\u00e7\u00e3o: " + configuracao.toString() + " na tabela configurations");
        }
        return config;
    }

    public void save(Configurations configurations) {
        this.configurationRepository.save((Object)configurations);
    }
}

