/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dashboard;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.producaopainel.service.ProducaoPainelResumoService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.DateTimeUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;

@Route(value="dashboard-atualizacao", layout=MainLayout.class)
@PageTitle(value="Dashboard atualizacao")
@RolesAllowed(value={"MASTER"})
public class DashBoardAtualizacaoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoPainelResumoService pprs;
    private final EstruturaService estruturaService;

    public DashBoardAtualizacaoView(ProducaoPainelResumoService pprs, EstruturaService estruturaService) {
        this.pprs = pprs;
        this.estruturaService = estruturaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent((Component)this.createContent());
        }
    }

    public HorizontalContainer createContent() {
        DatePicker dataIni = new DatePicker();
        dataIni.setLabel("Inicio Atualizacao");
        dataIni.setLocale(UIUtils.getLocale());
        dataIni.setEnabled(true);
        DatePicker dataFim = new DatePicker();
        dataFim.setLabel("Final Atualizacao");
        dataFim.setLocale(UIUtils.getLocale());
        dataFim.setEnabled(true);
        ComboBox cbEstrutura = new ComboBox("Estruturas", (Collection)this.estruturaService.getAtivas(this.getEstrutura().getEstruturaTipo()));
        cbEstrutura.setItemLabelGenerator(Estrutura::getNome);
        Button btnAtualizar = UIUtils.createSmallButton((String)"Atualizar Base");
        btnAtualizar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.pprs.atualizar(this.getEu(), dataIni.getValue() == null ? null : ((LocalDate)dataIni.getValue()).atStartOfDay(), dataFim.getValue() == null ? null : DateTimeUtil.getEndOfDay((LocalDate)((LocalDate)dataFim.getValue())), (Estrutura)cbEstrutura.getValue());
            UIUtils.showNotification((String)"Atualizando....");
        });
        HorizontalContainer main = new HorizontalContainer(new Component[]{dataIni, dataFim, cbEstrutura, btnAtualizar});
        return main;
    }
}

