/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dicasistema;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.dicasistema.model.DicaSistema;
import br.com.system.app.features.dicasistema.service.DicaSistemaService;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.AbstractStreamResource;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class DicaSistemaForm
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private DicaSistemaService dss;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private DicaSistema ds;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(DicaSistema dica) {
        this.ds = dica;
        this.removeAll();
        if (this.ds == null) {
            this.ds = new DicaSistema();
        }
        Button btnCleanImage = UIUtils.createSmallButton((String)"Excluir Imagem");
        btnCleanImage.setVisible(false);
        Image image = new Image();
        image.setWidth("400px");
        image.setHeight("400px");
        image.setVisible(false);
        if (this.ds.getNomeImagem() != null) {
            try {
                this.nomeArquivo = this.ds.getNomeImagem();
                image.setVisible(true);
                image.setSrc((AbstractStreamResource)StorageUtil.getStreamResource((String)this.ds.getHashImagem(), (String)this.nomeArquivo));
                btnCleanImage.setVisible(true);
            }
            catch (Exception e2) {
                UIUtils.showNotification((String)e2.getMessage());
            }
        }
        btnCleanImage.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Excluir imagem", "Tem certeza que deseja excluir?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                image.setVisible(false);
                this.ds.setNomeImagem("");
                this.nomeArquivo = "";
                try {
                    StorageUtil.deleteObject((String)this.ds.getHashImagem());
                }
                catch (Exception e1) {
                    UIUtils.showError((String)("Erro ao excluir arquivo " + e1.getMessage()));
                }
                cd.close();
                image.removeAll();
            });
        });
        VerticalLayout lay = new VerticalLayout();
        lay.setWidth("600px");
        lay.setHeight("98%");
        lay.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Cadastro de Dicas")});
        TextField txtTitulo = new TextField("Titulo");
        txtTitulo.setWidthFull();
        if (this.ds.getTitulo() != null) {
            txtTitulo.setValue(this.ds.getTitulo());
        }
        TextArea txtTexto = new TextArea("Texto");
        txtTexto.setWidthFull();
        txtTexto.setHeight("200px");
        if (this.ds.getTexto() != null) {
            txtTexto.setValue(this.ds.getTexto());
        }
        MultiComboBox cbTipo = new MultiComboBox("Tipo Estrutura", (Object[])EstruturaTipoEnum.values());
        cbTipo.setWidthFull();
        if (this.ds.getListaTipoEstrutura() != null && !this.ds.getListaTipoEstrutura().isEmpty()) {
            HashSet<EstruturaTipoEnum> lista = new HashSet<EstruturaTipoEnum>();
            for (String s : this.ds.getListaTipoEstrutura().split(",")) {
                lista.add(EstruturaTipoEnum.valueOf((String)s.toUpperCase()));
            }
            cbTipo.setValue(lista);
        }
        RadioButtonGroup rbPadrao = new RadioButtonGroup();
        rbPadrao.setItems((Object[])new String[]{"SIM", "NAO"});
        if (this.ds.getPadrao() != null && this.ds.getPadrao().booleanValue()) {
            rbPadrao.setValue((Object)"SIM");
        } else {
            rbPadrao.setValue((Object)"NAO");
        }
        TextField txtYoutube = new TextField("Embeded Youtube Link");
        txtYoutube.setWidthFull();
        if (this.ds.getUrlYoutube() != null) {
            txtYoutube.setValue(this.ds.getUrlYoutube());
        }
        Scroller scroller = new Scroller((com.vaadin.flow.component.Component)new VerticalLayout(new com.vaadin.flow.component.Component[]{txtTitulo, txtTexto, rbPadrao, cbTipo, txtYoutube, image, btnCleanImage, this.createUpload()}));
        scroller.setWidthFull();
        scroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        scroller.getStyle().set("border-bottom", "1px solid var(--lumo-contrast-20pct)").set("padding", "var(--lumo-space-m)");
        lay.add(new com.vaadin.flow.component.Component[]{scroller});
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (txtTitulo.getValue() == null || txtTitulo.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe um Titulo");
                return;
            }
            if (cbTipo.getValue() == null || cbTipo.getValue().size() <= 0) {
                UIUtils.showNotification((String)"Selecione pelo menos um tipo de estrutura");
                return;
            }
            if ((txtYoutube.getValue() == null || txtYoutube.getValue().isEmpty()) && this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Informe um link do Youtube ou importe uma imagem");
                return;
            }
            if (txtYoutube.getValue() != null && !txtYoutube.getValue().isEmpty() && !this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Informe um link do Youtube OU importe uma imagem N\u00e3o os 2");
                return;
            }
            this.ds.setNomeImagem(this.nomeArquivo);
            this.ds.setDataPostagem(LocalDate.now());
            this.ds.setPadrao(Boolean.valueOf(((String)rbPadrao.getValue()).equals("SIM")));
            this.ds.setTexto(txtTexto.getValue());
            this.ds.setTitulo(txtTitulo.getValue());
            this.ds.setUrlYoutube(txtYoutube.getValue());
            this.dss.salvar(this.ds, this.mBuffer.getInputStream(), cbTipo.getValue());
            this.close();
        });
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        lay.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnSalvar})});
        this.add(new com.vaadin.flow.component.Component[]{lay});
        this.open();
    }

    private Upload createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{"image/*"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            if (e.getContentLength() > 500000L) {
                UIUtils.showNotification((String)"Imagem ultrapassa o limite de 500kb");
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                return;
            }
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas imagens"));
        return upload;
    }
}

