/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dicasistema.repository;

import br.com.system.app.features.dicasistema.model.DicaSistema;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DicaSistemaRepository
extends JpaRepository<DicaSistema, Long>,
Serializable {
    @Query(nativeQuery=true, value="SELECT d.* FROM dica_sistema d WHERE FIND_IN_SET(:estruturaTipo,d.lista_tipo_estrutura) order by d.padrao desc")
    public List<DicaSistema> getByEstruturaTipo(@Param(value="estruturaTipo") String var1);

    @Query(nativeQuery=true, value="SELECT d.* FROM dica_sistema d WHERE FIND_IN_SET(:estruturaTipo,d.lista_tipo_estrutura) and d.modulo=:modulo order by d.padrao desc")
    public List<DicaSistema> getByEstruturaTipoAndModule(@Param(value="estruturaTipo") String var1, @Param(value="modulo") String var2);

    public Page<DicaSistema> findByTituloContains(String var1, Pageable var2);

    @Query(nativeQuery=true, value="SELECT d.modulo FROM dica_sistema d WHERE FIND_IN_SET(:estruturaTipo,d.lista_tipo_estrutura) and modulo is not null  and modulo !='' group by d.modulo order by d.modulo")
    public List<String> findModulesList(@Param(value="estruturaTipo") String var1);

    @Query(nativeQuery=true, value="SELECT d.* FROM dica_sistema d WHERE FIND_IN_SET(:estruturaTipo,d.lista_tipo_estrutura) and d.padrao=1")
    public DicaSistema getPadrao(@Param(value="estruturaTipo") String var1);

    public long countByTituloContains(String var1);

    @Modifying
    @Query(nativeQuery=true, value="update dica_sistema set padrao=0 where padrao=1 and find_in_set(:tipo,lista_tipo_estrutura)")
    public void updatePadrao(@Param(value="tipo") String var1);
}

