/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.email.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.ClienteVencimento;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteVencimentoService;
import br.com.system.app.features.email.model.EmailAtividade;
import br.com.system.app.features.email.model.EmailAtividadeTipoEnum;
import br.com.system.app.features.email.repository.EmailAtividadeRepository;
import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.dto.PedidoEtapaDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEmail;
import br.com.system.app.features.pedido.repository.PedidoRepository;
import br.com.system.app.features.pedido.service.PedidoEmailService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmailAtividadeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(EmailAtividadeService.class);
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoEmailService pedidoEmailService;
    @Autowired
    private EmailAtividadeRepository repository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private SendMailService sendmail;
    @Autowired
    private EstruturaComplementoService ecs;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ClienteVencimentoService clienteVencimentoService;
    @Autowired
    private ClienteService clienteService;

    @Transactional
    public void delete(EmailAtividade emailAtividade) throws Exception {
        String[] split;
        for (String image : split = emailAtividade.getHashImages().split(",")) {
            StorageUtil.deleteObject((String)image);
        }
        this.repository.delete((Object)emailAtividade);
    }

    public void sendVencimento(EstruturaUsuario eu, EmailAtividade ea, String cnpj, String emailTeste) {
        Cliente cliente = this.clienteService.getAndCreateCliente(eu, cnpj, new ClienteContato[0]);
        Set cvs = this.clienteVencimentoService.getByCliente(cliente);
        if (!cvs.isEmpty()) {
            this.sendVencimento(eu, ea, (ClienteVencimento)cvs.iterator().next(), emailTeste);
        }
    }

    public void sendVencimento(EstruturaUsuario eu, EmailAtividade ea, ClienteVencimento cv, String emailTeste) {
        String mensagem = "<html><body>" + ea.getMensagemHtml().replace("#nomeCliente", cv.getCliente().getNome()).replace("#identificador", cv.getNome()).replace("#cpf-cnpj", cv.getCliente().getCpfCnpj()).replace("#dia-vencimento", cv.getDia().toString()) + "</body></html>";
        HashSet<String> emails = new HashSet<String>();
        if (!emailTeste.isEmpty()) {
            emails.add(emailTeste);
            ea.setAssunto(ea.getAssunto() + "(Teste)");
        } else {
            for (ClienteContato cc : cv.getCliente().getClienteContato()) {
                if (!ValidationUtil.isValidEmail((String)cc.getValor().trim()) || !cc.getVerificado().equals((Object)ClienteContatoVerficadoEnum.VALIDO)) continue;
                emails.add(cc.getValor().trim());
            }
        }
        if (emails.size() <= 0) {
            return;
        }
        this.sendmail.sendWithClientEmail(eu, emails, ea.getAssunto(), mensagem);
    }

    public void send(EstruturaUsuario eu, EmailAtividade emailAtividade, String numeroPedido) {
        this.send(eu, emailAtividade, numeroPedido, "");
    }

    public void send(EstruturaUsuario eu, EmailAtividade emailAtividade, String numeroPedido, String emailTeste) {
        Pedido pedido = this.pedidoService.getByNumeroAndEstrutura(numeroPedido, emailAtividade.getEstruturaUsuario().getEstrutura());
        if (pedido == null) {
            throw new BusinessException("Pedido n\u00e3o encontrado");
        }
        String mensagem = "<html><body>" + emailAtividade.getMensagemHtml().replace("#nomeCliente", pedido.getCliente().getNome()).replace("#numeroPedido", "#" + pedido.getNumero()) + "</body></html>";
        HashSet<String> emails = new HashSet<String>();
        if (!emailTeste.isEmpty()) {
            emails.add(emailTeste);
            emailAtividade.setAssunto(emailAtividade.getAssunto() + "(Teste)");
        } else {
            for (ClienteContato cc : pedido.getCliente().getClienteContato()) {
                if (!ValidationUtil.isValidEmail((String)cc.getValor().trim()) || !cc.getVerificado().equals((Object)ClienteContatoVerficadoEnum.VALIDO)) continue;
                emails.add(cc.getValor().trim());
            }
        }
        if (emails.size() <= 0) {
            return;
        }
        this.sendmail.sendWithClientEmail(eu, emails, emailAtividade.getAssunto(), mensagem);
        PedidoEmail pe = new PedidoEmail();
        pe.setAssunto(emailAtividade.getAssunto());
        pe.setDataHoraEnvio(LocalDateTime.now());
        pe.setDestinatarios(StringUtils.join(emails, (String)","));
        pe.setEstruturaUsuario(eu);
        pe.setMensagem(mensagem);
        pe.setPedido(pedido);
        this.pedidoEmailService.savePedidoEmail(pe);
    }

    @Async(value="asyncDefault")
    public void envioDiario() {
        Thread.currentThread().setName("asyncDefault-envio-diario-email");
        EmailAtividade eaCliente = this.repository.findFirstByEstruturaUsuarioEstruturaAtivoAndAtivoAndTipo(Boolean.TRUE, Boolean.TRUE, EmailAtividadeTipoEnum.CLIENTES);
        List lista = this.repository.findByEstruturaUsuarioEstruturaAtivoAndAtivo(Boolean.valueOf(true), Boolean.valueOf(true));
        for (EmailAtividade ea : lista) {
            try {
                EstruturaComplemento ec = this.ecs.getComplementos(ea.getEstruturaUsuario().getEstrutura());
                if (!ec.getCobrancaAssinatura().getAtivo().booleanValue()) continue;
                EstruturaUsuario eu = this.eus.getMasterEstrutura(ea.getEstruturaUsuario().getEstrutura());
                if (ea.getTipo().equals((Object)EmailAtividadeTipoEnum.ATIVIDADE)) {
                    LocalDateTime dataInicial = LocalDateTime.of(LocalDate.now().minusDays(ea.getDiasNaEtapa().intValue()), LocalTime.MIN);
                    LocalDateTime dataFinal = LocalDateTime.of(LocalDate.now().minusDays(ea.getDiasNaEtapa().intValue()), LocalTime.MAX);
                    HashSet<Long> ids = new HashSet<Long>();
                    for (String id : ea.getPedidoEtapaIds().split(",")) {
                        if (id.isBlank()) continue;
                        ids.add(Long.valueOf(id));
                    }
                    List pedidos = this.pedidoRepository.findByEtapaAndAtualizacao(ea.getEstruturaUsuario().getEstrutura(), dataInicial, dataFinal, ids);
                    for (PedidoEtapaDTO p : pedidos) {
                        this.send(eu, ea, p.getNumero());
                        SleepUtil.inSeconds((Integer)3);
                    }
                    continue;
                }
                if (!ea.getTipo().equals((Object)EmailAtividadeTipoEnum.CLIENTES)) continue;
                Set vencimentos = this.clienteVencimentoService.getByDia(eu.getEstrutura(), Integer.valueOf(LocalDate.now().getDayOfMonth()), LocalDate.now(), LocalDate.now());
                for (ClienteVencimento cv : vencimentos) {
                    this.sendVencimento(eu, eaCliente, cv, "");
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }
}

