/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioPermissaoDTO;
import br.com.system.app.features.estrutura.dto.PermissaoFilterEnum;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.security.Roles;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Route(value="permissoes", layout=MainLayout.class)
@PageTitle(value="Permiss\u00f5es")
@RolesAllowed(value={"PERMISSOES_VIEW"})
public class PermissoesView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuarioService euService;
    private Grid<EstruturaUsuarioPermissaoDTO> gridEu;
    private RadioButtonGroup<PermissaoFilterEnum> rb;
    private List<EstruturaUsuarioPermissaoDTO> lista;
    private String rulesSelected;
    private TextField filterName;
    private ComboBox<UsuarioPerfilEnum> perfil;

    public PermissoesView(EstruturaUsuarioService euService) {
        this.euService = euService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.create());
        }
    }

    public VerticalContainer create() {
        VerticalContainer mainContainer = new VerticalContainer(new Component[0]);
        mainContainer.setWidthFull();
        this.gridEu = new Grid(EstruturaUsuarioPermissaoDTO.class);
        Button btnFilter = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Filtrar");
        btnFilter.addClickListener((ComponentEventListener & Serializable)e -> this.povoaUsuarios());
        this.filterName = new TextField();
        this.filterName.setPlaceholder("Login Usu\u00e1rio");
        this.filterName.setSuffixComponent((Component)btnFilter);
        this.filterName.setWidth("400px");
        this.filterName.setClearButtonVisible(true);
        ComboBox cbRules = new ComboBox();
        cbRules.setLabel("Permiss\u00e3o");
        cbRules.setItems((Collection)new Roles().getAll());
        cbRules.setWidth("400px");
        this.rb = new RadioButtonGroup();
        this.rb.setItems((Object[])PermissaoFilterEnum.values());
        this.rb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaUsuarios());
        this.rb.setValue((Object)PermissaoFilterEnum.TODOS);
        this.perfil = new ComboBox("Perfil", (Object[])UsuarioPerfilEnum.values());
        this.perfil.setItemLabelGenerator(Enum::name);
        this.perfil.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaUsuarios());
        UIUtils.setFontSize((FontSize)FontSize.S, (Component[])new Component[]{this.rb});
        Button btnAtribuirTodos = UIUtils.createSmallButton((String)"Atribuir Todos", (VaadinIcon)VaadinIcon.FILE_ADD, (String)"Atribuir permiss\u00e3o a todos os usu\u00e1rios");
        btnAtribuirTodos.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.lista.size() <= 0) {
                this.showNotification("Nao h\u00e1 nada selecionado");
            }
            String msg = "Confirma atribui\u00e7\u00e3o da permiss\u00e3o de todos os usu\u00e1rios?";
            ConfirmationDialog confirm = new ConfirmationDialog("Altera\u00e7\u00e3o nas Permiss\u00e3o", msg);
            confirm.getCancel().addClickListener((ComponentEventListener & Serializable)bc -> confirm.close());
            confirm.getConfirm().addClickListener((ComponentEventListener & Serializable)c -> {
                confirm.close();
                this.all(Boolean.valueOf(true));
            });
        });
        Button btnRevogarTodos = UIUtils.createSmallButton((String)"Revogar Todos", (VaadinIcon)VaadinIcon.FILE_REMOVE, (String)"Revogar permiss\u00e3o de todos os usu\u00e1rios");
        btnRevogarTodos.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.lista.size() <= 0) {
                this.showNotification("Nao h\u00e1 nada selecionado");
            }
            String msg = "Confirma revoga\u00e7\u00e3o da permiss\u00e3o de todos os usu\u00e1rios?";
            ConfirmationDialog confirm = new ConfirmationDialog("Altera\u00e7\u00e3o nas Permiss\u00e3o", msg);
            confirm.getCancel().addClickListener((ComponentEventListener & Serializable)bc -> confirm.close());
            confirm.getConfirm().addClickListener((ComponentEventListener & Serializable)c -> {
                confirm.close();
                this.all(Boolean.valueOf(false));
            });
        });
        this.gridEu.setColumns(new String[0]);
        this.gridEu.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Checkbox cb = new Checkbox(this.checkPermission(eg));
            cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.changePermission(eg.getEstruturaId(), ((Boolean)e.getValue()).booleanValue()));
            return cb;
        })).setFlexGrow(0).setWidth("80px").setHeader("Alterar");
        this.gridEu.addColumn("login").setFlexGrow(0).setHeader("Login").setWidth("300px");
        this.gridEu.addColumn("perfil").setFlexGrow(0).setHeader("Perfil").setWidth("200px");
        this.gridEu.addColumn("rules").setHeader("Permiss\u00f5es").setFlexGrow(0).setWidth("450px");
        cbRules.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.rulesSelected = (String)e.getValue();
            this.povoaUsuarios();
        });
        FlexBoxLayout footer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]).setSpacingM();
        footer.add(new Component[]{btnAtribuirTodos, btnRevogarTodos});
        footer.setAlignItems(FlexComponent.Alignment.BASELINE);
        mainContainer.add(new Component[]{cbRules, this.rb, this.perfil, this.filterName, this.gridEu, footer});
        return mainContainer;
    }

    private void all(Boolean ativar) {
        HashSet op = new HashSet();
        this.lista.forEach(e -> op.add(e.getEstruturaId()));
        this.euService.updatePermission(op, this.rulesSelected, ativar);
        this.povoaUsuarios();
    }

    private void changePermission(Long id, boolean ativar) {
        HashSet<Long> op = new HashSet<Long>();
        op.add(id);
        this.euService.updatePermission(op, this.rulesSelected, Boolean.valueOf(ativar));
    }

    private boolean checkPermission(EstruturaUsuarioPermissaoDTO permissao) {
        return Arrays.asList(permissao.getRules().split(",")).contains(this.rulesSelected);
    }

    private void povoaUsuarios() {
        if (this.rulesSelected == null) {
            this.gridEu.setItems(new ArrayList());
        } else {
            boolean justActive = ((PermissaoFilterEnum)this.rb.getValue()).equals((Object)PermissaoFilterEnum.TODOS);
            this.lista = this.euService.getEstruturaUsuarioPermission(this.getEu(), this.rulesSelected, (PermissaoFilterEnum)this.rb.getValue(), this.filterName.getValue(), (UsuarioPerfilEnum)this.perfil.getValue(), Boolean.valueOf(justActive));
            this.gridEu.setItems((Collection)this.lista);
        }
    }
}

