/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.externalrequest;

import java.util.HashMap;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class ExternalRequest {
    private final Map<String, String> parameters = new HashMap();
    private final Map<String, String> headers = new HashMap();
    private final OkHttpClient client = new OkHttpClient();
    private final FormBody.Builder form = new FormBody.Builder();
    private Response response;

    public ExternalRequest() {
        this.headers.put("Accept", "*/*");
        this.headers.put("Accept-Charset", "utf-8");
        this.headers.put("Accept-Encoding", "gzip, deflate, br");
    }

    public ExternalRequest sendFile(String url, byte[] file) throws Exception {
        this.client.newBuilder().build();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("", "", RequestBody.create((byte[])file)).build();
        Request request = new Request.Builder().url(url).headers(Headers.of((Map)this.headers)).method("POST", (RequestBody)body).build();
        this.response = this.client.newCall(request).execute();
        return this;
    }

    public ExternalRequest sendGet(String url) throws Exception {
        this.client.newBuilder().build();
        Request request = new Request.Builder().url(url).headers(Headers.of((Map)this.headers)).build();
        this.response = this.client.newCall(request).execute();
        return this;
    }

    public ExternalRequest sendJsonPost(String url, JSONObject json) throws Exception {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)json.toString(), (MediaType)mediaType);
        Request request = new Request.Builder().url(url).post(body).build();
        this.response = this.client.newCall(request).execute();
        return this;
    }

    public ExternalRequest sendPost(String url) throws Exception {
        FormBody body = this.getFormBody();
        Request request = new Request.Builder().url(url).headers(Headers.of((Map)this.headers)).post((RequestBody)body).build();
        this.response = this.client.newCall(request).execute();
        return this;
    }

    public String getStringResult() throws Exception {
        if (this.response == null || this.response.body() == null) {
            throw new Exception("Body is null");
        }
        return this.response.body() == null ? "" : this.response.body().toString();
    }

    public JSONObject getJsonResult() throws Exception {
        try {
            return new JSONObject(this.response.body().string());
        }
        catch (Exception e) {
            JSONObject j = new JSONObject();
            j.put("erro", (Object)e.getMessage());
            return j;
        }
    }

    public ExternalRequest addHeader(String nome, String valor) {
        this.headers.put(nome, valor);
        return this;
    }

    public ExternalRequest addParameter(String nome, String valor) {
        this.parameters.put(nome, valor);
        return this;
    }

    private FormBody getFormBody() {
        for (Map.Entry m : this.parameters.entrySet()) {
            this.form.addEncoded((String)m.getKey(), (String)m.getValue());
        }
        return this.form.build();
    }
}

