/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.importacoes.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.importacoes.model.Importacoes;
import br.com.system.app.features.importacoes.model.ImportacoesCampoEnum;
import br.com.system.app.features.importacoes.service.ImportacaoUtil;
import br.com.system.app.features.importacoes.service.RevisaoStatus;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VivoPedidoImportacaoStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private PedidoItemService pedidoItemService;
    private final ImportacaoUtil util = new ImportacaoUtil();

    private boolean validar(String[] linhas, List<Importacoes> colunas) {
        try {
            String[] cols = linhas[0].split(",");
            for (Importacoes col : colunas) {
                boolean achou = false;
                for (int i = 0; i < cols.length; ++i) {
                    if (!cols[i].equals(col.getNome())) continue;
                    achou = true;
                    break;
                }
                if (achou) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String atualizarStatus(EstruturaUsuario eu, String[] linhas, List<Importacoes> colunas) {
        if (!this.validar(linhas, colunas)) {
            return "Arquivo inv\u00e1lido";
        }
        EstruturaUsuario master = this.eus.getMasterEstrutura(eu.getEstrutura());
        Object log = "";
        Integer posicaoPedido = -1;
        Integer posicaoStatus = -1;
        Integer posicaoRevision = -1;
        String[] cab = linhas[0].split(",");
        for (int i = 0; i < cab.length; ++i) {
            String c = cab[i];
            if (c.equals(this.util.get(ImportacoesCampoEnum.NRO_PEDIDO, colunas).getNome())) {
                posicaoPedido = i;
            }
            if (c.equals(this.util.get(ImportacoesCampoEnum.STATUS_PEDIDO, colunas).getNome())) {
                posicaoStatus = i;
            }
            if (!c.equals(this.util.get(ImportacoesCampoEnum.REVISION, colunas).getNome())) continue;
            posicaoRevision = i;
        }
        if (posicaoPedido < 0 || posicaoStatus < 0 || posicaoRevision < 0) {
            throw new BusinessException("Nao localizei as colunas Numero de pEdido e Status Pedido e Revis\u00e3o");
        }
        HashMap<String, RevisaoStatus> mapPedidos = new HashMap<String, RevisaoStatus>();
        for (String linha : linhas) {
            String[] cols = StringUtil.getCols((String)linha, (String)",");
            String numeroPedido = cols[posicaoPedido];
            String statusPedido = cols[posicaoStatus];
            Integer revision = StringUtil.toInt((String)cols[posicaoRevision]);
            if (numeroPedido.equals(this.util.get(ImportacoesCampoEnum.NRO_PEDIDO, colunas).getNome())) continue;
            RevisaoStatus rs = (RevisaoStatus)mapPedidos.get(numeroPedido);
            if (rs == null) {
                rs = new RevisaoStatus();
                rs.setRevisao(revision);
                rs.setStatus(statusPedido);
                mapPedidos.put(numeroPedido, rs);
                continue;
            }
            if (rs.getRevisao() >= revision) continue;
            rs.setRevisao(revision);
            rs.setStatus(statusPedido);
            mapPedidos.put(numeroPedido, rs);
        }
        for (Map.Entry entry : mapPedidos.entrySet()) {
            try {
                Pedido atividade;
                PedidoEtapa pe;
                PedidoEtapa pe2;
                String numeroPedido = (String)entry.getKey();
                String statusPedido = ((RevisaoStatus)entry.getValue()).getStatus();
                if (numeroPedido.isEmpty() || statusPedido.isEmpty()) continue;
                log = (String)log + "Pedido: " + numeroPedido + " " + statusPedido;
                boolean atualizou = false;
                Pedido pedido = this.pedidoService.getByNumeroAndEstrutura(numeroPedido, eu.getEstrutura());
                if (pedido != null && (pe2 = this.pedidoEtapaService.getByNome(eu.getEstrutura(), statusPedido, pedido.getPedidoOrigem(), pedido.getPedidoTipo())) != null && !pe2.getId().equals(pedido.getPedidoEtapa().getId())) {
                    this.atualizar(pedido, pe2, master);
                    atualizou = true;
                }
                List listaOrigem = this.pedidoService.getByNumeroVinculado(eu.getEstrutura(), numeroPedido);
                for (Pedido origem : listaOrigem) {
                    pe = this.pedidoEtapaService.getByNome(eu.getEstrutura(), statusPedido, origem.getPedidoOrigem(), origem.getPedidoTipo());
                    if (pe == null || pe.getId().equals(origem.getPedidoEtapa().getId())) continue;
                    this.atualizar(origem, pe, master);
                    atualizou = true;
                }
                Pedido pedidoCotacao = this.pedidoService.getPedidoByNumeroCotacao(eu, numeroPedido);
                if (pedidoCotacao != null && pedido == null && ((atividade = this.pedidoService.getByNumeroAndEstrutura(pedidoCotacao.getNumero(), eu.getEstrutura())).getNumeroPedidoVinculado() == null || atividade.getNumeroPedidoVinculado().isEmpty()) && (pe = this.pedidoEtapaService.getByNome(eu.getEstrutura(), statusPedido, pedidoCotacao.getPedidoOrigem(), pedidoCotacao.getPedidoTipo())) != null && !pe.getId().equals(pedidoCotacao.getPedidoEtapa().getId())) {
                    this.atualizar(pedidoCotacao, pe, master);
                    atualizou = true;
                }
                log = (String)log + (atualizou ? " Atualizado\n" : " N\u00e3o atualizado\n");
            }
            catch (Exception e) {
                log = (String)log + " ERRO: " + e.getMessage();
            }
        }
        return log;
    }

    private void atualizar(Pedido origem, PedidoEtapa pe, EstruturaUsuario master) {
        String msg = "Atualizado de " + origem.getPedidoEtapa().getNome() + " para " + pe.getNome();
        origem.setPedidoEtapa(pe);
        origem.setDataHoraUltimaMov(LocalDateTime.now());
        this.pedidoService.salvar(origem, msg, master, false);
        if (pe.getAtualizaDataReferencia().booleanValue()) {
            this.pedidoItemService.updateData(origem.getId(), LocalDate.now());
        }
    }
}

