/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.login;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.login.service.DoisFatoresService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.commons.QrCodeUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.AbstractStreamResource;
import java.io.Serializable;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base32;

public class DoisFatoresView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final DoisFatoresService dfs;
    private boolean autenticado;

    public DoisFatoresView(DoisFatoresService dfs) {
        this.dfs = dfs;
        this.autenticado = false;
    }

    public boolean isAutenticado() {
        return this.autenticado;
    }

    public void create(String sc, Usuario u, boolean showQrcode, boolean closeButton) {
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        Button btn = UIUtils.createButton((String)"Autenticar", (String)"Autenticar seu c\u00f3digo", (ButtonVariant[])new ButtonVariant[0]);
        btn.setDisableOnClick(true);
        Button btnClose = UIUtils.createCloseButton();
        btnClose.setVisible(closeButton);
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> {
            this.autenticado = false;
            this.close();
        });
        TextField doisaf = new TextField("Digite codigo de 2 fatores");
        doisaf.addKeyDownListener(Key.ENTER, (ComponentEventListener & Serializable)keyDownEvent -> btn.click(), new KeyModifier[0]);
        doisaf.setAutofocus(true);
        btn.addClickListener((ComponentEventListener & Serializable)ex -> {
            if (!this.dfs.autenticar(doisaf.getValue(), sc)) {
                btn.setEnabled(true);
                UIUtils.showNotification((String)"C\u00f3digo de autentica\u00e7\u00e3o de dois fatores inv\u00e1lido.");
                return;
            }
            this.autenticado = true;
            this.dfs.cancelar(u);
            this.close();
        });
        VerticalContainer v = new VerticalContainer(new Component[0]);
        if (showQrcode) {
            v.add(new Component[]{this.getQrCode(sc, u)});
        } else {
            v.add(new Component[]{UIUtils.createHeader((String)"Autentica\u00e7\u00e3o de 2 fatores")});
        }
        v.add(new Component[]{doisaf, new FooterContainer(new Component[]{btnClose, btn})});
        this.add(new Component[]{v});
        this.open();
    }

    private VerticalContainer getQrCode(String sc, Usuario u) {
        Base32 base32 = new Base32();
        sc = base32.encodeToString(sc.getBytes());
        VerticalContainer main = new VerticalContainer(new Component[0]);
        main.add(new Component[]{UIUtils.createHeader((String)"QR CODE AUTENTICA\u00c7\u00c3O")});
        TextField txtKey = new TextField("Sua Chave(N\u00e3o compartilhe)");
        txtKey.setReadOnly(true);
        txtKey.setValue(sc);
        txtKey.setWidthFull();
        main.add(new Component[]{txtKey});
        try {
            String login = u.isMaster() ? "master@neocrm" : u.getLogin();
            String url = "otpauth://totp/" + URLEncoder.encode(login + ":NEO SALES", "UTF-8").replace("+", "%20") + "?secret=" + URLEncoder.encode(sc, "UTF-8").replace("+", "%20") + "&issuer=" + URLEncoder.encode(login, "UTF-8").replace("+", "%20");
            Image i = new Image((AbstractStreamResource)QrCodeUtil.getQrCode((String)url), "QR CODE");
            i.setWidth("300px");
            i.setHeight("300px");
            main.add(new Component[]{i});
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao criar QR CODE");
        }
        return main;
    }

    public static void main(String[] args) {
        try {
            String sc = "b6668ff4-2121-45d2-ab23-951a7dc5207f8";
            Base32 base32 = new Base32();
            System.out.println(base32.encodeToString(sc.getBytes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

