/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.login;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.login.service.DoisFatoresService;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnum;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnvioEnum;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.service.UsuarioConfirmacaoService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import java.io.Serializable;

@AnonymousAllowed
@PageTitle(value="Login")
@Route(value="login")
public class LoginView
extends VerticalLayout
implements BeforeEnterObserver,
SecurityContext {
    private static final long serialVersionUID = 1L;
    private final DoisFatoresService doisFatoresService;
    private final UsuarioConfirmacaoService usuarioConfirmacaoService;
    private final UsuarioService usuarioService;
    private final ConfigurationsService configurationsService;
    private final EstruturaComplementoService estruturaComplementoService;
    private TextField txtLogin;
    private PasswordField txtSenha;
    private RadioButtonGroup<String> rb;
    private TextField txtCodigo;
    private Div divErro;
    private Button btnLogar;
    private Anchor anchorForget;
    private Anchor anchorHelp;

    public LoginView(DoisFatoresService doisFatoresService, UsuarioConfirmacaoService usuarioConfirmacaoService, UsuarioService usuarioService, ConfigurationsService configurationsService, EstruturaComplementoService estruturaComplementoService) {
        this.usuarioService = usuarioService;
        this.estruturaComplementoService = estruturaComplementoService;
        this.configurationsService = configurationsService;
        this.doisFatoresService = doisFatoresService;
        this.usuarioConfirmacaoService = usuarioConfirmacaoService;
        this.getElement().getThemeList().add((Object)"dark");
        this.getStyle().set("background-size", "cover");
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.setWidthFull();
        this.setHeightFull();
        this.create();
    }

    private void create() {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setPadding(true);
        mainContainer.setSpacing(true);
        mainContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        mainContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        mainContainer.add(new Component[]{this.getForm()});
        this.add(new Component[]{mainContainer});
    }

    private VerticalLayout getForm() {
        this.divErro = new Div();
        this.divErro.setVisible(false);
        this.divErro.setWidthFull();
        this.divErro.addClassNames(new String[]{"text-error", "items-center", "text-xs"});
        this.txtLogin = new TextField("Login");
        this.txtLogin.setId("txtLogin");
        this.txtLogin.setWidthFull();
        this.txtLogin.addFocusListener((ComponentEventListener & Serializable)e -> this.setError(""));
        this.txtSenha = new PasswordField("Senha");
        this.txtSenha.setWidthFull();
        this.txtSenha.setId("txtSenha");
        this.txtSenha.addFocusListener((ComponentEventListener & Serializable)e -> this.setError(""));
        this.rb = new RadioButtonGroup("Modo de Autenticao");
        this.rb.setId("rbTipoAutenticacao");
        if (this.configurationsService.get(ConfigurationEnum.AUTENTICACAO_SMS).isTrue().booleanValue()) {
            this.rb.setItems((Object[])new String[]{"Autenticador", "E-mail", "SMS"});
        } else {
            this.rb.setItems((Object[])new String[]{"Autenticador", "E-mail"});
        }
        this.rb.setValue((Object)"Autenticador");
        this.rb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (null != e.getValue()) {
                switch ((String)e.getValue()) {
                    case "Whatsapp": {
                        this.usuarioConfirmacaoService.sendForLogin(this.txtLogin.getValue(), UsuarioConfirmacaoTipoEnvioEnum.WHATSAPP);
                        UIUtils.showNotification((String)"Enviado via WHATSAPP com sucesso");
                        break;
                    }
                    case "SMS": {
                        this.usuarioConfirmacaoService.sendForLogin(this.txtLogin.getValue(), UsuarioConfirmacaoTipoEnvioEnum.SMS);
                        UIUtils.showNotification((String)"Enviado via SMS com sucesso");
                        break;
                    }
                    case "E-mail": {
                        this.usuarioConfirmacaoService.sendForLogin(this.txtLogin.getValue(), UsuarioConfirmacaoTipoEnvioEnum.EMAIL);
                        UIUtils.showNotification((String)"Enviado via E-MAIL com sucesso");
                        break;
                    }
                    default: {
                        UIUtils.showNotification((String)"Tipo de envio nao identificado?");
                    }
                }
            }
        });
        this.txtCodigo = new TextField("Codigo 2FA");
        this.txtCodigo.setId("txtCodigo");
        this.txtCodigo.setWidthFull();
        this.txtCodigo.addFocusListener((ComponentEventListener & Serializable)e -> this.setError(""));
        this.txtCodigo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.setError("");
            if (this.txtCodigo.getValue().length() == 6) {
                this.btnLogar.clickInClient();
            }
        });
        this.btnLogar = UIUtils.createButton((String)"Logar", (String)"Logar", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.btnLogar.setDisableOnClick(true);
        this.btnLogar.setId("btnLogar");
        this.btnLogar.setWidthFull();
        this.btnLogar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.logar();
            this.btnLogar.setEnabled(true);
        });
        this.anchorForget = new Anchor("recuperar-acesso", "Recuperar Meu Acesso");
        this.anchorHelp = new Anchor("https://wa.me/554741080413", "Precisa de ajuda? Clique aqui");
        this.anchorHelp.setTarget("_blank");
        VerticalLayout lay = this.getContainer();
        lay.addClassName("rounded-l");
        lay.add(new Component[]{this.divErro, this.txtLogin, this.txtSenha, this.rb, this.txtCodigo, this.btnLogar, this.anchorForget, this.anchorHelp});
        return lay;
    }

    private void logar() {
        try {
            if (this.configurationsService.get(ConfigurationEnum.MANUTENCAO).getValor().equals("true")) {
                UIUtils.showNotification((String)"Estamos em manutencao, por favor tente mais tarde");
                return;
            }
            this.validarFormulario();
            this.validar2fa();
            this.usuarioService.autenticar(this.txtLogin.getValue(), this.txtSenha.getValue());
            if (this.estruturaComplementoService.getComplementos(this.getEstrutura()).getCobrancaAssinatura().isInadimplente() && (this.hasPermission("COBRANCA_VIEW") || this.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO))) {
                UI.getCurrent().navigate("cobranca");
                return;
            }
            UI.getCurrent().navigate("home");
        }
        catch (Exception ex) {
            this.setError(ex.getMessage());
        }
    }

    private void validarFormulario() throws Exception {
        Object erro = "";
        if (this.txtLogin.getValue().isEmpty()) {
            erro = (String)erro + "Informe seu Login<BR>";
        }
        if (this.txtSenha.getValue().isEmpty()) {
            erro = (String)erro + "Informe sua Senha<BR>";
        }
        if (!((String)erro).isEmpty()) {
            throw new Exception((String)erro);
        }
    }

    private void setError(String erro) {
        if (erro.isEmpty()) {
            this.divErro.setVisible(false);
        } else {
            this.divErro.getElement().setProperty("innerHTML", "<span><center>" + erro + "</center></span>");
            this.divErro.setVisible(true);
        }
    }

    private VerticalLayout getContainer() {
        VerticalLayout lay = new VerticalLayout();
        lay.getStyle().set("background-color", "var(--lumo-shade-90pct)");
        lay.setMaxWidth("350px");
        lay.setAlignItems(FlexComponent.Alignment.CENTER);
        lay.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        return lay;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        EstruturaUsuario eu = this.getEu();
        if (eu != null && eu.isAtivo()) {
            event.forwardTo("");
        }
        UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> this.setWidthScreen(Integer.valueOf(details.getBodyClientWidth())));
        if (event.getLocation().getQueryParameters().getParameters().containsKey("error")) {
            this.setError("Erro ao logar");
        }
    }

    private void validar2fa() throws Exception {
        if (!("Autenticador".equals(this.rb.getValue()) || "Whatsapp".equals(this.rb.getValue()) || "SMS".equals(this.rb.getValue()) || "E-mail".equals(this.rb.getValue()))) {
            throw new Exception("Selecione um tipo de 2fa");
        }
        if ("Autenticador".equals(this.rb.getValue())) {
            String msg = this.doisFatoresService.authByLogin(this.txtCodigo.getValue(), this.txtLogin.getValue());
            if (!msg.isEmpty()) {
                UIUtils.showNotification((String)msg);
            }
        } else if ("Whatsapp".equals(this.rb.getValue()) || "SMS".equals(this.rb.getValue())) {
            this.usuarioConfirmacaoService.isValidLogin(this.txtLogin.getValue(), this.txtCodigo.getValue(), UsuarioConfirmacaoTipoEnum.TELEFONE);
        } else if ("E-mail".equals(this.rb.getValue())) {
            this.usuarioConfirmacaoService.isValidLogin(this.txtLogin.getValue(), this.txtCodigo.getValue(), UsuarioConfirmacaoTipoEnum.EMAIL);
        }
    }
}

