/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.mailing.model;

import br.com.system.app.features.mailing.model.MailingAtividade;
import br.com.system.app.features.mailing.model.MailingContato;
import br.com.system.app.features.mailing.model.MailingSocio;
import br.com.system.app.features.shared.model.IEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate
@Table(name="mailing")
public class Mailing
implements IEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    private String nome;
    @NotNull
    private String cpfCnpj;
    @NotNull
    @OneToMany(mappedBy="mailing", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=MailingAtividade.class)
    private Set<MailingAtividade> atividades = new HashSet();
    @NotNull
    @OneToMany(mappedBy="mailing", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=MailingContato.class)
    private Set<MailingContato> contatos = new HashSet();
    @NotNull
    @OneToMany(mappedBy="mailing", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=MailingSocio.class)
    private Set<MailingSocio> socios = new HashSet();
    private LocalDateTime dataHoraAtualizacao;
    private String situacao;
    private LocalDate dataSituacao;
    private LocalDate dataAbertura;
    private String naturezaJuridica;
    private String matrizFilial;
    private String nomeFantasia;
    private String situacaoEspecial;
    private String motivoSituacaoEspecial;
    private LocalDate dataSituacaoEspecial;
    private BigDecimal capitalSocial;
    private String porte;
    private String opcaoSimples;
    private LocalDate dataOpcaoSimples;
    private LocalDate dataExclusaoSimples;
    private String opcaoMei;
    private String cep;
    private String logradouro;
    private String numero;
    private String complemento;
    private String bairro;
    private String cidade;
    private String estado;
    private Integer ddd;

    @PrePersist
    public void prePersist() {
        this.contatos.forEach(contato -> contato.setMailing(this));
        this.atividades.forEach(atividade -> atividade.setMailing(this));
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public Set<MailingAtividade> getAtividades() {
        return this.atividades;
    }

    public void setAtividades(Set<MailingAtividade> atividades) {
        this.atividades = atividades;
    }

    public Set<MailingContato> getContatos() {
        return this.contatos;
    }

    public void setContatos(Set<MailingContato> contatos) {
        this.contatos = contatos;
    }

    public Set<MailingSocio> getSocios() {
        return this.socios;
    }

    public void setSocios(Set<MailingSocio> socios) {
        this.socios = socios;
    }

    public LocalDateTime getDataHoraAtualizacao() {
        return this.dataHoraAtualizacao;
    }

    public void setDataHoraAtualizacao(LocalDateTime dataHoraAtualizacao) {
        this.dataHoraAtualizacao = dataHoraAtualizacao;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    public String getNaturezaJuridica() {
        return this.naturezaJuridica;
    }

    public void setNaturezaJuridica(String naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica;
    }

    public String getMatrizFilial() {
        return this.matrizFilial;
    }

    public void setMatrizFilial(String matrizFilial) {
        this.matrizFilial = matrizFilial;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getSituacaoEspecial() {
        return this.situacaoEspecial;
    }

    public void setSituacaoEspecial(String situacaoEspecial) {
        this.situacaoEspecial = situacaoEspecial;
    }

    public String getMotivoSituacaoEspecial() {
        return this.motivoSituacaoEspecial;
    }

    public void setMotivoSituacaoEspecial(String motivoSituacaoEspecial) {
        this.motivoSituacaoEspecial = motivoSituacaoEspecial;
    }

    public LocalDate getDataSituacaoEspecial() {
        return this.dataSituacaoEspecial;
    }

    public void setDataSituacaoEspecial(LocalDate dataSituacaoEspecial) {
        this.dataSituacaoEspecial = dataSituacaoEspecial;
    }

    public BigDecimal getCapitalSocial() {
        return this.capitalSocial;
    }

    public void setCapitalSocial(BigDecimal capitalSocial) {
        this.capitalSocial = capitalSocial;
    }

    public String getPorte() {
        return this.porte;
    }

    public void setPorte(String porte) {
        this.porte = porte;
    }

    public String getOpcaoSimples() {
        return this.opcaoSimples;
    }

    public void setOpcaoSimples(String opcaoSimples) {
        this.opcaoSimples = opcaoSimples;
    }

    public LocalDate getDataOpcaoSimples() {
        return this.dataOpcaoSimples;
    }

    public void setDataOpcaoSimples(LocalDate dataOpcaoSimples) {
        this.dataOpcaoSimples = dataOpcaoSimples;
    }

    public LocalDate getDataExclusaoSimples() {
        return this.dataExclusaoSimples;
    }

    public void setDataExclusaoSimples(LocalDate dataExclusaoSimples) {
        this.dataExclusaoSimples = dataExclusaoSimples;
    }

    public String getOpcaoMei() {
        return this.opcaoMei;
    }

    public void setOpcaoMei(String opcaoMei) {
        this.opcaoMei = opcaoMei;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public Integer getDdd() {
        return this.ddd;
    }

    public void setDdd(Integer ddd) {
        this.ddd = ddd;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.cpfCnpj);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mailing other = (Mailing)obj;
        return Objects.equals(this.cpfCnpj, other.cpfCnpj);
    }
}

