/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing.service;

import br.com.system.app.features.marketing.model.Marketing;
import br.com.system.app.features.marketing.model.MarketingItem;
import br.com.system.app.features.marketing.model.MarketingItemCampos;
import br.com.system.app.features.marketing.model.MarketingItemStatus;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.marketing.service.MarketingWebhook;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppRecebimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.features.whatsapp.service.WhatsAppStatusService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import com.vdurmont.emoji.EmojiParser;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketingWebhook
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(MarketingWebhook.class);
    @Autowired
    private MarketingService marketingService;
    @Autowired
    private WhatsAppService whatsappService;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppRecebimentoService whatsAppRecebimentoService;
    @Autowired
    private WhatsAppStatusService whatsAppStatusService;

    public void webhook(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        JSONObject jsonBody = null;
        try {
            MarketingItem item;
            String token = request.getParameter("token");
            if (!token.equals("6262f94f0c79dedb1fda444dc283ec8b531087b412dc2ffa20a4cbf5300eeed7")) {
                this.printErro("Token invalido", out);
                return;
            }
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                this.printErro("Body is empty", out);
                return;
            }
            jsonBody = new JSONObject(body);
            this.emojiToDecimal(jsonBody);
            MarketingItemStatus status = MarketingItemStatus.valueOf((String)jsonBody.getString("status"));
            WhatsAppConta wc = this.whatsappContaService.getContaByMoorseId(jsonBody.getString("integrationId"));
            if (status.equals((Object)MarketingItemStatus.RESPONDIDA)) {
                String msg;
                if (wc == null) {
                    return;
                }
                item = this.marketingService.getByNumeroWhats(wc.getEstrutura(), jsonBody.getString("from"));
                if (item == null || item.getDataHoraEnvio() == null || item.getDataHoraEnvio().plusMonths(1L).isBefore(LocalDate.now().atStartOfDay())) {
                    this.whatsAppRecebimentoService.respondido(jsonBody, wc);
                    return;
                }
                item.setStatus(MarketingItemStatus.RESPONDIDA);
                String string = msg = jsonBody.has("content") && !jsonBody.getString("content").isEmpty() ? jsonBody.getString("content") : "";
                if (item.getMarketing().getAtendente() != null) {
                    WhatsApp w = this.whatsappService.getByNumeroAndConta(item.getNumeroWhats(), wc);
                    if (w != null && w.getEtapa().equals((Object)WhatsAppEtapaEnum.ATENDENTE)) {
                        this.whatsAppRecebimentoService.respondido(jsonBody, wc);
                        return;
                    }
                    this.criarChamado(jsonBody, item, msg, (WhatsAppConta)(wc.isAtendimento() ? wc : null));
                }
                item.setRespostas((String)(item.getRespostas() == null ? msg : item.getRespostas() + ", " + msg));
            } else {
                item = this.marketingService.getItemByMessageId(jsonBody.optString("id"));
                if (item == null) {
                    if (status.equals((Object)MarketingItemStatus.ERROR)) {
                        this.whatsAppRecebimentoService.errorReceived(jsonBody);
                        return;
                    }
                    this.whatsAppStatusService.controlar(jsonBody);
                    return;
                }
                switch (1.$SwitchMap$br$com$system$app$features$marketing$model$MarketingItemStatus[status.ordinal()]) {
                    case 1: {
                        item.setDataHoraEnvio(LocalDateTime.now());
                        break;
                    }
                    case 2: {
                        item.setDataHoraLeitura(LocalDateTime.now());
                        break;
                    }
                    case 3: {
                        item.setDataHoraRecebimento(LocalDateTime.now());
                        break;
                    }
                    default: {
                        this.printErro("Status invalido", out);
                        return;
                    }
                }
            }
            item.setStatus(status);
            this.marketingService.saveItem(item);
            this.printSucesso(out);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private void emojiToDecimal(JSONObject jsonBody) {
        try {
            JSONObject j;
            if (jsonBody.has("content") || !jsonBody.isNull("content")) {
                jsonBody.put("content", (Object)EmojiParser.parseToHtmlDecimal((String)jsonBody.getString("content")));
            }
            if (jsonBody.has("contactUser") && (j = jsonBody.getJSONObject("contactUser")).has("name") && !j.isNull("name")) {
                j.put("name", (Object)EmojiParser.parseToHtmlDecimal((String)j.getString("name")));
                jsonBody.put("contactUser", (Object)j);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private void printSucesso(PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", true);
        jsonRetorno.put("erro", (Object)"");
        out.print(jsonRetorno.toString());
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private void criarChamado(JSONObject body, MarketingItem item, String resposta, WhatsAppConta wc) {
        try {
            WhatsApp w;
            if (wc == null) {
                List contas = this.whatsappContaService.getContaByEstruturaAtendimento(item.getMarketing().getEstruturaUsuario().getEstrutura());
                if (contas.size() <= 0) {
                    return;
                }
                wc = (WhatsAppConta)contas.get(0);
            }
            if ((w = this.whatsappService.getByNumeroAndConta(item.getNumeroWhats(), wc)) == null) {
                List campos = this.marketingService.getCampos(item);
                String cnpj = "";
                String nome = "";
                if (!campos.isEmpty()) {
                    for (MarketingItemCampos mic : campos) {
                        if ((mic.getCampo().toUpperCase().contains("#CNPJ") || mic.getCampo().toUpperCase().contains("#CPF") || mic.getCampo().toUpperCase().contains("#CPFCNPJ")) && ValidationUtil.isValidCnpjAndCpf((String)mic.getValor())) {
                            cnpj = StringUtil.numbersOnly((String)mic.getValor());
                        }
                        if (!mic.getCampo().toUpperCase().contains("#NOME")) continue;
                        nome = mic.getValor().trim();
                    }
                }
                w = new WhatsApp();
                w.setDataHoraCriacao(LocalDateTime.now());
                w.setNome(nome);
                w.setCnpjEscolhido(cnpj);
                w.setNumero(item.getNumeroWhats());
                w.setWhatsappConta(wc);
            }
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            w.setUltimoAtendente(item.getMarketing().getAtendente().getEstruturaUsuario());
            w = this.whatsappService.save(w);
            WhatsAppAtendimento wa = this.whatsAppAtendimentoService.getAndCreate(w, null);
            wa.setAtendente(item.getMarketing().getAtendente().getEstruturaUsuario());
            wa.setDataHoraTransferencia(LocalDateTime.now());
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            wa.setDataHoraUltimaMensagem(LocalDateTime.now());
            wa.setUltimaMensagem(resposta);
            wa = this.whatsAppAtendimentoService.save(wa);
            this.gravarMsgMarketing(body, item, wa);
            this.whatsAppRecebimentoService.respondido(body, wc);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private void gravarMsgMarketing(JSONObject body, MarketingItem item, WhatsAppAtendimento wa) {
        Marketing marketing = item.getMarketing();
        String anotacao = "Atendimento criado via Resposta do Marketing\nNome Campanha: " + marketing.getNomeCampanha() + "\n";
        anotacao = item.getMarketing().getWhatsappTemplate() != null ? anotacao + "Template: " + item.getMarketing().getWhatsappTemplate().getTemplateName() : anotacao + "Mensagem: " + this.marketingService.getMensagem(item);
        WhatsAppMensagem m = this.whatsAppMensagemService.inserirAnotacao(wa, item.getMarketing().getAtendente().getEstruturaUsuario(), anotacao);
        this.whatsAppControleService.gravarNova(m, WhatsAppStatusEnum.LIDA);
        if (body.has("urlFile")) {
            this.whatsAppRecebimentoService.respondido(body, wa.getWhatsapp().getWhatsappConta());
        }
    }
}

