/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.materialapoio;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.materialapoio.model.MaterialApoio;
import br.com.system.app.features.materialapoio.model.MaterialApoioDTO;
import br.com.system.app.features.materialapoio.service.MaterialApoioService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="material-apoio", layout=MainLayout.class)
@PageTitle(value="Material de Apoio")
@RolesAllowed(value={"MATERIAL_APOIO_VIEW"})
public class MaterialApoioView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final MaterialApoioService materialApoioService;
    private GridCrud<MaterialApoioDTO> crud;
    private TextArea ta;
    private MultiComboBox<UsuarioPerfilEnum> cbPerfil;
    private Upload upload;
    private TempFileMultiBuffer mBuffer;

    @Autowired
    public MaterialApoioView(MaterialApoioService materialApoioService) {
        this.materialApoioService = materialApoioService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private void refresh() {
        this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        this.mBuffer.clear();
        this.ta.clear();
        this.crud.refreshGrid();
        this.cbPerfil.clear();
        this.upload.setVisible(true);
    }

    private VerticalContainer createContent() {
        this.ta = new TextArea("Descri\u00e7\u00e3o");
        Button btnSave = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.UPLOAD, (String)"Salvar arquivo");
        btnSave.setEnabled(this.hasPermission("MATERIAL_APOIO_SAVE"));
        btnSave.addClickListener((ComponentEventListener & Serializable)e -> {
            MaterialApoio ma = this.crud.getGrid().getSelectedItems().size() <= 0 ? null : this.materialApoioService.getById(((MaterialApoioDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId());
            HashSet<String> p = new HashSet<String>();
            boolean temmeuperfil = false;
            if (!this.cbPerfil.getValue().isEmpty()) {
                for (UsuarioPerfilEnum u : this.cbPerfil.getValue()) {
                    if (u.equals((Object)this.getEu().getUsuario().getPerfil())) {
                        temmeuperfil = true;
                    }
                    p.add(u.name());
                }
            }
            if (!temmeuperfil && !this.getEu().getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO)) {
                ConfirmationDialog cd = new ConfirmationDialog("Sem Perfil", "Seu perfil n\u00e3o est\u00e1 selecionado, vc n\u00e3o conseguir\u00e1 visualizar este registro. Confirma?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.save(ma, p);
                    cd.close();
                });
            } else {
                this.save(ma, p);
            }
        });
        this.cbPerfil = new MultiComboBox("Perfis Permitidos(Deixe em branco para todos)");
        this.cbPerfil.setItemLabelGenerator(Enum::name);
        this.cbPerfil.setItems((Object[])UsuarioPerfilEnum.values());
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.setHeightFull();
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.createUpload(), this.ta, this.cbPerfil, btnSave}).setSpacingOn()});
        v.add(new Component[]{this.createGrid()});
        return v;
    }

    private void save(MaterialApoio ma, Set<String> p) {
        String perfis = StringUtils.join(p, (String)",");
        if (this.mBuffer.getFiles().size() <= 0) {
            if (ma == null) {
                this.showNotification("Selecione pelo menos um arquivo para UPload.");
                return;
            }
            ma.setDescricao(this.ta.getValue());
            ma.setPerfis(perfis);
            this.materialApoioService.salvar(ma);
            this.showNotification("Salvo com sucesso");
            this.refresh();
        } else {
            try {
                for (String file : this.mBuffer.getFiles()) {
                    InputStream is = this.mBuffer.getInputStream(file);
                    this.materialApoioService.upload(this.getEu(), file, this.ta.getValue(), perfis, is);
                }
                this.showNotification("Arquivo(s) inserido com sucesso");
                this.refresh();
                this.mBuffer.clear();
            }
            catch (Exception ex) {
                this.showNotification(ex.getMessage());
            }
        }
    }

    private Component createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        this.upload = new Upload((Receiver)this.mBuffer);
        this.upload.setMaxFiles(30);
        this.upload.setDropLabel((Component)new Span("Solte aqui"));
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> UIUtils.showNotification((String)"Arquivo carregado, clique em Salvar"));
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        return this.upload;
    }

    private Component createGrid() {
        this.crud = new GridCrud(MaterialApoioDTO.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome arquivo");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeArquivo()))).setHeader("Arquivo").setFlexGrow(0).setWidth("300px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataUpload().format(FormatDate.DATE_BR.toDTF()))).setHeader("DATA").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getDescricao()))).setHeader("Descri\u00e7\u00e3o").setFlexGrow(0).setWidth("300px");
        this.crud.getGrid().addComponentColumn((ValueProvider & Serializable)item -> {
            Button btn = UIUtils.createSmallButton((String)"Download");
            btn.setVisible(item.getHashArquivo() != null && !item.getHashArquivo().isEmpty());
            btn.setVisible(!item.getHashArquivo().isBlank());
            btn.addClickListener((ComponentEventListener & Serializable)b -> {
                Dialog d = new Dialog();
                String url = StorageUtil.getUrlSign((String)item.getHashArquivo(), (String)"bucket-neosales").getUrl();
                Anchor anchor = new Anchor(url, new Component[0]);
                anchor.getElement().setAttribute("download", true);
                anchor.setText("Download");
                anchor.setTitle("Baixar arquivo");
                anchor.setVisible(!url.isEmpty());
                anchor.setTarget("_blank");
                Button btnClose = UIUtils.createSmallButton((String)"Fechar");
                btnClose.addClickListener((ComponentEventListener & Serializable)close -> d.close());
                d.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"Arquivo pronto para Download"), anchor, btnClose})});
                d.open();
            });
            return btn;
        }).setHeader("Download").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLoginUsuario()))).setHeader("Usu\u00e1rio Upload").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getPerfis()))).setHeader("Perfis").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("MATERIAL_APOIO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }
}

