/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.naoperturbe.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.naoperturbe.repository.NaoPerturbeRepository;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NaoPerturbeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private NaoPerturbeRepository naoPerturbeRepository;
    @Autowired
    private NotificacoesService notificacoesService;

    public boolean isNaoPerturbe(String numero) {
        return this.naoPerturbeRepository.findByNumero(StringUtil.numbersOnly((String)numero)) != null;
    }

    @Async(value="asyncDefault")
    public void processar(EstruturaUsuario eu, Set<String> arquivos) {
        Thread.currentThread().setName("asyncDefault-nao-perturbe-processar");
        StringBuilder log = new StringBuilder();
        this.naoPerturbeRepository.truncate();
        for (String arquivo : arquivos) {
            try {
                this.importar(arquivo);
                log.append(arquivo).append(" processado com sucesso\n");
            }
            catch (Exception e) {
                log.append(arquivo).append(" ERRO ").append(e.getMessage());
            }
        }
        this.naoPerturbeRepository.atualizar();
        this.notificacoesService.notify(eu, "Nao Perturbe", log.toString());
    }

    public static void main(String[] args) {
        new NaoPerturbeService().importar("BLACKLIST_COLAB_RCN1.csv");
    }

    private void importar(String nomeArquivo) {
        try {
            Runtime runtime = Runtime.getRuntime();
            String command = "/usr/bin/gcloud sql import csv mysql-neocrm gs://bucket-neocrm-pub/" + nomeArquivo + " --database=neo_producao --table=nao_perturbe_transit --fields-terminated-by=\"3B\" --quiet";
            Process pro = runtime.exec(command);
            BufferedReader read = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            System.out.println(read);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }
}

